extends Node2D

# Initialize module
var model = GodotRWKV.new()

# Create a thread to handle text processing so it doesnt slow down main thread
var thread: Thread

# Load model when enter tree so that agents can connect on start
func _enter_tree():
	# load model file downloaded from https://huggingface.co/Hazzzardous/8-bit-rwkv-hpp
	# use full path
	model.loadModel("/home/harrison/Downloads/3b.safetensors",64)
	
	# load tokenizer file downloaded from https://huggingface.co/Hazzzardous/8-bit-rwkv-hpp/blob/main/rwkv_vocab_v20230424.txt
	# use full path
	model.loadTokenizer("/home/harrison/Downloads/rwkv_vocab_v20230424.txt")
	
	# create threat
	thread = Thread.new()
	
	# start thread
	thread.start(proc)

# simply loop and process
func proc():
	while(1):
		model.listen()
	
	
