/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.Label;
import edu.stanford.nlp.ling.Sentence;
import edu.stanford.nlp.ling.StringLabel;
import edu.stanford.nlp.ling.StringLabelFactory;
import edu.stanford.nlp.ling.TaggedWord;
import edu.stanford.nlp.process.PTBTokenizer;
import edu.stanford.nlp.trees.BobChrisTreeNormalizer;
import edu.stanford.nlp.trees.CollocationFinder;
import edu.stanford.nlp.trees.Dependencies;
import edu.stanford.nlp.trees.Dependency;
import edu.stanford.nlp.trees.DiskTreebank;
import edu.stanford.nlp.trees.GrammaticalStructure;
import edu.stanford.nlp.trees.GrammaticalStructureFactory;
import edu.stanford.nlp.trees.HeadFinder;
import edu.stanford.nlp.trees.LabeledScoredTreeFactory;
import edu.stanford.nlp.trees.NamedDependency;
import edu.stanford.nlp.trees.PennTreeReader;
import edu.stanford.nlp.trees.PennTreebankLanguagePack;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeFunctions;
import edu.stanford.nlp.trees.TreeNormalizer;
import edu.stanford.nlp.trees.TreeReader;
import edu.stanford.nlp.trees.TreeReaderFactory;
import edu.stanford.nlp.trees.TreeTransformer;
import edu.stanford.nlp.trees.TreebankLanguagePack;
import edu.stanford.nlp.trees.Trees;
import edu.stanford.nlp.trees.TypedDependency;
import edu.stanford.nlp.trees.WordNetConnection;
import edu.stanford.nlp.trees.WordStemmer;
import edu.stanford.nlp.trees.international.pennchinese.ChineseEnglishWordMap;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.Filter;
import edu.stanford.nlp.util.Filters;
import edu.stanford.nlp.util.Function;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.ScoredObject;
import edu.stanford.nlp.util.StringUtils;
import edu.stanford.nlp.util.XMLUtils;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class TreePrint {
    public static final String rootLabelOnlyFormat = "rootSymbolOnly";
    public static final String headMark = "=H";
    public static final String[] outputTreeFormats = new String[]{"penn", "oneline", "rootSymbolOnly", "words", "wordsAndTags", "dependencies", "typedDependencies", "typedDependenciesCollapsed", "latexTree", "xmlTree", "collocations", "semanticGraph", "conllStyleDependencies", "conll2007"};
    private final Properties formats;
    private final Properties options;
    private final boolean markHeadNodes;
    private final boolean lexicalize;
    private final boolean removeEmpty;
    private final boolean ptb2text;
    private final boolean transChinese;
    private final boolean basicDependencies;
    private final boolean collapsedDependencies;
    private final boolean nonCollapsedDependencies;
    private final boolean nonCollapsedDependenciesSeparated;
    private final boolean CCPropagatedDependencies;
    private final boolean treeDependencies;
    private final boolean includeTags;
    private final HeadFinder hf;
    private final TreebankLanguagePack tlp;
    private final WordStemmer stemmer;
    private final Filter<Dependency<Label, Label, Object>> dependencyFilter;
    private final Filter<Dependency<Label, Label, Object>> dependencyWordFilter;
    private final GrammaticalStructureFactory gsf;
    private static WordNetConnection wnc;
    private final PrintWriter pw = new PrintWriter(System.out, true);

    public TreePrint(String formats) {
        this(formats, "", new PennTreebankLanguagePack());
    }

    public TreePrint(String formats, TreebankLanguagePack tlp) {
        this(formats, "", tlp);
    }

    public TreePrint(String formats, String options, TreebankLanguagePack tlp) {
        this(formats, options, tlp, tlp.headFinder(), tlp.typedDependencyHeadFinder());
    }

    public TreePrint(String formatString, String optionsString, TreebankLanguagePack tlp, HeadFinder hf, HeadFinder typedDependencyHF) {
        Filter<String> puncWordFilter;
        this.formats = StringUtils.stringToProperties(formatString);
        this.options = StringUtils.stringToProperties(optionsString);
        List<String> okOutputs = Arrays.asList(outputTreeFormats);
        for (Object formObj : this.formats.keySet()) {
            String format = (String)formObj;
            if (okOutputs.contains(format)) continue;
            throw new RuntimeException("Error: output tree format " + format + " not supported. Known formats are: " + okOutputs);
        }
        this.hf = hf;
        this.tlp = tlp;
        boolean includePunctuationDependencies = TreePrint.propertyToBoolean(this.options, "includePunctuationDependencies");
        if (includePunctuationDependencies) {
            this.dependencyFilter = Filters.acceptFilter();
            this.dependencyWordFilter = Filters.acceptFilter();
            puncWordFilter = Filters.acceptFilter();
        } else {
            this.dependencyFilter = new Dependencies.DependentPuncTagRejectFilter<Label, Label, Object>(tlp.punctuationTagRejectFilter());
            this.dependencyWordFilter = new Dependencies.DependentPuncWordRejectFilter<Label, Label, Object>(tlp.punctuationWordRejectFilter());
            puncWordFilter = tlp.punctuationWordRejectFilter();
        }
        this.stemmer = TreePrint.propertyToBoolean(this.options, "stem") ? new WordStemmer() : null;
        this.gsf = this.formats.containsKey("typedDependenciesCollapsed") || this.formats.containsKey("typedDependencies") || this.formats.containsKey("conll2007") && tlp.supportsGrammaticalStructures() ? tlp.grammaticalStructureFactory(puncWordFilter, typedDependencyHF) : null;
        this.lexicalize = TreePrint.propertyToBoolean(this.options, "lexicalize");
        this.markHeadNodes = TreePrint.propertyToBoolean(this.options, "markHeadNodes");
        this.transChinese = TreePrint.propertyToBoolean(this.options, "transChinese");
        this.ptb2text = TreePrint.propertyToBoolean(this.options, "ptb2text");
        this.removeEmpty = TreePrint.propertyToBoolean(this.options, "noempty") || this.ptb2text;
        this.basicDependencies = TreePrint.propertyToBoolean(this.options, "basicDependencies");
        this.collapsedDependencies = TreePrint.propertyToBoolean(this.options, "collapsedDependencies");
        this.nonCollapsedDependencies = TreePrint.propertyToBoolean(this.options, "nonCollapsedDependencies");
        this.nonCollapsedDependenciesSeparated = TreePrint.propertyToBoolean(this.options, "nonCollapsedDependenciesSeparated");
        this.treeDependencies = TreePrint.propertyToBoolean(this.options, "treeDependencies");
        this.includeTags = TreePrint.propertyToBoolean(this.options, "includeTags");
        this.CCPropagatedDependencies = !this.basicDependencies && !this.collapsedDependencies && !this.nonCollapsedDependencies && !this.nonCollapsedDependenciesSeparated && !this.treeDependencies ? true : TreePrint.propertyToBoolean(this.options, "CCPropagatedDependencies");
    }

    private static boolean propertyToBoolean(Properties prop, String key) {
        return Boolean.parseBoolean(prop.getProperty(key));
    }

    public void printTree(Tree t) {
        this.printTree(t, this.pw);
    }

    public void printTree(Tree t, PrintWriter pw) {
        this.printTree(t, "", pw);
    }

    public void printTree(Tree t, String id, PrintWriter pw) {
        boolean inXml = TreePrint.propertyToBoolean(this.options, "xml");
        if (t == null) {
            if (inXml) {
                pw.print("<s");
                if (id != null && !"".equals(id)) {
                    pw.print(" id=\"" + XMLUtils.escapeXML(id) + '\"');
                }
                pw.println(" skipped=\"true\"/>");
                pw.println();
            } else {
                pw.println("SENTENCE_SKIPPED_OR_UNPARSABLE");
            }
        } else {
            if (inXml) {
                pw.print("<s");
                if (id != null && !"".equals(id)) {
                    pw.print(" id=\"" + XMLUtils.escapeXML(id) + '\"');
                }
                pw.println(">");
            }
            this.printTreeInternal(t, pw, inXml);
            if (inXml) {
                pw.println("</s>");
                pw.println();
            }
        }
    }

    public void printTrees(List<ScoredObject<Tree>> trees, String id, PrintWriter pw) {
        boolean inXml = TreePrint.propertyToBoolean(this.options, "xml");
        int ii = 0;
        for (ScoredObject<Tree> tp : trees) {
            ++ii;
            Tree t = tp.object();
            double score = tp.score();
            if (t == null) {
                if (inXml) {
                    pw.print("<s");
                    if (id != null && !"".equals(id)) {
                        pw.print(" id=\"" + XMLUtils.escapeXML(id) + '\"');
                    }
                    pw.print(" n=\"");
                    pw.print(ii);
                    pw.print('\"');
                    pw.print(" score=\"" + score + '\"');
                    pw.println(" skipped=\"true\"/>");
                    pw.println();
                    continue;
                }
                pw.println("SENTENCE_SKIPPED_OR_UNPARSABLE Parse #" + ii + " with score " + score);
                continue;
            }
            if (inXml) {
                pw.print("<s");
                if (id != null && !"".equals(id)) {
                    pw.print(" id=\"");
                    pw.print(XMLUtils.escapeXML(id));
                    pw.print('\"');
                }
                pw.print(" n=\"");
                pw.print(ii);
                pw.print('\"');
                pw.print(" score=\"");
                pw.print(score);
                pw.print('\"');
                pw.println(">");
            } else {
                pw.print("# Parse ");
                pw.print(ii);
                pw.print(" with score ");
                pw.println(score);
            }
            this.printTreeInternal(t, pw, inXml);
            if (!inXml) continue;
            pw.println("</s>");
            pw.println();
        }
    }

    /*
     * WARNING - void declaration
     */
    private void printTreeInternal(Tree t, PrintWriter pw, boolean inXml) {
        List<Dependency<Label, Label, Object>> sortedDeps;
        Function<Tree, Tree> a;
        String s;
        Tree outputTree = t;
        if (this.formats.containsKey("conll2007") || this.removeEmpty) {
            outputTree = outputTree.prune(new BobChrisTreeNormalizer.EmptyFilter());
        }
        if (this.formats.containsKey("words")) {
            if (inXml) {
                ArrayList<Label> sentUnstemmed = outputTree.yield();
                pw.println("  <words>");
                int i = 1;
                for (Label w : sentUnstemmed) {
                    pw.println("    <word ind=\"" + i + "\">" + XMLUtils.escapeXML(w.value()) + "</word>");
                    ++i;
                }
                pw.println("  </words>");
            } else {
                String sent = Sentence.listToString(outputTree.yield(), false);
                if (this.ptb2text) {
                    pw.println(PTBTokenizer.ptb2Text(sent));
                } else {
                    pw.println(sent);
                    pw.println();
                }
            }
        }
        if (TreePrint.propertyToBoolean(this.options, "removeTopBracket") && this.tlp.isStartSymbol(s = outputTree.label().value())) {
            if (outputTree.isUnaryRewrite()) {
                outputTree = outputTree.firstChild();
            } else {
                System.err.println("TreePrint: can't remove top bracket: not unary");
            }
        }
        if (this.stemmer != null) {
            this.stemmer.visitTree(outputTree);
        }
        if (this.lexicalize) {
            outputTree = Trees.lexicalize(outputTree, this.hf);
            a = TreeFunctions.getLabeledToDescriptiveCoreLabelTreeFunction();
            outputTree = a.apply(outputTree);
        }
        if (this.formats.containsKey("collocations")) {
            outputTree = TreePrint.getCollocationProcessedTree(outputTree, this.hf);
        }
        if (!this.lexicalize) {
            a = TreeFunctions.getLabeledTreeToStringLabeledTreeFunction();
            outputTree = a.apply(outputTree);
        }
        Tree outputPSTree = outputTree;
        if (this.markHeadNodes) {
            outputPSTree = this.markHeadNodes(outputPSTree);
        }
        if (this.transChinese) {
            TreeTransformer tt = new TreeTransformer(){

                @Override
                public Tree transformTree(Tree t) {
                    t = t.treeSkeletonCopy();
                    for (Tree subtree : t) {
                        if (!subtree.isLeaf()) continue;
                        Label oldLabel = subtree.label();
                        String translation = ChineseEnglishWordMap.getInstance().getFirstTranslation(oldLabel.value());
                        if (translation == null) {
                            translation = "[UNK]";
                        }
                        StringLabel newLabel = new StringLabel(oldLabel.value() + ':' + translation);
                        subtree.setLabel(newLabel);
                    }
                    return t;
                }
            };
            outputPSTree = tt.transformTree(outputPSTree);
        }
        if (TreePrint.propertyToBoolean(this.options, "xml")) {
            PrintWriter psw;
            if (this.formats.containsKey("wordsAndTags")) {
                ArrayList<TaggedWord> sent = outputTree.taggedYield();
                pw.println("  <words pos=\"true\">");
                int i = 1;
                for (TaggedWord taggedWord : sent) {
                    pw.println("    <word ind=\"" + i + "\" pos=\"" + XMLUtils.escapeXML(taggedWord.tag()) + "\">" + XMLUtils.escapeXML(taggedWord.word()) + "</word>");
                    ++i;
                }
                pw.println("  </words>");
            }
            if (this.formats.containsKey("penn")) {
                pw.println("  <tree style=\"penn\">");
                StringWriter sw = new StringWriter();
                psw = new PrintWriter(sw);
                outputPSTree.pennPrint(psw);
                pw.print(XMLUtils.escapeXML(sw.toString()));
                pw.println("  </tree>");
            }
            if (this.formats.containsKey("latexTree")) {
                pw.println("    <tree style=\"latexTrees\">");
                pw.println(".[");
                StringWriter sw = new StringWriter();
                psw = new PrintWriter(sw);
                outputTree.indentedListPrint(psw, false);
                pw.print(XMLUtils.escapeXML(sw.toString()));
                pw.println(".]");
                pw.println("  </tree>");
            }
            if (this.formats.containsKey("xmlTree")) {
                pw.println("<tree style=\"xml\">");
                outputTree.indentedXMLPrint(pw, false);
                pw.println("</tree>");
            }
            if (this.formats.containsKey("dependencies")) {
                Tree indexedTree = outputTree.deepCopy(outputTree.treeFactory(), CoreLabel.factory());
                indexedTree.indexLeaves();
                Set<Dependency<Label, Label, Object>> depsSet = indexedTree.mapDependencies(this.dependencyWordFilter, this.hf);
                sortedDeps = new ArrayList<Dependency<Label, Label, Object>>(depsSet);
                Collections.sort(sortedDeps, Dependencies.dependencyIndexComparator());
                pw.println("<dependencies style=\"untyped\">");
                for (Dependency dependency : sortedDeps) {
                    pw.println(dependency.toString("xml"));
                }
                pw.println("</dependencies>");
            }
            if (this.formats.containsKey("conll2007") || this.formats.containsKey("conllStyleDependencies")) {
                System.err.println("The \"conll2007\" and \"conllStyleDependencies\" formats are ignored in xml.");
            }
            if (this.formats.containsKey("typedDependencies")) {
                GrammaticalStructure gs = this.gsf.newGrammaticalStructure(outputTree);
                if (this.basicDependencies) {
                    TreePrint.print(gs.typedDependencies(), "xml", this.includeTags, pw);
                }
                if (this.nonCollapsedDependencies || this.nonCollapsedDependenciesSeparated) {
                    TreePrint.print(gs.allTypedDependencies(), "xml", this.includeTags, pw);
                }
                if (this.collapsedDependencies) {
                    TreePrint.print(gs.typedDependenciesCollapsed(true), "xml", this.includeTags, pw);
                }
                if (this.CCPropagatedDependencies) {
                    TreePrint.print(gs.typedDependenciesCCprocessed(), "xml", this.includeTags, pw);
                }
                if (this.treeDependencies) {
                    TreePrint.print(gs.typedDependenciesCollapsedTree(), "xml", this.includeTags, pw);
                }
            }
            if (this.formats.containsKey("typedDependenciesCollapsed")) {
                GrammaticalStructure gs = this.gsf.newGrammaticalStructure(outputTree);
                TreePrint.print(gs.typedDependenciesCCprocessed(), "xml", this.includeTags, pw);
            }
        } else {
            String tag;
            if (this.formats.containsKey("wordsAndTags")) {
                pw.println(Sentence.listToString(outputTree.taggedYield(), false));
                pw.println();
            }
            if (this.formats.containsKey("oneline")) {
                pw.println(outputPSTree.toString());
            }
            if (this.formats.containsKey("penn")) {
                outputPSTree.pennPrint(pw);
                pw.println();
            }
            if (this.formats.containsKey(rootLabelOnlyFormat)) {
                pw.println(outputTree.label().value());
            }
            if (this.formats.containsKey("latexTree")) {
                pw.println(".[");
                outputTree.indentedListPrint(pw, false);
                pw.println(".]");
            }
            if (this.formats.containsKey("xmlTree")) {
                outputTree.indentedXMLPrint(pw, false);
            }
            if (this.formats.containsKey("dependencies")) {
                Tree indexedTree = outputTree.deepCopy(outputTree.treeFactory());
                indexedTree.indexLeaves();
                List<Dependency<Label, Label, Object>> sortedDeps2 = this.getSortedDeps(indexedTree, this.dependencyWordFilter);
                for (Dependency dependency : sortedDeps2) {
                    pw.println(dependency.toString("predicate"));
                }
                pw.println();
            }
            if (this.formats.containsKey("conll2007")) {
                void var9_26;
                Tree it = outputTree.deepCopy(outputTree.treeFactory(), CoreLabel.factory());
                it.indexLeaves();
                List<CoreLabel> tagged = it.taggedLabeledYield();
                sortedDeps = this.getSortedDeps(it, Filters.<Dependency<Label, Label, Object>>acceptFilter());
                boolean bl = false;
                while (var9_26 < sortedDeps.size()) {
                    Dependency<Label, Label, Object> dependency = sortedDeps.get((int)var9_26);
                    if (this.dependencyFilter.accept(dependency)) {
                        CoreMap dep = (CoreMap)((Object)dependency.dependent());
                        CoreMap gov = (CoreMap)((Object)dependency.governor());
                        Integer depi = (Integer)dep.get(CoreAnnotations.IndexAnnotation.class);
                        Integer govi = (Integer)gov.get(CoreAnnotations.IndexAnnotation.class);
                        CoreLabel w = tagged.get(depi - 1);
                        tag = PTBTokenizer.ptbToken2Text(w.tag());
                        String word = PTBTokenizer.ptbToken2Text(w.word());
                        String lemma = "_";
                        String feats = "_";
                        String pHead = "_";
                        String pDepRel = "_";
                        String depRel = dependency.name() != null ? dependency.name().toString() : (govi == 0 ? "ROOT" : "NULL");
                        pw.printf("%d\t%s\t%s\t%s\t%s\t%s\t%d\t%s\t%s\t%s%n", depi, word, lemma, tag, tag, feats, govi, depRel, pHead, pDepRel);
                    }
                    ++var9_26;
                }
                pw.println();
            }
            if (this.formats.containsKey("conllStyleDependencies")) {
                boolean bl;
                BobChrisTreeNormalizer tn = new BobChrisTreeNormalizer();
                Tree indexedTree = outputTree.deepCopy(outputTree.treeFactory(), CoreLabel.factory());
                for (Tree tree : indexedTree) {
                    if (!tree.label().value().startsWith("NML")) continue;
                    tree.label().setValue("NP");
                }
                indexedTree = tn.normalizeWholeTree(indexedTree, outputTree.treeFactory());
                indexedTree.indexLeaves();
                Set<Dependency<Label, Label, Object>> depsSet = null;
                boolean bl2 = false;
                try {
                    depsSet = indexedTree.mapDependencies(this.dependencyFilter, this.hf);
                }
                catch (Exception exception) {
                    bl = true;
                }
                if (bl) {
                    System.err.println("failed: ");
                    System.err.println(t);
                    System.err.println();
                } else {
                    Map<Integer, Integer> map = Generics.newHashMap();
                    for (Dependency<Label, Label, Object> dep : depsSet) {
                        CoreLabel child = (CoreLabel)dep.dependent();
                        CoreLabel parent = (CoreLabel)dep.governor();
                        Integer childIndex = (Integer)child.get(CoreAnnotations.IndexAnnotation.class);
                        Integer parentIndex = (Integer)parent.get(CoreAnnotations.IndexAnnotation.class);
                        map.put(childIndex, parentIndex);
                    }
                    boolean foundRoot = false;
                    int index = 1;
                    for (Tree node : indexedTree.getLeaves()) {
                        String word = node.label().value();
                        tag = node.parent(indexedTree).label().value();
                        int parent = 0;
                        if (map.containsKey(index)) {
                            parent = (Integer)map.get(index);
                        } else {
                            if (foundRoot) {
                                throw new RuntimeException();
                            }
                            foundRoot = true;
                        }
                        pw.println(index + "\t" + word + "\t" + tag + "\t" + parent);
                        ++index;
                    }
                    pw.println();
                }
            }
            if (this.formats.containsKey("typedDependencies")) {
                GrammaticalStructure gs = this.gsf.newGrammaticalStructure(outputTree);
                if (this.basicDependencies) {
                    TreePrint.print(gs.typedDependencies(), this.includeTags, pw);
                }
                if (this.nonCollapsedDependencies) {
                    TreePrint.print(gs.allTypedDependencies(), this.includeTags, pw);
                }
                if (this.nonCollapsedDependenciesSeparated) {
                    TreePrint.print(gs.allTypedDependencies(), "separator", this.includeTags, pw);
                }
                if (this.collapsedDependencies) {
                    TreePrint.print(gs.typedDependenciesCollapsed(true), this.includeTags, pw);
                }
                if (this.CCPropagatedDependencies) {
                    TreePrint.print(gs.typedDependenciesCCprocessed(), this.includeTags, pw);
                }
                if (this.treeDependencies) {
                    TreePrint.print(gs.typedDependenciesCollapsedTree(), this.includeTags, pw);
                }
            }
            if (this.formats.containsKey("typedDependenciesCollapsed")) {
                GrammaticalStructure gs = this.gsf.newGrammaticalStructure(outputTree);
                TreePrint.print(gs.typedDependenciesCCprocessed(), this.includeTags, pw);
            }
        }
        pw.flush();
    }

    private List<Dependency<Label, Label, Object>> getSortedDeps(Tree tree, Filter<Dependency<Label, Label, Object>> filter) {
        if (this.gsf != null) {
            GrammaticalStructure gs = this.gsf.newGrammaticalStructure(tree);
            List<TypedDependency> deps = gs.typedDependencies(false);
            ArrayList<Dependency<Label, Label, Object>> sortedDeps = new ArrayList<Dependency<Label, Label, Object>>();
            for (TypedDependency dep : deps) {
                sortedDeps.add(new NamedDependency(dep.gov().label(), dep.dep().label(), (Object)dep.reln().toString()));
            }
            Collections.sort(sortedDeps, Dependencies.dependencyIndexComparator());
            return sortedDeps;
        }
        Set<Dependency<Label, Label, Object>> depsSet = tree.mapDependencies(filter, this.hf, "root");
        ArrayList<Dependency<Label, Label, Object>> sortedDeps = new ArrayList<Dependency<Label, Label, Object>>(depsSet);
        Collections.sort(sortedDeps, Dependencies.dependencyIndexComparator());
        return sortedDeps;
    }

    private static synchronized Tree getCollocationProcessedTree(Tree tree, HeadFinder hf) {
        if (wnc == null) {
            try {
                Class<?> cl = Class.forName("edu.stanford.nlp.trees.WordNetInstance");
                wnc = (WordNetConnection)cl.newInstance();
            }
            catch (Exception e) {
                System.err.println("Couldn't open WordNet Connection.  Aborting collocation detection.");
                e.printStackTrace();
                wnc = null;
            }
        }
        if (wnc != null) {
            CollocationFinder cf = new CollocationFinder(tree, wnc, hf);
            tree = cf.getMangledTree();
        } else {
            System.err.println("ERROR: WordNetConnection unavailable for collocations.");
        }
        return tree;
    }

    public void printHeader(PrintWriter pw, String charset) {
        if (TreePrint.propertyToBoolean(this.options, "xml")) {
            pw.println("<?xml version=\"1.0\" encoding=\"" + charset + "\"?>");
            pw.println("<corpus>");
        }
    }

    public void printFooter(PrintWriter pw) {
        if (TreePrint.propertyToBoolean(this.options, "xml")) {
            pw.println("</corpus>");
        }
    }

    public Tree markHeadNodes(Tree t) {
        return this.markHeadNodes(t, null);
    }

    private Tree markHeadNodes(Tree t, Tree head) {
        if (t.isLeaf()) {
            return t;
        }
        Label newLabel = t == head ? TreePrint.headMark(t.label()) : t.label();
        Tree newHead = this.hf.determineHead(t);
        return t.treeFactory().newTreeNode(newLabel, Arrays.asList(this.headMarkChildren(t, newHead)));
    }

    private static Label headMark(Label l) {
        Label l1 = l.labelFactory().newLabel(l);
        l1.setValue(l1.value() + headMark);
        return l1;
    }

    private Tree[] headMarkChildren(Tree t, Tree head) {
        Tree[] kids = t.children();
        Tree[] newKids = new Tree[kids.length];
        int n = kids.length;
        for (int i = 0; i < n; ++i) {
            newKids[i] = this.markHeadNodes(kids[i], head);
        }
        return newKids;
    }

    public static void main(String[] args) {
        Iterator<Tree> i;
        HeadFinder hf;
        TreebankLanguagePack tlp;
        String format = "penn";
        String options = "";
        String tlpName = "edu.stanford.nlp.trees.PennTreebankLanguagePack";
        String hfName = null;
        Map<String, Integer> flagMap = Generics.newHashMap();
        flagMap.put("-format", 1);
        flagMap.put("-options", 1);
        flagMap.put("-tLP", 1);
        flagMap.put("-hf", 1);
        Map<String, String[]> argsMap = StringUtils.argsToMap(args, flagMap);
        args = argsMap.get(null);
        if (argsMap.keySet().contains("-format")) {
            format = argsMap.get("-format")[0];
        }
        if (argsMap.keySet().contains("-options")) {
            options = argsMap.get("-options")[0];
        }
        if (argsMap.keySet().contains("-tLP")) {
            tlpName = argsMap.get("-tLP")[0];
        }
        if (argsMap.keySet().contains("-hf")) {
            hfName = argsMap.get("-hf")[0];
        }
        try {
            tlp = (TreebankLanguagePack)Class.forName(tlpName).newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        if (hfName != null) {
            try {
                hf = (HeadFinder)Class.forName(hfName).newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
        } else {
            hf = tlp.headFinder();
        }
        TreePrint print = new TreePrint(format, options, tlp, hf == null ? tlp.headFinder() : hf, tlp.typedDependencyHeadFinder());
        if (args.length > 0) {
            TreeReaderFactory trf = argsMap.keySet().contains("-useTLPTreeReader") ? tlp.treeReaderFactory() : new TreeReaderFactory(){

                @Override
                public TreeReader newTreeReader(Reader in) {
                    return new PennTreeReader(in, new LabeledScoredTreeFactory(new StringLabelFactory()), new TreeNormalizer());
                }
            };
            DiskTreebank trees = new DiskTreebank(trf);
            trees.loadPath(args[0]);
            i = ((AbstractCollection)trees).iterator();
        } else {
            i = tlp.treeTokenizerFactory().getTokenizer(new BufferedReader(new InputStreamReader(System.in)));
        }
        while (i.hasNext()) {
            print.printTree((Tree)i.next());
        }
    }

    private static String toString(Collection<TypedDependency> dependencies, String format, boolean includeTags) {
        if (format != null && format.equals("xml")) {
            return TreePrint.toXMLString(dependencies, includeTags);
        }
        if (format != null && format.equals("readable")) {
            return TreePrint.toReadableString(dependencies);
        }
        if (format != null && format.equals("separator")) {
            return TreePrint.toString(dependencies, true, includeTags);
        }
        return TreePrint.toString(dependencies, false, includeTags);
    }

    private static String toString(Collection<TypedDependency> dependencies, boolean extraSep, boolean includeTags) {
        StringBuilder buf;
        block5: {
            CoreLabel.OutputFormat labelFormat;
            block4: {
                labelFormat = includeTags ? CoreLabel.OutputFormat.VALUE_TAG_INDEX : CoreLabel.OutputFormat.VALUE_INDEX;
                buf = new StringBuilder();
                if (!extraSep) break block4;
                ArrayList<TypedDependency> extraDeps = new ArrayList<TypedDependency>();
                for (TypedDependency td : dependencies) {
                    if (td.extra()) {
                        extraDeps.add(td);
                        continue;
                    }
                    buf.append(td.toString(labelFormat)).append('\n');
                }
                if (extraDeps.isEmpty()) break block5;
                buf.append("======\n");
                for (TypedDependency td : extraDeps) {
                    buf.append(td.toString(labelFormat)).append('\n');
                }
                break block5;
            }
            for (TypedDependency td : dependencies) {
                buf.append(td.toString(labelFormat)).append('\n');
            }
        }
        return buf.toString();
    }

    private static String toReadableString(Collection<TypedDependency> dependencies) {
        StringBuilder buf = new StringBuilder();
        buf.append(String.format("%-20s%-20s%-20s%n", "dep", "reln", "gov"));
        buf.append(String.format("%-20s%-20s%-20s%n", "---", "----", "---"));
        for (TypedDependency td : dependencies) {
            buf.append(String.format("%-20s%-20s%-20s%n", td.dep(), td.reln(), td.gov()));
        }
        return buf.toString();
    }

    private static String toXMLString(Collection<TypedDependency> dependencies, boolean includeTags) {
        StringBuilder buf = new StringBuilder("<dependencies style=\"typed\">\n");
        for (TypedDependency td : dependencies) {
            String reln = td.reln().toString();
            String gov = td.gov().value();
            String govTag = td.gov().label().tag();
            int govIdx = td.gov().index();
            String dep = td.dep().value();
            String depTag = td.dep().label().tag();
            int depIdx = td.dep().index();
            boolean extra = td.extra();
            String govCopy = "";
            Integer copyGov = (Integer)td.gov().label.get(CoreAnnotations.CopyAnnotation.class);
            if (copyGov != null) {
                govCopy = " copy=\"" + copyGov + '\"';
            }
            String depCopy = "";
            Integer copyDep = (Integer)td.dep().label.get(CoreAnnotations.CopyAnnotation.class);
            if (copyDep != null) {
                depCopy = " copy=\"" + copyDep + '\"';
            }
            String govTagAttribute = includeTags && govTag != null ? " tag=\"" + govTag + "\"" : "";
            String depTagAttribute = includeTags && depTag != null ? " tag=\"" + depTag + "\"" : "";
            String extraAttr = "";
            if (extra) {
                extraAttr = " extra=\"yes\"";
            }
            buf.append("  <dep type=\"").append(XMLUtils.escapeXML(reln)).append('\"').append(extraAttr).append(">\n");
            buf.append("    <governor idx=\"").append(govIdx).append('\"').append(govCopy).append(govTagAttribute).append('>').append(XMLUtils.escapeXML(gov)).append("</governor>\n");
            buf.append("    <dependent idx=\"").append(depIdx).append('\"').append(depCopy).append(depTagAttribute).append('>').append(XMLUtils.escapeXML(dep)).append("</dependent>\n");
            buf.append("  </dep>\n");
        }
        buf.append("</dependencies>");
        return buf.toString();
    }

    public static void print(Collection<TypedDependency> dependencies, boolean includeTags, PrintWriter pw) {
        pw.println(TreePrint.toString(dependencies, false, includeTags));
    }

    public static void print(Collection<TypedDependency> dependencies, String format, boolean includeTags, PrintWriter pw) {
        pw.println(TreePrint.toString(dependencies, format, includeTags));
    }
}

