/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.Annotator;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.concurrent.InterruptibleMulticoreWrapper;
import edu.stanford.nlp.util.concurrent.ThreadsafeProcessor;
import java.util.List;
import java.util.concurrent.RejectedExecutionException;

public abstract class SentenceAnnotator
implements Annotator {
    private InterruptibleMulticoreWrapper<CoreMap, CoreMap> buildWrapper(Annotation annotation) {
        InterruptibleMulticoreWrapper<CoreMap, CoreMap> wrapper = new InterruptibleMulticoreWrapper<CoreMap, CoreMap>(this.nThreads(), new AnnotatorProcessor(annotation), true, this.maxTime());
        return wrapper;
    }

    @Override
    public void annotate(Annotation annotation) {
        if (annotation.containsKey(CoreAnnotations.SentencesAnnotation.class)) {
            if (this.nThreads() != 1 || this.maxTime() > 0L) {
                InterruptibleMulticoreWrapper<CoreMap, CoreMap> wrapper = this.buildWrapper(annotation);
                for (CoreMap sentence : (List)annotation.get(CoreAnnotations.SentencesAnnotation.class)) {
                    boolean success = false;
                    for (int attempt = 0; attempt < 2; ++attempt) {
                        try {
                            wrapper.put(sentence);
                            success = true;
                            break;
                        }
                        catch (RejectedExecutionException e) {
                            List<CoreMap> failedSentences = wrapper.joinWithTimeout();
                            if (failedSentences != null) {
                                for (CoreMap failed : failedSentences) {
                                    this.doOneFailedSentence(annotation, failed);
                                }
                            }
                            wrapper = this.buildWrapper(annotation);
                            continue;
                        }
                    }
                    if (!success) {
                        this.doOneFailedSentence(annotation, sentence);
                    }
                    while (wrapper.peek()) {
                        wrapper.poll();
                    }
                }
                List<CoreMap> failedSentences = wrapper.joinWithTimeout();
                while (wrapper.peek()) {
                    wrapper.poll();
                }
                if (failedSentences != null) {
                    for (CoreMap failed : failedSentences) {
                        this.doOneFailedSentence(annotation, failed);
                    }
                }
            } else {
                for (CoreMap sentence : (List)annotation.get(CoreAnnotations.SentencesAnnotation.class)) {
                    this.doOneSentence(annotation, sentence);
                }
            }
        } else {
            throw new RuntimeException("unable to find sentences in: " + annotation);
        }
    }

    protected abstract int nThreads();

    protected abstract long maxTime();

    protected abstract void doOneSentence(Annotation var1, CoreMap var2);

    protected abstract void doOneFailedSentence(Annotation var1, CoreMap var2);

    protected class AnnotatorProcessor
    implements ThreadsafeProcessor<CoreMap, CoreMap> {
        final Annotation annotation;

        AnnotatorProcessor(Annotation annotation) {
            this.annotation = annotation;
        }

        @Override
        public CoreMap process(CoreMap sentence) {
            SentenceAnnotator.this.doOneSentence(this.annotation, sentence);
            return sentence;
        }

        @Override
        public ThreadsafeProcessor<CoreMap, CoreMap> newInstance() {
            return this;
        }
    }
}

