/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.lmdbjni;

import java.nio.ByteBuffer;
import org.fusesource.lmdbjni.Constants;
import org.fusesource.lmdbjni.DirectBuffer;
import org.fusesource.lmdbjni.Entry;
import org.fusesource.lmdbjni.GetOp;
import org.fusesource.lmdbjni.JNI;
import org.fusesource.lmdbjni.NativeBuffer;
import org.fusesource.lmdbjni.NativeObject;
import org.fusesource.lmdbjni.SeekOp;
import org.fusesource.lmdbjni.Transaction;
import org.fusesource.lmdbjni.Unsafe;
import org.fusesource.lmdbjni.Util;
import org.fusesource.lmdbjni.Value;

public class Cursor
extends NativeObject
implements AutoCloseable {
    DirectBuffer buffer;
    long bufferAddress;
    boolean isReadOnly;

    Cursor(long self, boolean isReadOnly) {
        super(self);
        this.isReadOnly = isReadOnly;
    }

    @Override
    public void close() {
        if (this.self != 0L) {
            JNI.mdb_cursor_close(this.self);
            this.self = 0L;
        }
    }

    public void renew(Transaction tx) {
        Util.checkErrorCode(JNI.mdb_cursor_renew(tx.pointer(), this.pointer()));
    }

    public Entry get(GetOp op) {
        Util.checkArgNotNull((Object)op, "op");
        Value key = new Value();
        Value value = new Value();
        int rc = JNI.mdb_cursor_get(this.pointer(), key, value, op.getValue());
        if (rc == JNI.MDB_NOTFOUND) {
            return null;
        }
        Util.checkErrorCode(rc);
        return new Entry(key.toByteArray(), value.toByteArray());
    }

    public int position(DirectBuffer key, DirectBuffer value, GetOp op) {
        if (this.buffer == null) {
            this.buffer = new DirectBuffer(ByteBuffer.allocateDirect(Unsafe.ADDRESS_SIZE * 4));
            this.bufferAddress = this.buffer.addressOffset();
        }
        Util.checkArgNotNull((Object)op, "op");
        int rc = JNI.mdb_cursor_get_address(this.pointer(), this.bufferAddress, this.bufferAddress + (long)(2 * Unsafe.ADDRESS_SIZE), op.getValue());
        if (rc == JNI.MDB_NOTFOUND) {
            return rc;
        }
        Util.checkErrorCode(rc);
        this.wrapBufferAddress(key, value);
        return rc;
    }

    public int seekPosition(DirectBuffer key, DirectBuffer value, SeekOp op) {
        Util.checkArgNotNull(key, "key");
        Util.checkArgNotNull(value, "value");
        Util.checkArgNotNull((Object)op, "op");
        if (this.buffer == null) {
            this.buffer = new DirectBuffer(ByteBuffer.allocateDirect(Unsafe.ADDRESS_SIZE * 4));
            this.bufferAddress = this.buffer.addressOffset();
        }
        Unsafe.putLong(this.bufferAddress, 0, key.capacity());
        Unsafe.putLong(this.bufferAddress, 1, key.addressOffset());
        int rc = JNI.mdb_cursor_get_address(this.pointer(), this.bufferAddress, this.bufferAddress + (long)(2 * Unsafe.ADDRESS_SIZE), op.getValue());
        if (rc == JNI.MDB_NOTFOUND) {
            return rc;
        }
        Util.checkErrorCode(rc);
        this.wrapBufferAddress(key, value);
        return rc;
    }

    private void wrapBufferAddress(DirectBuffer key, DirectBuffer value) {
        int keySize = (int)Unsafe.getLong(this.bufferAddress, 0);
        key.wrap(Unsafe.getAddress(this.bufferAddress, 1), keySize);
        int valSize = (int)Unsafe.getLong(this.bufferAddress, 2);
        value.wrap(Unsafe.getAddress(this.bufferAddress, 3), valSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Entry seek(SeekOp op, byte[] key) {
        Util.checkArgNotNull(key, "key");
        Util.checkArgNotNull((Object)op, "op");
        NativeBuffer keyBuffer = NativeBuffer.create(key);
        try {
            Value keyValue = new Value(keyBuffer);
            Value value = new Value();
            int rc = JNI.mdb_cursor_get(this.pointer(), keyValue, value, op.getValue());
            if (rc == JNI.MDB_NOTFOUND) {
                Entry entry = null;
                return entry;
            }
            Util.checkErrorCode(rc);
            Entry entry = new Entry(keyValue.toByteArray(), value.toByteArray());
            return entry;
        }
        finally {
            keyBuffer.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] put(byte[] key, byte[] value, int flags) {
        Util.checkArgNotNull(key, "key");
        Util.checkArgNotNull(value, "value");
        NativeBuffer keyBuffer = NativeBuffer.create(key);
        try {
            NativeBuffer valueBuffer = NativeBuffer.create(value);
            try {
                byte[] byArray = this.put(keyBuffer, valueBuffer, flags);
                valueBuffer.delete();
                return byArray;
            }
            catch (Throwable throwable) {
                valueBuffer.delete();
                throw throwable;
            }
        }
        finally {
            keyBuffer.delete();
        }
    }

    public int put(DirectBuffer key, DirectBuffer value, int flags) {
        Util.checkArgNotNull(key, "key");
        Util.checkArgNotNull(value, "value");
        if (this.buffer == null) {
            this.buffer = new DirectBuffer(ByteBuffer.allocateDirect(Unsafe.ADDRESS_SIZE * 4));
            this.bufferAddress = this.buffer.addressOffset();
        }
        Unsafe.putLong(this.bufferAddress, 0, key.capacity());
        Unsafe.putLong(this.bufferAddress, 1, key.addressOffset());
        Unsafe.putLong(this.bufferAddress, 2, value.capacity());
        Unsafe.putLong(this.bufferAddress, 3, value.addressOffset());
        return JNI.mdb_cursor_put_address(this.pointer(), this.bufferAddress, this.bufferAddress + (long)(2 * Unsafe.ADDRESS_SIZE), flags);
    }

    private byte[] put(NativeBuffer keyBuffer, NativeBuffer valueBuffer, int flags) {
        return this.put(new Value(keyBuffer), new Value(valueBuffer), flags);
    }

    private byte[] put(Value keySlice, Value valueSlice, int flags) {
        JNI.mdb_cursor_put(this.pointer(), keySlice, valueSlice, flags);
        return valueSlice.toByteArray();
    }

    public DirectBuffer reserve(DirectBuffer key, int size) {
        Util.checkArgNotNull(key, "key");
        if (key.byteArray() != null || !key.byteBuffer().isDirect()) {
            throw new IllegalArgumentException("Key buffer is not direct.");
        }
        if (this.buffer == null) {
            this.buffer = new DirectBuffer(ByteBuffer.allocateDirect(Unsafe.ADDRESS_SIZE * 4));
            this.bufferAddress = this.buffer.addressOffset();
        }
        Unsafe.putLong(this.bufferAddress, 0, key.capacity());
        Unsafe.putLong(this.bufferAddress, 1, key.addressOffset());
        Unsafe.putLong(this.bufferAddress, 2, size);
        int rc = JNI.mdb_cursor_put_address(this.pointer(), this.bufferAddress, this.bufferAddress + (long)(2 * Unsafe.ADDRESS_SIZE), Constants.RESERVE);
        Util.checkErrorCode(rc);
        int valSize = (int)Unsafe.getLong(this.bufferAddress, 2);
        long valAddress = Unsafe.getAddress(this.bufferAddress, 3);
        DirectBuffer empty = new DirectBuffer(0L, 0);
        empty.wrap(valAddress, valSize);
        return empty;
    }

    public void delete() {
        Util.checkErrorCode(JNI.mdb_cursor_del(this.pointer(), 0));
    }

    public void deleteIncludingDups() {
        Util.checkErrorCode(JNI.mdb_cursor_del(this.pointer(), JNI.MDB_NODUPDATA));
    }

    public long count() {
        long[] rc = new long[1];
        Util.checkErrorCode(JNI.mdb_cursor_count(this.pointer(), rc));
        return rc[0];
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }
}

