/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.naturalli;

import edu.stanford.nlp.ie.machinereading.structure.Span;
import edu.stanford.nlp.ie.util.RelationTriple;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.IndexedWord;
import edu.stanford.nlp.ling.tokensregex.TokenSequenceMatcher;
import edu.stanford.nlp.ling.tokensregex.TokenSequencePattern;
import edu.stanford.nlp.naturalli.ClauseSplitterSearchProblem;
import edu.stanford.nlp.naturalli.NaturalLogicAnnotations;
import edu.stanford.nlp.naturalli.Polarity;
import edu.stanford.nlp.naturalli.Util;
import edu.stanford.nlp.semgraph.SemanticGraph;
import edu.stanford.nlp.semgraph.SemanticGraphEdge;
import edu.stanford.nlp.semgraph.semgrex.SemgrexMatcher;
import edu.stanford.nlp.semgraph.semgrex.SemgrexPattern;
import edu.stanford.nlp.util.CollectionUtils;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.FixedPrioritiesPriorityQueue;
import edu.stanford.nlp.util.StringUtils;
import edu.stanford.nlp.util.Triple;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class RelationTripleSegmenter {
    private final boolean allowNominalsWithoutNER;
    public final List<SemgrexPattern> VERB_PATTERNS = Collections.unmodifiableList(new ArrayList<SemgrexPattern>(){
        {
            this.add(SemgrexPattern.compile("{$}=verb ?>/cop|aux(pass)?/ {}=be >/.subj(pass)?/ {}=subject >/(nmod|acl|advcl):.*/=prepEdge ( {}=object ?>appos {} = appos ?>case {}=prep) ?>dobj {pos:/N.*/}=relObj"));
            this.add(SemgrexPattern.compile("{$}=object >/.subj(pass)?/ {}=subject >/cop|aux(pass)?/ {}=verb ?>case {}=prep"));
            this.add(SemgrexPattern.compile("{$}=verb >/.subj(pass)?/ {}=subject >xcomp ( {}=object ?>appos {}=appos )"));
            this.add(SemgrexPattern.compile("{$}=verb ?>/aux(pass)?/ {}=be >/.subj(pass)?/ {}=subject >/[di]obj|xcomp/ ( {}=object ?>appos {}=appos )"));
            this.add(SemgrexPattern.compile("{$}=verb >/nsubj(pass)?/ ( {}=subject >/conj:and/=subjIgnored {}=object )"));
        }
    });
    public final List<SemgrexPattern> VP_PATTERNS = Collections.unmodifiableList(new ArrayList<SemgrexPattern>(){
        {
            for (SemgrexPattern pattern : RelationTripleSegmenter.this.VERB_PATTERNS) {
                String fullPattern = pattern.pattern();
                String vpPattern = fullPattern.replace(">/.subj(pass)?/ {}=subject", "").replace("$", "pos:/V.*/");
                this.add(SemgrexPattern.compile(vpPattern));
            }
        }
    });
    public final List<TokenSequencePattern> NOUN_TOKEN_PATTERNS = Collections.unmodifiableList(new ArrayList<TokenSequencePattern>(){
        {
            this.add(TokenSequencePattern.compile("(?$object [ner:/PERSON|ORGANIZATION|LOCATION+/]+ ) (?$beof_comp [ {tag:/NN.*/} & !{ner:/PERSON|ORGANIZATION|LOCATION/} ]+ ) (?$subject [ner:/PERSON|ORGANIZATION|LOCATION/]+ )"));
            this.add(TokenSequencePattern.compile("(?$object [ner:/PERSON|ORGANIZATION|LOCATION+/]+ ) /'s/ (?$beof_comp [ {tag:/NN.*/} & !{ner:/PERSON|ORGANIZATION|LOCATION/} ]+ ) /,/? (?$subject [ner:/PERSON|ORGANIZATION|LOCATION/]+ )"));
            this.add(TokenSequencePattern.compile("(?$subject [ner:/PERSON|ORGANIZATION|LOCATION/]+ ) /,/ (?$object [ner:/NUMBER|DURATION|PERSON|ORGANIZATION/]+ ) /,/"));
            this.add(TokenSequencePattern.compile("(?$subject [ner:/PERSON|ORGANIZATION|LOCATION/]+ ) /\\(/ (?$object [ner:/NUMBER|DURATION|PERSON|ORGANIZATION/]+ ) /\\)/"));
        }
    });
    private final List<SemgrexPattern> NOUN_DEPENDENCY_PATTERNS;
    public final Set<String> VALID_SUBJECT_ARCS = Collections.unmodifiableSet(new HashSet<String>(){
        {
            this.add("amod");
            this.add("compound");
            this.add("aux");
            this.add("nummod");
            this.add("nmod:poss");
            this.add("nmod:tmod");
            this.add("expl");
            this.add("nsubj");
            this.add("case");
        }
    });
    public final Set<String> VALID_OBJECT_ARCS = Collections.unmodifiableSet(new HashSet<String>(){
        {
            this.add("amod");
            this.add("compound");
            this.add("aux");
            this.add("nummod");
            this.add("nmod");
            this.add("nsubj");
            this.add("nmod:*");
            this.add("nmod:poss");
            this.add("nmod:tmod");
            this.add("conj:and");
            this.add("advmod");
            this.add("acl");
            this.add("case");
        }
    });
    public final Set<String> VALID_ADVERB_ARCS = Collections.unmodifiableSet(new HashSet<String>(){
        {
            this.add("amod");
            this.add("advmod");
            this.add("conj");
            this.add("cc");
            this.add("conj:and");
            this.add("conj:or");
            this.add("auxpass");
        }
    });

    public RelationTripleSegmenter(final boolean allowNominalsWithoutNER) {
        this.allowNominalsWithoutNER = allowNominalsWithoutNER;
        this.NOUN_DEPENDENCY_PATTERNS = Collections.unmodifiableList(new ArrayList<SemgrexPattern>(){
            {
                this.add(SemgrexPattern.compile("{tag:/N.*/}=subject >appos ( {}=relation >/nmod:.*/=relaux {}=object)"));
                this.add(SemgrexPattern.compile("{}=relation >/nmod:.*/=relaux {}=subject >appos {}=object"));
                this.add(SemgrexPattern.compile("{tag:/N.*/}=object >/nmod:poss/=relaux ( {}=subject >case {} )"));
                if (allowNominalsWithoutNER) {
                    this.add(SemgrexPattern.compile("{tag:/N.*/}=subject >/nmod:(?!poss).*/=relaux {}=object"));
                } else {
                    this.add(SemgrexPattern.compile("{ner:/PERSON|ORGANIZATION|LOCATION/}=subject >/nmod:(?!poss).*/=relaux {ner:/..+/}=object"));
                    this.add(SemgrexPattern.compile("{tag:/N.*/}=subject >/nmod:(in|with)/=relaux {}=object"));
                }
                if (allowNominalsWithoutNER) {
                    this.add(SemgrexPattern.compile("{tag:/N.*/}=subject >/amod/=arc {}=object"));
                } else {
                    this.add(SemgrexPattern.compile("{ner:/PERSON|ORGANIZATION|LOCATION/}=subject >/amod|compound/=arc {ner:/..+/}=object"));
                }
            }
        });
    }

    public RelationTripleSegmenter() {
        this(false);
    }

    public List<RelationTriple> extract(SemanticGraph parse, List<CoreLabel> tokens) {
        ArrayList<RelationTriple> extractions = new ArrayList<RelationTriple>();
        HashSet<Triple<Span, String, Span>> alreadyExtracted = new HashSet<Triple<Span, String, Span>>();
        for (TokenSequencePattern tokenPattern : this.NOUN_TOKEN_PATTERNS) {
            Object extraction;
            TokenSequenceMatcher tokenMatcher = tokenPattern.matcher(tokens);
            while (tokenMatcher.find()) {
                String relationGloss;
                boolean missingSuffixOf = false;
                List subject = tokenMatcher.groupNodes("$subject");
                Span subjectSpan = Util.extractNER(tokens, Span.fromValues(((CoreLabel)subject.get(0)).index() - 1, ((CoreLabel)subject.get(subject.size() - 1)).index()));
                ArrayList<CoreLabel> subjectTokens = new ArrayList<CoreLabel>();
                for (int i : subjectSpan) {
                    subjectTokens.add(tokens.get(i));
                }
                List object = tokenMatcher.groupNodes("$object");
                Span objectSpan = Util.extractNER(tokens, Span.fromValues(((CoreLabel)object.get(0)).index() - 1, ((CoreLabel)object.get(object.size() - 1)).index()));
                if (Span.overlaps(subjectSpan, objectSpan)) continue;
                ArrayList<CoreLabel> objectTokens = new ArrayList<CoreLabel>();
                for (int i : objectSpan) {
                    objectTokens.add(tokens.get(i));
                }
                if (subjectTokens.size() <= 0 || objectTokens.size() <= 0) continue;
                ArrayList<CoreLabel> relationTokens = new ArrayList<CoreLabel>();
                boolean missingPrefixBe = true;
                List beofComp = tokenMatcher.groupNodes("$beof_comp");
                if (beofComp != null) {
                    for (CoreMap token : beofComp) {
                        if (token instanceof CoreLabel) {
                            relationTokens.add((CoreLabel)token);
                            continue;
                        }
                        relationTokens.add(new CoreLabel(token));
                    }
                    missingSuffixOf = true;
                }
                if (alreadyExtracted.contains(Triple.makeTriple(subjectSpan, relationGloss = StringUtils.join(relationTokens.stream().map(CoreLabel::word), " "), objectSpan))) continue;
                extraction = new RelationTriple(subjectTokens, relationTokens, objectTokens);
                ((RelationTriple)extraction).isPrefixBe(missingPrefixBe);
                ((RelationTriple)extraction).isSuffixOf(missingSuffixOf);
                extractions.add((RelationTriple)extraction);
                alreadyExtracted.add(Triple.makeTriple(subjectSpan, relationGloss, objectSpan));
            }
            for (SemgrexPattern semgrex : this.NOUN_DEPENDENCY_PATTERNS) {
                SemgrexMatcher matcher = semgrex.matcher(parse);
                while (matcher.find()) {
                    String relationGloss;
                    Span objectSpan;
                    Span subjectSpan;
                    boolean missingPrefixBe = false;
                    boolean missingSuffixBe = false;
                    boolean istmod = false;
                    String relaux = matcher.getRelnString("relaux");
                    String ignoredArc = relaux;
                    if (ignoredArc == null) {
                        ignoredArc = matcher.getRelnString("arc");
                    }
                    IndexedWord subject = matcher.getNode("subject");
                    List<Object> subjectTokens = new ArrayList();
                    if (subject.ner() != null && !"O".equals(subject.ner())) {
                        subjectSpan = Util.extractNER(tokens, Span.fromValues(subject.index() - 1, subject.index()));
                        extraction = subjectSpan.iterator();
                        while (extraction.hasNext()) {
                            int i = extraction.next();
                            subjectTokens.add(new IndexedWord(tokens.get(i)));
                        }
                    } else {
                        subjectTokens = this.getValidChunk(parse, subject, this.VALID_SUBJECT_ARCS, Optional.ofNullable(ignoredArc), true).orElse(Collections.singletonList(subject));
                        subjectSpan = Util.tokensToSpan(subjectTokens);
                    }
                    IndexedWord object = matcher.getNode("object");
                    List<Object> objectTokens = new ArrayList();
                    if (object.ner() != null && !"O".equals(object.ner())) {
                        objectSpan = Util.extractNER(tokens, Span.fromValues(object.index() - 1, object.index()));
                        for (int i : objectSpan) {
                            objectTokens.add(new IndexedWord(tokens.get(i)));
                        }
                    } else {
                        objectTokens = this.getValidChunk(parse, object, this.VALID_OBJECT_ARCS, Optional.ofNullable(ignoredArc), true).orElse(Collections.singletonList(object));
                        objectSpan = Util.tokensToSpan(objectTokens);
                    }
                    if (Span.overlaps(subjectSpan, objectSpan) || subjectSpan.end() == objectSpan.start() - 1 && (tokens.get(subjectSpan.end()).word().matches("[\\.,:;\\('\"]") || "CC".equals(tokens.get(subjectSpan.end()).tag())) || objectSpan.end() == subjectSpan.start() - 1 && (tokens.get(objectSpan.end()).word().matches("[\\.,:;\\('\"]") || "CC".equals(tokens.get(objectSpan.end()).tag()))) continue;
                    String expected = relaux == null ? "" : relaux.substring(relaux.indexOf(":") + 1).replace("_", " ");
                    IndexedWord prepWord = null;
                    boolean prepositionIsPrefix = false;
                    for (SemanticGraphEdge edge : parse.outgoingEdgeIterable(object)) {
                        if (!edge.getRelation().toString().equals("case")) continue;
                        prepWord = edge.getDependent();
                    }
                    if (prepWord == null) {
                        for (SemanticGraphEdge edge : parse.outgoingEdgeIterable(subject)) {
                            if (!edge.getRelation().toString().equals("case")) continue;
                            prepositionIsPrefix = true;
                            prepWord = edge.getDependent();
                        }
                    }
                    List<IndexedWord> prepChunk = Collections.EMPTY_LIST;
                    if (prepWord != null && !expected.equals("tmod")) {
                        prepChunk = this.getValidChunk(parse, prepWord, Collections.singleton("mwe"), Optional.empty(), true).get();
                        Collections.sort(prepChunk, (a, b) -> {
                            double val = a.pseudoPosition() - b.pseudoPosition();
                            if (val < 0.0) {
                                return -1;
                            }
                            if (val > 0.0) {
                                return 1;
                            }
                            return 0;
                        });
                    }
                    if (subjectTokens.size() <= 0 || objectTokens.size() <= 0) continue;
                    LinkedList<IndexedWord> relationTokens = new LinkedList<IndexedWord>();
                    IndexedWord relNode = matcher.getNode("relation");
                    if (relNode != null) {
                        relationTokens.add(relNode);
                        if (prepositionIsPrefix) {
                            missingSuffixBe = true;
                            for (int i = prepChunk.size() - 1; i >= 0; --i) {
                                relationTokens.addFirst(prepChunk.get(i));
                            }
                        } else {
                            relationTokens.addAll(prepChunk);
                        }
                        if (expected.equalsIgnoreCase("tmod")) {
                            istmod = true;
                        }
                    } else {
                        if (!expected.equals("poss")) {
                            missingPrefixBe = true;
                        }
                        if (prepositionIsPrefix) {
                            for (int i = prepChunk.size() - 1; i >= 0; --i) {
                                relationTokens.addFirst(prepChunk.get(i));
                            }
                        } else {
                            relationTokens.addAll(prepChunk);
                        }
                        if (expected.equalsIgnoreCase("tmod")) {
                            istmod = true;
                        }
                        if (this.allowNominalsWithoutNER && "of".equals(expected)) continue;
                    }
                    if (alreadyExtracted.contains(Triple.makeTriple(subjectSpan, relationGloss = StringUtils.join(relationTokens.stream().map(IndexedWord::word), " "), objectSpan))) continue;
                    RelationTriple extraction2 = new RelationTriple(subjectTokens.stream().map(IndexedWord::backingLabel).collect(Collectors.toList()), relationTokens.stream().map(IndexedWord::backingLabel).collect(Collectors.toList()), objectTokens.stream().map(IndexedWord::backingLabel).collect(Collectors.toList()));
                    extraction2.istmod(istmod);
                    extraction2.isPrefixBe(missingPrefixBe);
                    extraction2.isSuffixBe(missingSuffixBe);
                    extractions.add(extraction2);
                    alreadyExtracted.add(Triple.makeTriple(subjectSpan, relationGloss, objectSpan));
                }
            }
        }
        Iterator iter = extractions.iterator();
        while (iter.hasNext()) {
            RelationTriple term = (RelationTriple)iter.next();
            boolean shouldRemove = true;
            for (CoreLabel token : term) {
                if (token.get(NaturalLogicAnnotations.PolarityAnnotation.class) != null && ((Polarity)token.get(NaturalLogicAnnotations.PolarityAnnotation.class)).isDownwards()) continue;
                shouldRemove = false;
            }
            if (!shouldRemove) continue;
            iter.remove();
        }
        return extractions;
    }

    protected Optional<List<IndexedWord>> getValidChunk(SemanticGraph parse, IndexedWord originalRoot, Set<String> validArcs, Optional<String> ignoredArc, boolean allowExtraArcs) {
        FixedPrioritiesPriorityQueue<IndexedWord> chunk = new FixedPrioritiesPriorityQueue<IndexedWord>();
        HashSet<Double> seenIndices = new HashSet<Double>();
        LinkedList<IndexedWord> fringe = new LinkedList<IndexedWord>();
        IndexedWord root = originalRoot;
        fringe.add(root);
        boolean isCopula = false;
        IndexedWord primaryCase = null;
        for (SemanticGraphEdge edge : parse.outgoingEdgeIterable(originalRoot)) {
            String shortName = edge.getRelation().getShortName();
            if (shortName.equals("cop") || shortName.equals("auxpass")) {
                isCopula = true;
            }
            if (!shortName.equals("case")) continue;
            primaryCase = edge.getDependent();
        }
        while (!fringe.isEmpty()) {
            root = (IndexedWord)fringe.poll();
            chunk.add(root, -root.pseudoPosition());
            if (seenIndices.contains(root.pseudoPosition())) {
                return Optional.empty();
            }
            seenIndices.add(root.pseudoPosition());
            boolean hasConj = false;
            boolean hasCC = false;
            for (SemanticGraphEdge edge : parse.getOutEdgesSorted(root)) {
                String shortName = edge.getRelation().getShortName();
                String name = edge.getRelation().toString();
                if (shortName.startsWith("conj")) {
                    hasConj = true;
                }
                if (shortName.equals("cc")) {
                    hasCC = true;
                }
                if (isCopula && (shortName.equals("cop") || shortName.contains("subj") || shortName.equals("auxpass")) || edge.getDependent() == primaryCase || ignoredArc.isPresent() && (ignoredArc.get().equals(name) || ignoredArc.get().startsWith("conj") && name.equals("cc"))) continue;
                if (!validArcs.contains(edge.getRelation().getShortName()) && !validArcs.contains(edge.getRelation().getShortName().replaceAll(":.*", ":*"))) {
                    if (allowExtraArcs) continue;
                    return Optional.empty();
                }
                fringe.add(edge.getDependent());
            }
            if (!Boolean.logicalXor(hasConj, hasCC)) continue;
            return Optional.empty();
        }
        return Optional.of(chunk.toSortedList());
    }

    protected Optional<List<IndexedWord>> getValidChunk(SemanticGraph parse, IndexedWord originalRoot, Set<String> validArcs, Optional<String> ignoredArc) {
        return this.getValidChunk(parse, originalRoot, validArcs, ignoredArc, false);
    }

    protected Optional<List<IndexedWord>> getValidSubjectChunk(SemanticGraph parse, IndexedWord root, Optional<String> noopArc) {
        return this.getValidChunk(parse, root, this.VALID_SUBJECT_ARCS, noopArc);
    }

    protected Optional<List<IndexedWord>> getValidObjectChunk(SemanticGraph parse, IndexedWord root, Optional<String> noopArc) {
        return this.getValidChunk(parse, root, this.VALID_OBJECT_ARCS, noopArc);
    }

    protected Optional<List<IndexedWord>> getValidAdverbChunk(SemanticGraph parse, IndexedWord root, Optional<String> noopArc) {
        return this.getValidChunk(parse, root, this.VALID_ADVERB_ARCS, noopArc);
    }

    private Optional<RelationTriple> segmentVerb(SemanticGraph parse, Optional<Double> confidence, boolean consumeAll) {
        block0: for (SemgrexPattern pattern : this.VERB_PATTERNS) {
            IndexedWord indexedWord;
            IndexedWord be;
            String prepStringFromEdge;
            SemgrexMatcher m = pattern.matcher(parse);
            if (!m.matches() || "nmod:poss".equals(m.getRelnString("prepEdge"))) continue;
            int numKnownDependents = 2;
            boolean istmod = false;
            IndexedWord object = m.getNode("appos");
            if (object == null) {
                object = m.getNode("object");
            }
            if (object != null && object.tag() != null && object.tag().startsWith("W")) continue;
            assert (object != null);
            FixedPrioritiesPriorityQueue<IndexedWord> verbChunk = new FixedPrioritiesPriorityQueue<IndexedWord>();
            IndexedWord verb = m.getNode("verb");
            ArrayList<IndexedWord> adverbs = new ArrayList<IndexedWord>();
            Optional<Object> subjNoopArc = Optional.empty();
            Optional<String> objNoopArc = Optional.empty();
            assert (verb != null);
            IndexedWord relObj = m.getNode("relObj");
            for (SemanticGraphEdge edge : parse.outgoingEdgeIterable(verb)) {
                if ("advmod".equals(edge.getRelation().toString()) || "amod".equals(edge.getRelation().toString())) {
                    String tag = edge.getDependent().backingLabel().tag();
                    if (tag != null && (tag.startsWith("W") || edge.getDependent().backingLabel().word().equalsIgnoreCase("then"))) continue;
                    adverbs.add(edge.getDependent());
                    continue;
                }
                if (!edge.getDependent().equals(relObj)) continue;
                Optional<List<IndexedWord>> relObjSpan = this.getValidChunk(parse, relObj, Collections.singleton("compound"), Optional.empty());
                if (!relObjSpan.isPresent()) continue block0;
                for (IndexedWord indexedWord2 : relObjSpan.get()) {
                    verbChunk.add(indexedWord2, -indexedWord2.pseudoPosition());
                }
                ++numKnownDependents;
            }
            verbChunk.add(verb, -verb.pseudoPosition());
            IndexedWord prep = m.getNode("prep");
            String prepEdge = m.getRelnString("prepEdge");
            if (prep != null) {
                Optional<List<IndexedWord>> chunk = this.getValidChunk(parse, prep, Collections.singleton("mwe"), Optional.empty(), true);
                if (!chunk.isPresent()) continue;
                for (IndexedWord indexedWord3 : chunk.get()) {
                    verbChunk.add(indexedWord3, -1.073741824E9 - indexedWord3.pseudoPosition());
                }
            }
            if (prepEdge != null && "tmod".equals(prepStringFromEdge = prepEdge.substring(prepEdge.indexOf(":") + 1).replace("_", " "))) {
                istmod = true;
            }
            if ((be = m.getNode("be")) != null) {
                verbChunk.add(be, -be.pseudoPosition());
                ++numKnownDependents;
            }
            if (!adverbs.isEmpty()) {
                HashSet adverbialModifiers = new HashSet();
                for (IndexedWord adv : adverbs) {
                    Optional<List<IndexedWord>> adverbChunk = this.getValidAdverbChunk(parse, adv, Optional.empty());
                    if (!adverbChunk.isPresent()) continue block0;
                    adverbialModifiers.addAll(adverbChunk.get().stream().collect(Collectors.toList()));
                    ++numKnownDependents;
                }
                for (IndexedWord adverbToken : adverbialModifiers) {
                    verbChunk.add(adverbToken, -adverbToken.pseudoPosition());
                }
            }
            if (consumeAll && parse.outDegree(verb) > numKnownDependents) continue;
            List relation = verbChunk.toSortedList();
            if (!subjNoopArc.isPresent() && !(subjNoopArc = Optional.ofNullable(m.getRelnString("subjIgnored"))).isPresent()) {
                subjNoopArc = Optional.ofNullable(m.getRelnString("prepEdge"));
            }
            if (!objNoopArc.isPresent()) {
                objNoopArc = Optional.ofNullable(m.getRelnString("objIgnored"));
            }
            if ((indexedWord = m.getNode("subject")) != null && indexedWord.tag() != null && indexedWord.tag().startsWith("W")) continue;
            Optional<List<IndexedWord>> subjectSpan = this.getValidSubjectChunk(parse, indexedWord, subjNoopArc);
            Optional<List<IndexedWord>> objectSpan = this.getValidObjectChunk(parse, object, objNoopArc);
            if (!subjectSpan.isPresent() || !objectSpan.isPresent() || !CollectionUtils.intersection(new HashSet(subjectSpan.get()), new HashSet(objectSpan.get())).isEmpty()) continue;
            RelationTriple.WithTree extraction = new RelationTriple.WithTree(subjectSpan.get().stream().map(IndexedWord::backingLabel).collect(Collectors.toList()), relation.stream().map(IndexedWord::backingLabel).collect(Collectors.toList()), objectSpan.get().stream().map(IndexedWord::backingLabel).collect(Collectors.toList()), parse, confidence.orElse(1.0));
            extraction.istmod(istmod);
            return Optional.of(extraction);
        }
        return Optional.empty();
    }

    private Optional<RelationTriple> segmentACL(SemanticGraph parse, Optional<Double> confidence, boolean consumeAll) {
        IndexedWord subject = parse.getFirstRoot();
        Optional<List<IndexedWord>> subjectSpan = this.getValidSubjectChunk(parse, subject, Optional.of("acl"));
        if (subjectSpan.isPresent()) {
            for (SemanticGraphEdge edgeFromSubj : parse.outgoingEdgeIterable(subject)) {
                if (!"acl".equals(edgeFromSubj.getRelation().toString())) continue;
                IndexedWord relation = edgeFromSubj.getDependent();
                ArrayList<IndexedWord> relationSpan = new ArrayList<IndexedWord>();
                relationSpan.add(relation);
                ArrayList objectSpan = new ArrayList();
                ArrayList ppSpan = new ArrayList();
                Optional<Object> pp = Optional.empty();
                for (SemanticGraphEdge edgeFromRel : parse.outgoingEdgeIterable(relation)) {
                    String rel = edgeFromRel.getRelation().toString();
                    if ("advmod".equals(rel)) {
                        Optional<List<IndexedWord>> advSpan = this.getValidAdverbChunk(parse, edgeFromRel.getDependent(), Optional.empty());
                        if (!advSpan.isPresent()) {
                            return Optional.empty();
                        }
                        relationSpan.addAll((Collection)advSpan.get());
                        continue;
                    }
                    if (rel.endsWith("obj")) {
                        if (!objectSpan.isEmpty()) {
                            return Optional.empty();
                        }
                        Optional<List<IndexedWord>> maybeObjSpan = this.getValidObjectChunk(parse, edgeFromRel.getDependent(), Optional.empty());
                        if (!maybeObjSpan.isPresent()) {
                            return Optional.empty();
                        }
                        objectSpan.addAll(maybeObjSpan.get());
                        continue;
                    }
                    if (rel.startsWith("nmod:")) {
                        if (!ppSpan.isEmpty()) {
                            return Optional.empty();
                        }
                        Optional<List<IndexedWord>> maybePPSpan = this.getValidObjectChunk(parse, edgeFromRel.getDependent(), Optional.of("case"));
                        if (!maybePPSpan.isPresent()) {
                            return Optional.empty();
                        }
                        ppSpan.addAll(maybePPSpan.get());
                        for (SemanticGraphEdge edge : parse.outgoingEdgeIterable(edgeFromRel.getDependent())) {
                            if (!"case".equals(edge.getRelation().toString())) continue;
                            pp = Optional.of(edge.getDependent());
                        }
                        continue;
                    }
                    if (!consumeAll) continue;
                    return Optional.empty();
                }
                if (!ppSpan.isEmpty() && !objectSpan.isEmpty()) {
                    relationSpan.addAll(objectSpan);
                    objectSpan = ppSpan;
                } else if (!ppSpan.isEmpty()) {
                    objectSpan = ppSpan;
                }
                if (!subjectSpan.isPresent() || subjectSpan.get().isEmpty() || relationSpan.isEmpty() || objectSpan.isEmpty()) {
                    return Optional.empty();
                }
                Collections.sort(relationSpan, (a, b) -> {
                    double val = a.pseudoPosition() - b.pseudoPosition();
                    if (val < 0.0) {
                        return -1;
                    }
                    if (val > 0.0) {
                        return 1;
                    }
                    return 0;
                });
                if (pp.isPresent()) {
                    relationSpan.add((IndexedWord)pp.get());
                }
                RelationTriple.WithTree extraction = new RelationTriple.WithTree(subjectSpan.get().stream().map(IndexedWord::backingLabel).collect(Collectors.toList()), relationSpan.stream().map(IndexedWord::backingLabel).collect(Collectors.toList()), objectSpan.stream().map(IndexedWord::backingLabel).collect(Collectors.toList()), parse, confidence.orElse(1.0));
                return Optional.of(extraction);
            }
        }
        return Optional.empty();
    }

    public Optional<RelationTriple> segment(SemanticGraph parse, Optional<Double> confidence, boolean consumeAll) {
        Optional<RelationTriple> extraction;
        IndexedWord root = (parse = new SemanticGraph(parse)).getFirstRoot();
        if (root.lemma() != null && root.lemma().equalsIgnoreCase("be") || root.lemma() == null && ("is".equalsIgnoreCase(root.word()) || "are".equalsIgnoreCase(root.word()) || "were".equalsIgnoreCase(root.word()) || "be".equalsIgnoreCase(root.word()))) {
            boolean foundThere = false;
            boolean tooMayArcs = false;
            Optional<Object> newRoot = Optional.empty();
            for (SemanticGraphEdge edge : parse.outgoingEdgeIterable(root)) {
                if (edge.getRelation().toString().equals("expl") && edge.getDependent().word().equalsIgnoreCase("there")) {
                    foundThere = true;
                    continue;
                }
                if (edge.getRelation().toString().equals("nsubj")) {
                    newRoot = Optional.of(edge);
                    continue;
                }
                tooMayArcs = true;
            }
            if (foundThere && newRoot.isPresent() && !tooMayArcs) {
                ClauseSplitterSearchProblem.splitToChildOfEdge(parse, (SemanticGraphEdge)newRoot.get());
            }
        }
        if (!(extraction = this.segmentVerb(parse, confidence, consumeAll)).isPresent()) {
            extraction = this.segmentACL(parse, confidence, consumeAll);
        }
        if (extraction.isPresent()) {
            boolean shouldRemove = true;
            for (CoreLabel token : extraction.get()) {
                if (token.get(NaturalLogicAnnotations.PolarityAnnotation.class) != null && ((Polarity)token.get(NaturalLogicAnnotations.PolarityAnnotation.class)).isDownwards()) continue;
                shouldRemove = false;
            }
            if (shouldRemove) {
                return Optional.empty();
            }
        }
        return extraction;
    }

    public Optional<RelationTriple> segment(SemanticGraph parse, Optional<Double> confidence) {
        return this.segment(parse, confidence, true);
    }
}

