/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.lexparser;

import edu.stanford.nlp.ling.HasWord;
import edu.stanford.nlp.ling.Sentence;
import edu.stanford.nlp.parser.lexparser.AbstractTreebankParserParams;
import edu.stanford.nlp.parser.lexparser.TreeCollinizer;
import edu.stanford.nlp.trees.DiskTreebank;
import edu.stanford.nlp.trees.HeadFinder;
import edu.stanford.nlp.trees.LeftHeadFinder;
import edu.stanford.nlp.trees.MemoryTreebank;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeReaderFactory;
import edu.stanford.nlp.trees.TreeTransformer;
import edu.stanford.nlp.trees.TreebankLanguagePack;
import edu.stanford.nlp.trees.international.hebrew.HebrewTreeReaderFactory;
import edu.stanford.nlp.trees.international.hebrew.HebrewTreebankLanguagePack;
import java.util.List;

public class HebrewTreebankParserParams
extends AbstractTreebankParserParams {
    private static final long serialVersionUID = -3466519995341208619L;
    private final StringBuilder optionsString = new StringBuilder();
    private static final String[] EMPTY_STRING_ARRAY = new String[0];

    public HebrewTreebankParserParams() {
        this(new HebrewTreebankLanguagePack());
    }

    protected HebrewTreebankParserParams(TreebankLanguagePack tlp) {
        super(tlp);
        this.optionsString.append("HebrewTreebankParserParams\n");
    }

    @Override
    public TreeTransformer collinizer() {
        return new TreeCollinizer(this.tlp, true, false);
    }

    @Override
    public TreeTransformer collinizerEvalb() {
        return this.collinizer();
    }

    @Override
    public MemoryTreebank memoryTreebank() {
        return new MemoryTreebank(this.treeReaderFactory(), this.inputEncoding);
    }

    @Override
    public DiskTreebank diskTreebank() {
        return new DiskTreebank(this.treeReaderFactory(), this.inputEncoding);
    }

    @Override
    public void display() {
        System.err.println(this.optionsString.toString());
    }

    @Override
    public HeadFinder headFinder() {
        return new LeftHeadFinder();
    }

    @Override
    public HeadFinder typedDependencyHeadFinder() {
        return this.headFinder();
    }

    @Override
    public String[] sisterSplitters() {
        return EMPTY_STRING_ARRAY;
    }

    @Override
    public Tree transformTree(Tree t, Tree root) {
        return t;
    }

    @Override
    public List<? extends HasWord> defaultTestSentence() {
        String[] sent = new String[]{"H", "MWX", "MTPLC", "LA", "RQ", "M", "H", "TWPEH", "H", "MBIFH", "ALA", "GM", "M", "DRKI", "H", "HERMH", "yyDOT"};
        return Sentence.toWordList(sent);
    }

    @Override
    public TreeReaderFactory treeReaderFactory() {
        return new HebrewTreeReaderFactory();
    }
}

