/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.IndexedWord;
import edu.stanford.nlp.ling.tokensregex.SequenceMatchResult;
import edu.stanford.nlp.ling.tokensregex.TokenSequenceMatcher;
import edu.stanford.nlp.ling.tokensregex.TokenSequencePattern;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.AnnotationOutputter;
import edu.stanford.nlp.pipeline.AnnotationSerializer;
import edu.stanford.nlp.pipeline.JSONOutputter;
import edu.stanford.nlp.pipeline.ProtobufAnnotationSerializer;
import edu.stanford.nlp.pipeline.StanfordCoreNLP;
import edu.stanford.nlp.semgraph.SemanticGraph;
import edu.stanford.nlp.semgraph.SemanticGraphCoreAnnotations;
import edu.stanford.nlp.semgraph.semgrex.SemgrexMatcher;
import edu.stanford.nlp.semgraph.semgrex.SemgrexPattern;
import edu.stanford.nlp.util.ArrayUtils;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.Execution;
import edu.stanford.nlp.util.MetaClass;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.PropertiesUtils;
import edu.stanford.nlp.util.StringUtils;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.WeakHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;

public class StanfordCoreNLPServer
implements Runnable {
    protected static int DEFAULT_PORT = 9000;
    protected static int DEFAULT_TIMEOUT = 5000;
    protected HttpServer server;
    protected final int serverPort;
    protected final int timeoutMilliseconds;
    protected final boolean strict;
    protected final FileHandler staticPageHandle;
    protected final String shutdownKey;
    public static int HTTP_OK = 200;
    public static int HTTP_BAD_INPUT = 400;
    public static int HTTP_ERR = 500;
    public static int MAX_CHAR_LENGTH = 100000;
    public final Properties defaultProps;
    private final ExecutorService serverExecutor = Executors.newFixedThreadPool(Execution.threads);
    private final WeakHashMap<Properties, StanfordCoreNLP> pipelineCache = new WeakHashMap();
    private final ExecutorService corenlpExecutor = Executors.newFixedThreadPool(Execution.threads);

    public StanfordCoreNLPServer(int port, int timeout, boolean strict) throws IOException {
        this.serverPort = port;
        this.timeoutMilliseconds = timeout;
        this.strict = strict;
        this.defaultProps = PropertiesUtils.asProperties("annotators", "tokenize, ssplit, pos, lemma, ner, depparse, coref, natlog, openie", "coref.md.type", "dep", "inputFormat", "text", "outputFormat", "json", "prettyPrint", "false");
        String tmpDir = System.getProperty("java.io.tmpdir");
        File tmpFile = new File(tmpDir + File.separator + "corenlp.shutdown");
        tmpFile.deleteOnExit();
        if (tmpFile.exists() && !tmpFile.delete()) {
            throw new IllegalStateException("Could not delete shutdown key file");
        }
        this.shutdownKey = new BigInteger(130, new Random()).toString(32);
        IOUtils.writeStringToFile(this.shutdownKey, tmpFile.getPath(), "utf-8");
        this.staticPageHandle = new FileHandler("edu/stanford/nlp/pipeline/demo/corenlp-brat.html");
    }

    private static Map<String, String> getURLParams(URI uri) throws UnsupportedEncodingException {
        if (uri.getQuery() != null) {
            String[] queryFields;
            HashMap<String, String> urlParams = new HashMap<String, String>();
            String query = uri.getQuery();
            for (String queryField : queryFields = query.replaceAll("\\\\&", "___AMP___").replaceAll("\\\\+", "___PLUS___").split("&")) {
                int firstEq = queryField.indexOf(61);
                String key = URLDecoder.decode(queryField.substring(0, firstEq), "utf8").replaceAll("___AMP___", "&").replaceAll("___PLUS___", "+");
                String value = URLDecoder.decode(queryField.substring(firstEq + 1), "utf8").replaceAll("___AMP___", "&").replaceAll("___PLUS___", "+");
                urlParams.put(key, value);
            }
            return urlParams;
        }
        return Collections.emptyMap();
    }

    private Annotation getDocument(Properties props, HttpExchange httpExchange) throws IOException, ClassNotFoundException {
        String inputFormat;
        switch (inputFormat = props.getProperty("inputFormat", "text")) {
            case "text": {
                String[] charsetPair;
                String defaultEncoding = this.strict ? "ISO-8859-1" : "UTF-8";
                Headers h = httpExchange.getRequestHeaders();
                String encoding = h.containsKey("Content-type") ? ((charsetPair = Arrays.asList(h.getFirst("Content-type").split(";")).stream().map(x -> x.split("=")).filter(x -> ((String[])x).length > 0 && "charset".equals(x[0])).findFirst().orElse(new String[]{"charset", defaultEncoding})).length == 2 ? charsetPair[1] : defaultEncoding) : defaultEncoding;
                return new Annotation(IOUtils.slurpInputStream(httpExchange.getRequestBody(), encoding));
            }
            case "serialized": {
                String inputSerializerName = props.getProperty("inputSerializer", ProtobufAnnotationSerializer.class.getName());
                AnnotationSerializer serializer = (AnnotationSerializer)MetaClass.create(inputSerializerName).createInstance(new Object[0]);
                Pair<Annotation, InputStream> pair = serializer.read(httpExchange.getRequestBody());
                return (Annotation)pair.first;
            }
        }
        throw new IOException("Could not parse input format: " + inputFormat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StanfordCoreNLP mkStanfordCoreNLP(Properties props) {
        StanfordCoreNLP impl;
        WeakHashMap<Properties, StanfordCoreNLP> weakHashMap = this.pipelineCache;
        synchronized (weakHashMap) {
            impl = this.pipelineCache.get(props);
            if (impl == null) {
                impl = new StanfordCoreNLP(props);
                this.pipelineCache.put(props, impl);
            }
        }
        return impl;
    }

    private static void respondError(String response, HttpExchange httpExchange) throws IOException {
        httpExchange.getResponseHeaders().add("Content-Type", "text/plain");
        httpExchange.sendResponseHeaders(HTTP_ERR, response.length());
        httpExchange.getResponseBody().write(response.getBytes());
        httpExchange.close();
    }

    private static void respondBadInput(String response, HttpExchange httpExchange) throws IOException {
        httpExchange.getResponseHeaders().add("Content-Type", "text/plain");
        httpExchange.sendResponseHeaders(HTTP_BAD_INPUT, response.length());
        httpExchange.getResponseBody().write(response.getBytes());
        httpExchange.close();
    }

    private static void sendAndGetResponse(HttpExchange httpExchange, byte[] response) throws IOException {
        if (response.length > 0) {
            httpExchange.getResponseHeaders().add("Content-Type", "text/json");
            httpExchange.getResponseHeaders().add("Content-Length", Integer.toString(response.length));
            httpExchange.sendResponseHeaders(HTTP_OK, response.length);
            httpExchange.getResponseBody().write(response);
            httpExchange.close();
        }
    }

    @Override
    public void run() {
        try {
            this.server = HttpServer.create(new InetSocketAddress(this.serverPort), 0);
            this.server.createContext("/", new CoreNLPHandler(this.defaultProps));
            this.server.createContext("/tokensregex", new TokensRegexHandler());
            this.server.createContext("/semgrex", new SemgrexHandler());
            this.server.createContext("/corenlp-brat.js", new FileHandler("edu/stanford/nlp/pipeline/demo/corenlp-brat.js"));
            this.server.createContext("/corenlp-brat.cs", new FileHandler("edu/stanford/nlp/pipeline/demo/corenlp-brat.css"));
            this.server.createContext("/ping", new PingHandler());
            this.server.createContext("/shutdown", new ShutdownHandler());
            this.server.setExecutor(this.serverExecutor);
            this.server.start();
            Redwood.Util.log("StanfordCoreNLPServer listening at " + this.server.getAddress());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected static void printHelp(PrintStream os) {
        os.println("Usage: StanfordCoreNLPServer [port=9000] [timeout=5]");
        os.println("port\t\t\t\t Which port to use");
        os.println("timeout\t\t\t\t How long to wait before timing out");
    }

    public static void main(String[] args) throws IOException {
        int port = DEFAULT_PORT;
        int timeout = DEFAULT_TIMEOUT;
        boolean strict = false;
        Properties props = new Properties();
        if (args.length > 0) {
            props = StringUtils.argsToProperties(args);
            boolean hasH = props.containsKey("h");
            boolean hasHelp = props.containsKey("help");
            if (hasH || hasHelp) {
                StanfordCoreNLPServer.printHelp(System.err);
                return;
            }
        }
        props.list(System.err);
        if (props.containsKey("port")) {
            port = Integer.parseInt(props.getProperty("port"));
        }
        if (props.containsKey("timeout")) {
            timeout = Integer.parseInt(props.getProperty("timeout"));
        }
        if (props.containsKey("strict") && props.get("strict") != null && !"".equals(props.get("strict"))) {
            strict = Boolean.parseBoolean(props.getProperty("strict"));
        }
        Redwood.Util.log("Starting server on port " + port + " with timeout of " + timeout + " milliseconds.");
        StanfordCoreNLPServer server = new StanfordCoreNLPServer(port, timeout, strict);
        server.run();
    }

    protected class SemgrexHandler
    implements HttpHandler {
        protected SemgrexHandler() {
        }

        @Override
        public void handle(HttpExchange httpExchange) throws IOException {
            httpExchange.getResponseHeaders().add("Access-Control-Allow-Origin", "*");
            Future<String> json = StanfordCoreNLPServer.this.corenlpExecutor.submit(() -> {
                try {
                    Map params;
                    Properties props = PropertiesUtils.asProperties("annotators", "tokenize,ssplit,pos,lemma,ner,depparse");
                    Annotation doc = StanfordCoreNLPServer.this.getDocument(props, httpExchange);
                    if (!doc.containsKey(CoreAnnotations.SentencesAnnotation.class)) {
                        StanfordCoreNLP pipeline = StanfordCoreNLPServer.this.mkStanfordCoreNLP(props);
                        pipeline.annotate(doc);
                    }
                    if (!(params = StanfordCoreNLPServer.getURLParams(httpExchange.getRequestURI())).containsKey("pattern")) {
                        StanfordCoreNLPServer.respondBadInput("Missing required parameter 'pattern'", httpExchange);
                        return "";
                    }
                    String pattern = (String)params.get("pattern");
                    String filterStr = params.getOrDefault("filter", "false");
                    boolean filter = filterStr.trim().isEmpty() || "true".equalsIgnoreCase(filterStr.toLowerCase());
                    SemgrexPattern regex = SemgrexPattern.compile(pattern);
                    return JSONOutputter.JSONWriter.objectToJSON(docWriter -> {
                        if (filter) {
                            docWriter.set("sentences", ((List)doc.get(CoreAnnotations.SentencesAnnotation.class)).stream().map(sentence -> regex.matcher((SemanticGraph)sentence.get(SemanticGraphCoreAnnotations.CollapsedCCProcessedDependenciesAnnotation.class)).matches()).collect(Collectors.toList()));
                        } else {
                            docWriter.set("sentences", ((List)doc.get(CoreAnnotations.SentencesAnnotation.class)).stream().map(sentence -> sentWriter -> {
                                SemgrexMatcher matcher = regex.matcher((SemanticGraph)sentence.get(SemanticGraphCoreAnnotations.CollapsedCCProcessedDependenciesAnnotation.class));
                                int i = 0;
                                while (matcher.find()) {
                                    sentWriter.set(Integer.toString(i), matchWriter -> {
                                        IndexedWord match = matcher.getMatch();
                                        matchWriter.set("text", match.word());
                                        matchWriter.set("begin", match.index() - 1);
                                        matchWriter.set("end", match.index());
                                        for (String capture : matcher.getNodeNames()) {
                                            matchWriter.set("$" + capture, groupWriter -> {
                                                IndexedWord node = matcher.getNode(capture);
                                                groupWriter.set("text", node.word());
                                                groupWriter.set("begin", node.index() - 1);
                                                groupWriter.set("end", node.index());
                                            });
                                        }
                                    });
                                    ++i;
                                }
                                sentWriter.set("length", i);
                            }));
                        }
                    });
                }
                catch (Exception e) {
                    e.printStackTrace();
                    try {
                        StanfordCoreNLPServer.respondError(e.getClass().getName() + ": " + e.getMessage(), httpExchange);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    return "";
                }
            });
            try {
                byte[] response = json.get(5L, TimeUnit.SECONDS).getBytes();
                StanfordCoreNLPServer.sendAndGetResponse(httpExchange, response);
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                StanfordCoreNLPServer.respondError("Timeout when executing Semgrex query", httpExchange);
            }
        }
    }

    protected class TokensRegexHandler
    implements HttpHandler {
        protected TokensRegexHandler() {
        }

        @Override
        public void handle(HttpExchange httpExchange) throws IOException {
            httpExchange.getResponseHeaders().add("Access-Control-Allow-Origin", "*");
            Future<String> json = StanfordCoreNLPServer.this.corenlpExecutor.submit(() -> {
                try {
                    Map params;
                    Properties props = PropertiesUtils.asProperties("annotators", "tokenize,ssplit,pos,lemma,ner");
                    Annotation doc = StanfordCoreNLPServer.this.getDocument(props, httpExchange);
                    if (!doc.containsKey(CoreAnnotations.SentencesAnnotation.class)) {
                        StanfordCoreNLP pipeline = StanfordCoreNLPServer.this.mkStanfordCoreNLP(props);
                        pipeline.annotate(doc);
                    }
                    if (!(params = StanfordCoreNLPServer.getURLParams(httpExchange.getRequestURI())).containsKey("pattern")) {
                        StanfordCoreNLPServer.respondBadInput("Missing required parameter 'pattern'", httpExchange);
                        return "";
                    }
                    String pattern = (String)params.get("pattern");
                    String filterStr = params.getOrDefault("filter", "false");
                    boolean filter = filterStr.trim().isEmpty() || "true".equalsIgnoreCase(filterStr.toLowerCase());
                    TokenSequencePattern regex = TokenSequencePattern.compile(pattern);
                    return JSONOutputter.JSONWriter.objectToJSON(docWriter -> {
                        if (filter) {
                            docWriter.set("sentences", ((List)doc.get(CoreAnnotations.SentencesAnnotation.class)).stream().map(sentence -> regex.matcher((List)sentence.get(CoreAnnotations.TokensAnnotation.class)).matches()).collect(Collectors.toList()));
                        } else {
                            docWriter.set("sentences", ((List)doc.get(CoreAnnotations.SentencesAnnotation.class)).stream().map(sentence -> sentWriter -> {
                                List tokens = (List)sentence.get(CoreAnnotations.TokensAnnotation.class);
                                TokenSequenceMatcher matcher = regex.matcher(tokens);
                                int i = 0;
                                while (matcher.find()) {
                                    sentWriter.set(Integer.toString(i), matchWriter -> {
                                        matchWriter.set("text", matcher.group());
                                        matchWriter.set("begin", matcher.start());
                                        matchWriter.set("end", matcher.end());
                                        for (int groupI = 0; groupI < matcher.groupCount(); ++groupI) {
                                            SequenceMatchResult.MatchedGroupInfo info = matcher.groupInfo(groupI + 1);
                                            matchWriter.set(info.varName == null ? Integer.toString(groupI + 1) : info.varName, groupWriter -> {
                                                groupWriter.set("text", info.text);
                                                if (info.nodes.size() > 0) {
                                                    groupWriter.set("begin", (Integer)((CoreMap)info.nodes.get(0)).get(CoreAnnotations.IndexAnnotation.class) - 1);
                                                    groupWriter.set("end", ((CoreMap)info.nodes.get(info.nodes.size() - 1)).get(CoreAnnotations.IndexAnnotation.class));
                                                }
                                            });
                                        }
                                    });
                                    ++i;
                                }
                                sentWriter.set("length", i);
                            }));
                        }
                    });
                }
                catch (Exception e) {
                    e.printStackTrace();
                    try {
                        StanfordCoreNLPServer.respondError(e.getClass().getName() + ": " + e.getMessage(), httpExchange);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    return "";
                }
            });
            try {
                byte[] response = json.get(5L, TimeUnit.SECONDS).getBytes();
                StanfordCoreNLPServer.sendAndGetResponse(httpExchange, response);
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                StanfordCoreNLPServer.respondError("Timeout when executing TokensRegex query", httpExchange);
            }
        }
    }

    protected class CoreNLPHandler
    implements HttpHandler {
        public final Properties defaultProps;

        public CoreNLPHandler(Properties props) {
            this.defaultProps = props;
        }

        public String getContentType(Properties props, StanfordCoreNLP.OutputFormat of) {
            switch (of) {
                case JSON: {
                    return "text/json";
                }
                case TEXT: 
                case CONLL: {
                    return "text/plain";
                }
                case XML: {
                    return "text/xml";
                }
                case SERIALIZED: {
                    String outputSerializerName = props.getProperty("outputSerializer");
                    if (outputSerializerName == null || !outputSerializerName.equals(ProtobufAnnotationSerializer.class.getName())) break;
                    return "application/x-protobuf";
                }
            }
            return "application/octet-stream";
        }

        @Override
        public void handle(HttpExchange httpExchange) throws IOException {
            block11: {
                StanfordCoreNLP.OutputFormat of;
                Annotation ann;
                Properties props;
                httpExchange.getResponseHeaders().add("Access-Control-Allow-Origin", "*");
                try {
                    props = this.getProperties(httpExchange);
                    ann = StanfordCoreNLPServer.this.getDocument(props, httpExchange);
                    of = StanfordCoreNLP.OutputFormat.valueOf(props.getProperty("outputFormat", "json").toUpperCase());
                    if (((String)ann.get(CoreAnnotations.TextAnnotation.class)).isEmpty()) {
                        Redwood.Util.log("[" + httpExchange.getRemoteAddress() + "] Interactive connection");
                        StanfordCoreNLPServer.this.staticPageHandle.handle(httpExchange);
                        return;
                    }
                    Redwood.Util.log("[" + httpExchange.getRemoteAddress() + "] API call w/annotators " + props.getProperty("annotators", "<unknown>"));
                    String text = ((String)ann.get(CoreAnnotations.TextAnnotation.class)).replace('\n', ' ');
                    System.out.println(text);
                    if (text.length() > MAX_CHAR_LENGTH) {
                        StanfordCoreNLPServer.respondBadInput("Request is too long to be handled by server: " + text.length() + " characters. Max length is " + MAX_CHAR_LENGTH + " characters.", httpExchange);
                        return;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    StanfordCoreNLPServer.respondError("Could not handle incoming annotation", httpExchange);
                    return;
                }
                Future<Annotation> completedAnnotationFuture = null;
                try {
                    Annotation completedAnnotation;
                    StanfordCoreNLP pipeline = StanfordCoreNLPServer.this.mkStanfordCoreNLP(props);
                    completedAnnotationFuture = StanfordCoreNLPServer.this.corenlpExecutor.submit(() -> {
                        pipeline.annotate(ann);
                        return ann;
                    });
                    try {
                        int timeoutMilliseconds = Integer.parseInt(props.getProperty("timeout", Integer.toString(StanfordCoreNLPServer.this.timeoutMilliseconds)));
                        if (timeoutMilliseconds > 10000 && "corenlp.stanford.edu".equals(InetAddress.getLocalHost().getHostName()) && !httpExchange.getRemoteAddress().getHostName().toLowerCase().endsWith("stanford.edu")) {
                            timeoutMilliseconds = 10000;
                        }
                        completedAnnotation = completedAnnotationFuture.get(timeoutMilliseconds, TimeUnit.MILLISECONDS);
                    }
                    catch (NumberFormatException e) {
                        completedAnnotation = completedAnnotationFuture.get(StanfordCoreNLPServer.this.timeoutMilliseconds, TimeUnit.MILLISECONDS);
                    }
                    completedAnnotationFuture = null;
                    ByteArrayOutputStream os = new ByteArrayOutputStream();
                    StanfordCoreNLP.createOutputter(props, AnnotationOutputter.getOptions(pipeline)).accept(completedAnnotation, os);
                    os.close();
                    byte[] response = os.toByteArray();
                    httpExchange.getResponseHeaders().add("Content-Type", this.getContentType(props, of));
                    httpExchange.getResponseHeaders().add("Content-Length", Integer.toString(response.length));
                    httpExchange.sendResponseHeaders(HTTP_OK, response.length);
                    httpExchange.getResponseBody().write(response);
                    httpExchange.close();
                }
                catch (TimeoutException e) {
                    e.printStackTrace();
                    StanfordCoreNLPServer.respondError("CoreNLP request timed out. Your document may be too long.", httpExchange);
                    if (completedAnnotationFuture != null) {
                        completedAnnotationFuture.cancel(true);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    StanfordCoreNLPServer.respondError(e.getClass().getName() + ": " + e.getMessage(), httpExchange);
                    if (completedAnnotationFuture == null) break block11;
                    completedAnnotationFuture.cancel(true);
                }
            }
        }

        private Properties getProperties(HttpExchange httpExchange) throws UnsupportedEncodingException {
            Map urlParams = StanfordCoreNLPServer.getURLParams(httpExchange.getRequestURI());
            Properties props = new Properties();
            this.defaultProps.entrySet().stream().forEach(entry -> props.setProperty(entry.getKey().toString(), entry.getValue().toString()));
            Map<Object, Object> urlProperties = new HashMap();
            if (urlParams.containsKey("properties")) {
                urlProperties = StringUtils.decodeMap(URLDecoder.decode((String)urlParams.get("properties"), "UTF-8"));
            } else if (urlParams.containsKey("props")) {
                urlProperties = StringUtils.decodeMap(URLDecoder.decode((String)urlParams.get("props"), "UTF-8"));
            }
            if (urlProperties.containsKey("annotators") && urlProperties.get("annotators") != null && ArrayUtils.contains(((String)urlProperties.get("annotators")).split(","), "parse")) {
                props.remove("coref.md.type");
            }
            urlProperties.entrySet().forEach(entry -> props.setProperty((String)entry.getKey(), (String)entry.getValue()));
            String annotators = StanfordCoreNLP.ensurePrerequisiteAnnotators(props.getProperty("annotators").split("[, \t]+"));
            if (!"-1".equals(props.getProperty("parse.maxlen", "60"))) {
                props.put("parse.maxlen", "60");
            }
            if (!"-1".equals(props.getProperty("pos.maxlen", "500"))) {
                props.put("pos.maxlen", "500");
            }
            props.setProperty("annotators", annotators);
            return props;
        }
    }

    protected static class FileHandler
    implements HttpHandler {
        private final String content;

        public FileHandler(String fileOrClasspath) throws IOException {
            this.content = IOUtils.slurpReader(IOUtils.readerFromString(fileOrClasspath));
        }

        @Override
        public void handle(HttpExchange httpExchange) throws IOException {
            httpExchange.getResponseHeaders().set("Content-Type", "text/html");
            httpExchange.sendResponseHeaders(HTTP_OK, this.content.getBytes().length);
            httpExchange.getResponseBody().write(this.content.getBytes());
            httpExchange.close();
        }
    }

    protected class ShutdownHandler
    implements HttpHandler {
        protected ShutdownHandler() {
        }

        @Override
        public void handle(HttpExchange httpExchange) throws IOException {
            Map urlParams = StanfordCoreNLPServer.getURLParams(httpExchange.getRequestURI());
            httpExchange.getResponseHeaders().set("Content-Type", "text/plain");
            boolean doExit = false;
            String response = "Invalid shutdown key\n";
            if (urlParams.containsKey("key") && ((String)urlParams.get("key")).equals(StanfordCoreNLPServer.this.shutdownKey)) {
                response = "Shutdown successful!\n";
                doExit = true;
            }
            httpExchange.sendResponseHeaders(HTTP_OK, response.getBytes().length);
            httpExchange.getResponseBody().write(response.getBytes());
            httpExchange.close();
            if (doExit) {
                System.exit(0);
            }
        }
    }

    protected static class PingHandler
    implements HttpHandler {
        protected PingHandler() {
        }

        @Override
        public void handle(HttpExchange httpExchange) throws IOException {
            httpExchange.getResponseHeaders().set("Content-Type", "text/plain");
            String response = "pong\n";
            httpExchange.sendResponseHeaders(HTTP_OK, response.getBytes().length);
            httpExchange.getResponseBody().write(response.getBytes());
            httpExchange.close();
        }
    }
}

