/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.stats;

import edu.stanford.nlp.stats.ClassicCounter;
import edu.stanford.nlp.util.ErasureUtils;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.MutableDouble;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class GeneralizedCounter<K>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Object[] zeroKey = new Object[0];
    private Map<K, Object> map = Generics.newHashMap();
    private int depth;
    private double total;
    private transient MutableDouble tempMDouble = null;

    private GeneralizedCounter() {
    }

    public GeneralizedCounter(int depth) {
        this.depth = depth;
    }

    public Set<Map.Entry<List<K>, Double>> entrySet() {
        return (Set)ErasureUtils.uncheckedCast(this.entrySet(new HashSet<Map.Entry<Object, Double>>(), zeroKey, true));
    }

    private Set<Map.Entry<Object, Double>> entrySet(Set<Map.Entry<Object, Double>> s, Object[] key, boolean useLists) {
        if (this.depth == 1) {
            Set<K> keys = this.map.keySet();
            for (K finalKey : keys) {
                T[] newKey = ErasureUtils.mkTArray(Object.class, key.length + 1);
                if (key.length > 0) {
                    System.arraycopy(key, 0, newKey, 0, key.length);
                }
                newKey[key.length] = finalKey;
                MutableDouble value = (MutableDouble)this.map.get(finalKey);
                Double value1 = new Double(value.doubleValue());
                if (useLists) {
                    s.add(new Entry(Arrays.asList(newKey), value1));
                    continue;
                }
                s.add(new Entry(newKey[0], value1));
            }
        } else {
            Set<K> keys = this.map.keySet();
            for (K o : keys) {
                Object[] newKey = new Object[key.length + 1];
                if (key.length > 0) {
                    System.arraycopy(key, 0, newKey, 0, key.length);
                }
                newKey[key.length] = o;
                super.entrySet(s, newKey, true);
            }
        }
        return s;
    }

    public Set<Map.Entry<List<K>, ClassicCounter<K>>> lowestLevelCounterEntrySet() {
        return (Set)ErasureUtils.uncheckedCast(this.lowestLevelCounterEntrySet(new HashSet<Map.Entry<Object, ClassicCounter<K>>>(), zeroKey, true));
    }

    private Set<Map.Entry<Object, ClassicCounter<K>>> lowestLevelCounterEntrySet(Set<Map.Entry<Object, ClassicCounter<K>>> s, Object[] key, boolean useLists) {
        Set<K> keys = this.map.keySet();
        if (this.depth == 2) {
            for (K finalKey : keys) {
                T[] newKey = ErasureUtils.mkTArray(Object.class, key.length + 1);
                if (key.length > 0) {
                    System.arraycopy(key, 0, newKey, 0, key.length);
                }
                newKey[key.length] = finalKey;
                ClassicCounter<K> c = this.conditionalizeHelper(finalKey).oneDimensionalCounterView();
                if (useLists) {
                    s.add(new Entry(Arrays.asList(newKey), c));
                    continue;
                }
                s.add(new Entry(newKey[0], c));
            }
        } else {
            for (K o : keys) {
                Object[] newKey = new Object[key.length + 1];
                if (key.length > 0) {
                    System.arraycopy(key, 0, newKey, 0, key.length);
                }
                newKey[key.length] = o;
                super.lowestLevelCounterEntrySet(s, newKey, true);
            }
        }
        return s;
    }

    public double totalCount() {
        if (this.depth() == 1) {
            return this.total;
        }
        double result = 0.0;
        for (K o : this.topLevelKeySet()) {
            result += this.conditionalizeOnce(o).totalCount();
        }
        return result;
    }

    public Set<K> topLevelKeySet() {
        return this.map.keySet();
    }

    public Set<List<K>> keySet() {
        return (Set)ErasureUtils.uncheckedCast(this.keySet(Generics.newHashSet(), zeroKey, true));
    }

    private Set<Object> keySet(Set<Object> s, Object[] key, boolean useList) {
        if (this.depth == 1) {
            Set<K> keys = this.map.keySet();
            for (K oldKey : keys) {
                Object[] newKey = new Object[key.length + 1];
                if (key.length > 0) {
                    System.arraycopy(key, 0, newKey, 0, key.length);
                }
                newKey[key.length] = oldKey;
                if (useList) {
                    s.add(Arrays.asList(newKey));
                    continue;
                }
                s.add(newKey[0]);
            }
        } else {
            Set<K> keys = this.map.keySet();
            for (K o : keys) {
                Object[] newKey = new Object[key.length + 1];
                if (key.length > 0) {
                    System.arraycopy(key, 0, newKey, 0, key.length);
                }
                newKey[key.length] = o;
                super.keySet(s, newKey, true);
            }
        }
        return s;
    }

    public int depth() {
        return this.depth;
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public double getCount(Object o) {
        Number count;
        if (this.depth > 1) {
            this.wrongDepth();
        }
        if ((count = (Number)this.map.get(o)) != null) {
            return count.doubleValue();
        }
        return 0.0;
    }

    public double getCount(K o1, K o2) {
        GeneralizedCounter gc1;
        if (this.depth != 2) {
            this.wrongDepth();
        }
        if ((gc1 = (GeneralizedCounter)ErasureUtils.uncheckedCast(this.map.get(o1))) == null) {
            return 0.0;
        }
        return gc1.getCount(o2);
    }

    public double getCount(K o1, K o2, K o3) {
        GeneralizedCounter gc1;
        if (this.depth != 3) {
            this.wrongDepth();
        }
        if ((gc1 = (GeneralizedCounter)ErasureUtils.uncheckedCast(this.map.get(o1))) == null) {
            return 0.0;
        }
        return gc1.getCount(o2, o3);
    }

    public double[] getCounts(List<K> l) {
        if (l.size() != this.depth) {
            this.wrongDepth();
        }
        double[] counts = new double[this.depth + 1];
        GeneralizedCounter<K> next = this;
        counts[0] = next.totalCount();
        Iterator<K> i = l.iterator();
        int j = 1;
        K o = i.next();
        while (i.hasNext()) {
            next = next.conditionalizeHelper(o);
            counts[j] = next.totalCount();
            o = i.next();
            ++j;
        }
        counts[this.depth] = next.getCount(o);
        return counts;
    }

    private GeneralizedCounter<K> conditionalizeHelper(K o) {
        if (this.depth > 1) {
            GeneralizedCounter<K> next = (GeneralizedCounter<K>)ErasureUtils.uncheckedCast(this.map.get(o));
            if (next == null) {
                next = new GeneralizedCounter<K>(this.depth - 1);
                this.map.put(o, next);
            }
            return next;
        }
        throw new RuntimeException("Error -- can't conditionalize a distribution of depth 1");
    }

    public GeneralizedCounter<K> conditionalize(List<K> l) {
        int n = l.size();
        if (n >= this.depth()) {
            throw new RuntimeException("Error -- attempted to conditionalize a GeneralizedCounter of depth " + this.depth() + " on a vector of length " + n);
        }
        GeneralizedCounter<K> next = this;
        for (K o : l) {
            next = next.conditionalizeHelper(o);
        }
        return next;
    }

    public GeneralizedCounter<K> conditionalizeOnce(K o) {
        if (this.depth() < 1) {
            throw new RuntimeException("Error -- attempted to conditionalize a GeneralizedCounter of depth " + this.depth());
        }
        return this.conditionalizeHelper(o);
    }

    public void incrementCount(List<K> l, K o) {
        this.incrementCount(l, o, 1.0);
    }

    public void incrementCount(List<K> l, K o, double count) {
        if (l.size() != this.depth - 1) {
            this.wrongDepth();
        }
        GeneralizedCounter<K> next = this;
        for (K o2 : l) {
            next.addToTotal(count);
            next = next.conditionalizeHelper(o2);
        }
        next.addToTotal(count);
        next.incrementCount1D(o, count);
    }

    public void incrementCount(List<K> l) {
        this.incrementCount(l, 1.0);
    }

    public void incrementCount(List<K> l, double count) {
        if (l.size() != this.depth) {
            this.wrongDepth();
        }
        GeneralizedCounter<K> next = this;
        Iterator<K> i = l.iterator();
        K o = i.next();
        while (i.hasNext()) {
            next.addToTotal(count);
            next = next.conditionalizeHelper(o);
            o = i.next();
        }
        next.incrementCount1D(o, count);
    }

    public void incrementCount2D(K first, K second) {
        this.incrementCount2D(first, second, 1.0);
    }

    public void incrementCount2D(K first, K second, double count) {
        if (this.depth != 2) {
            this.wrongDepth();
        }
        this.addToTotal(count);
        GeneralizedCounter<K> next = this.conditionalizeHelper(first);
        next.incrementCount1D(second, count);
    }

    public void incrementCount3D(K first, K second, K third) {
        this.incrementCount3D(first, second, third, 1.0);
    }

    public void incrementCount3D(K first, K second, K third, double count) {
        if (this.depth != 3) {
            this.wrongDepth();
        }
        this.addToTotal(count);
        GeneralizedCounter<K> next = this.conditionalizeHelper(first);
        next.incrementCount2D(second, third, count);
    }

    private void addToTotal(double d) {
        this.total += d;
    }

    public void incrementCount1D(K o) {
        this.incrementCount1D(o, 1.0);
    }

    public void incrementCount1D(K o, double count) {
        if (this.depth > 1) {
            this.wrongDepth();
        }
        this.addToTotal(count);
        if (this.tempMDouble == null) {
            this.tempMDouble = new MutableDouble();
        }
        this.tempMDouble.set(count);
        MutableDouble oldMDouble = (MutableDouble)this.map.put(o, this.tempMDouble);
        if (oldMDouble != null) {
            this.tempMDouble.set(count + oldMDouble.doubleValue());
        }
        this.tempMDouble = oldMDouble;
    }

    public boolean containsKey(List<K> key) {
        GeneralizedCounter<K> next = this;
        for (int i = 0; i < key.size() - 1; ++i) {
            if ((next = next.conditionalizeHelper(key.get(i))) != null) continue;
            return false;
        }
        return next.map.containsKey(key.get(key.size() - 1));
    }

    public GeneralizedCounter<K> reverseKeys() {
        GeneralizedCounter<K> result = new GeneralizedCounter<K>();
        Set<Map.Entry<List<K>, Double>> entries = this.entrySet();
        for (Map.Entry<List<K>, Double> entry : entries) {
            List<K> list = entry.getKey();
            double count = entry.getValue();
            Collections.reverse(list);
            result.incrementCount(list, count);
        }
        return result;
    }

    private void wrongDepth() {
        throw new RuntimeException("Error -- attempt to operate with key of wrong length. depth=" + this.depth);
    }

    public ClassicCounter<List<K>> counterView() {
        return new CounterView();
    }

    public ClassicCounter<K> oneDimensionalCounterView() {
        if (this.depth != 1) {
            throw new UnsupportedOperationException();
        }
        return new OneDimensionalCounterView();
    }

    public String toString() {
        return this.map.toString();
    }

    public String toString(String param) {
        switch (param) {
            case "contingency": {
                StringBuilder sb = new StringBuilder();
                for (K obj : ErasureUtils.sortedIfPossible(this.topLevelKeySet())) {
                    sb.append(obj);
                    sb.append(" = ");
                    GeneralizedCounter<K> gc = this.conditionalizeOnce(obj);
                    sb.append(gc);
                    sb.append("\n");
                }
                return sb.toString();
            }
            case "sorted": {
                StringBuilder sb = new StringBuilder();
                sb.append("{\n");
                for (K obj : ErasureUtils.sortedIfPossible(this.topLevelKeySet())) {
                    sb.append(obj);
                    sb.append(" = ");
                    GeneralizedCounter<K> gc = this.conditionalizeOnce(obj);
                    sb.append(gc);
                    sb.append("\n");
                }
                sb.append("}\n");
                return sb.toString();
            }
        }
        return this.toString();
    }

    public static void main(String[] args) {
        Object[] a1 = new Object[]{"a", "b"};
        Object[] a2 = new Object[]{"a", "b"};
        System.out.println(Arrays.equals(a1, a2));
        GeneralizedCounter<String> gc = new GeneralizedCounter<String>(3);
        gc.incrementCount(Arrays.asList("a", "j", "x"), 3.0);
        gc.incrementCount(Arrays.asList("a", "l", "x"), 3.0);
        gc.incrementCount(Arrays.asList("b", "k", "y"), 3.0);
        gc.incrementCount(Arrays.asList("b", "k", "z"), 3.0);
        System.out.println("incremented counts.");
        System.out.println(super.dumpKeys());
        System.out.println("string representation of generalized counter:");
        System.out.println(gc.toString());
        super.printKeySet();
        System.out.println("entry set:\n" + gc.entrySet());
        GeneralizedCounter.arrayPrintDouble(gc.getCounts(Arrays.asList("a", "j", "x")));
        GeneralizedCounter.arrayPrintDouble(gc.getCounts(Arrays.asList("a", "j", "z")));
        GeneralizedCounter.arrayPrintDouble(gc.getCounts(Arrays.asList("b", "k", "w")));
        GeneralizedCounter.arrayPrintDouble(gc.getCounts(Arrays.asList("b", "k", "z")));
        GeneralizedCounter<String> gc1 = gc.conditionalize(Arrays.asList("a"));
        gc1.incrementCount(Arrays.asList("j", "x"));
        gc1.incrementCount2D("j", "z");
        GeneralizedCounter<String> gc2 = gc1.conditionalize(Arrays.asList("j"));
        gc2.incrementCount1D("x");
        System.out.println("Pretty-printing gc after incrementing gc1:");
        gc.prettyPrint();
        System.out.println("Total: " + gc.totalCount());
        super.printKeySet();
        System.out.println("another entry set:\n" + gc1.entrySet());
        ClassicCounter c = gc.counterView();
        System.out.println("string representation of counter view:");
        System.out.println(c.toString());
        double d1 = c.getCount(Arrays.asList("a", "j", "x"));
        double d2 = c.getCount(Arrays.asList("a", "j", "w"));
        System.out.println(d1 + " " + d2);
        ClassicCounter<List<String>> c1 = gc1.counterView();
        System.out.println("Count of {j,x} -- should be 3.0\t" + c1.getCount(Arrays.asList("j", "x")));
        System.out.println(c.keySet() + " size " + c.keySet().size());
        System.out.println(c1.keySet() + " size " + c1.keySet().size());
        System.out.println(c1.equals(c));
        System.out.println(c.equals(c1));
        System.out.println(c.equals(c));
        System.out.println("### testing equality of regular Counter...");
        ClassicCounter<String> z1 = new ClassicCounter<String>();
        ClassicCounter<String> z2 = new ClassicCounter<String>();
        z1.incrementCount("a1");
        z1.incrementCount("a2");
        z2.incrementCount("b");
        System.out.println(z1.equals(z2));
        System.out.println(z1.toString());
        System.out.println(z1.keySet().toString());
    }

    private void printKeySet() {
        Set<List<K>> keys = this.keySet();
        System.out.println("printing keyset:");
        for (List<K> o : keys) {
            System.out.println(o);
        }
    }

    private static void arrayPrintDouble(double[] o) {
        for (double anO : o) {
            System.out.print(anO + "\t");
        }
        System.out.println();
    }

    private Set<?> dumpKeys() {
        return this.map.keySet();
    }

    public void prettyPrint() {
        this.prettyPrint(new PrintWriter(System.out, true));
    }

    public void prettyPrint(PrintWriter pw) {
        this.prettyPrint(pw, "  ");
    }

    public void prettyPrint(PrintWriter pw, String bufferIncrement) {
        this.prettyPrint(pw, "", bufferIncrement);
    }

    private void prettyPrint(PrintWriter pw, String buffer, String bufferIncrement) {
        if (this.depth == 1) {
            for (Map.Entry<List<K>, Double> e : this.entrySet()) {
                List<K> key = e.getKey();
                double count = e.getValue();
                pw.println(buffer + key + "\t" + count);
            }
        } else {
            for (K key : this.topLevelKeySet()) {
                GeneralizedCounter<Object> gc1 = this.conditionalize(Arrays.asList((Object[])ErasureUtils.uncheckedCast(new Object[]{key})));
                pw.println(buffer + key + "\t" + gc1.totalCount());
                super.prettyPrint(pw, buffer + bufferIncrement, bufferIncrement);
            }
        }
    }

    private class OneDimensionalCounterView
    extends ClassicCounter<K> {
        private static final long serialVersionUID = 5628505169749516972L;

        private OneDimensionalCounterView() {
        }

        @Override
        public double incrementCount(K o, double count) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setCount(K o, double count) {
            throw new UnsupportedOperationException();
        }

        @Override
        public double totalCount() {
            return GeneralizedCounter.this.totalCount();
        }

        @Override
        public double getCount(Object o) {
            return GeneralizedCounter.this.getCount(o);
        }

        @Override
        public int size() {
            return GeneralizedCounter.this.map.size();
        }

        @Override
        public Set<K> keySet() {
            return (Set)ErasureUtils.uncheckedCast(GeneralizedCounter.this.keySet(Generics.newHashSet(), zeroKey, false));
        }

        @Override
        public double remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsKey(Object key) {
            return GeneralizedCounter.this.map.containsKey(key);
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isEmpty() {
            return GeneralizedCounter.this.isEmpty();
        }

        @Override
        public Set<Map.Entry<K, Double>> entrySet() {
            return (Set)ErasureUtils.uncheckedCast(GeneralizedCounter.this.entrySet(new HashSet(), zeroKey, false));
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ClassicCounter)) {
                return false;
            }
            return this.entrySet().equals(((ClassicCounter)o).entrySet());
        }

        @Override
        public int hashCode() {
            int total = 17;
            for (Map.Entry o : this.entrySet()) {
                total = 37 * total + ((Object)o).hashCode();
            }
            return total;
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder("{");
            Iterator i = this.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry e = i.next();
                sb.append(e.toString());
                if (!i.hasNext()) continue;
                sb.append(",");
            }
            sb.append("}");
            return sb.toString();
        }
    }

    private class CounterView
    extends ClassicCounter<List<K>> {
        private static final long serialVersionUID = -1241712543674668918L;

        private CounterView() {
        }

        @Override
        public double incrementCount(List<K> o, double count) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setCount(List<K> o, double count) {
            throw new UnsupportedOperationException();
        }

        @Override
        public double totalCount() {
            return GeneralizedCounter.this.totalCount();
        }

        @Override
        public double getCount(Object o) {
            List l = (List)o;
            if (l.size() != GeneralizedCounter.this.depth) {
                return 0.0;
            }
            return GeneralizedCounter.this.getCounts(l)[GeneralizedCounter.this.depth];
        }

        @Override
        public int size() {
            return GeneralizedCounter.this.map.size();
        }

        @Override
        public Set<List<K>> keySet() {
            return GeneralizedCounter.this.keySet();
        }

        @Override
        public double remove(List<K> o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsKey(List<K> key) {
            return GeneralizedCounter.this.containsKey(key);
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isEmpty() {
            return GeneralizedCounter.this.isEmpty();
        }

        @Override
        public Set<Map.Entry<List<K>, Double>> entrySet() {
            return GeneralizedCounter.this.entrySet();
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ClassicCounter)) {
                return false;
            }
            return this.entrySet().equals(((ClassicCounter)o).entrySet());
        }

        @Override
        public int hashCode() {
            int total = 17;
            for (Map.Entry o : this.entrySet()) {
                total = 37 * total + ((Object)o).hashCode();
            }
            return total;
        }

        @Override
        public String toString() {
            StringBuffer sb = new StringBuffer("{");
            Iterator i = this.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry e = i.next();
                sb.append(e.toString());
                if (!i.hasNext()) continue;
                sb.append(",");
            }
            sb.append("}");
            return sb.toString();
        }
    }

    private static class Entry<K, V>
    implements Map.Entry<K, V> {
        private K key;
        private V value;

        Entry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Entry)) {
                return false;
            }
            Entry e = (Entry)ErasureUtils.uncheckedCast(o);
            K key1 = e.getKey();
            if (this.key == null || !this.key.equals(key1)) {
                return false;
            }
            V value1 = e.getValue();
            return this.value != null && this.value.equals(value1);
        }

        @Override
        public int hashCode() {
            if (this.key == null || this.value == null) {
                return 0;
            }
            return this.key.hashCode() ^ this.value.hashCode();
        }

        public String toString() {
            return this.key.toString() + "=" + this.value.toString();
        }
    }
}

