/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees;

import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.process.PTBTokenizer;
import edu.stanford.nlp.process.TokenizerFactory;
import edu.stanford.nlp.trees.AbstractTreebankLanguagePack;
import edu.stanford.nlp.trees.EnglishGrammaticalStructureFactory;
import edu.stanford.nlp.trees.GrammaticalStructureFactory;
import edu.stanford.nlp.trees.HeadFinder;
import edu.stanford.nlp.trees.ModCollinsHeadFinder;
import edu.stanford.nlp.trees.SemanticHeadFinder;
import edu.stanford.nlp.trees.TreebankLanguagePack;
import edu.stanford.nlp.trees.UniversalEnglishGrammaticalStructureFactory;
import edu.stanford.nlp.trees.UniversalSemanticHeadFinder;
import java.util.function.Predicate;

public class PennTreebankLanguagePack
extends AbstractTreebankLanguagePack {
    private static final String[] pennPunctTags = new String[]{"''", "``", "-LRB-", "-RRB-", ".", ":", ","};
    private static final String[] pennSFPunctTags = new String[]{"."};
    private static final String[] collinsPunctTags = new String[]{"''", "``", ".", ":", ","};
    private static final String[] pennPunctWords = new String[]{"''", "'", "``", "`", "-LRB-", "-RRB-", "-LCB-", "-RCB-", ".", "?", "!", ",", ":", "-", "--", "...", ";"};
    private static final String[] pennSFPunctWords = new String[]{".", "!", "?"};
    private static final char[] annotationIntroducingChars = new char[]{'-', '=', '|', '#', '^', '~', '_', '['};
    private static final String[] pennStartSymbols = new String[]{"ROOT", "TOP"};
    private static final long serialVersionUID = 9081305982861675328L;

    @Override
    public String[] punctuationTags() {
        return pennPunctTags;
    }

    @Override
    public String[] punctuationWords() {
        return pennPunctWords;
    }

    @Override
    public String[] sentenceFinalPunctuationTags() {
        return pennSFPunctTags;
    }

    @Override
    public String[] sentenceFinalPunctuationWords() {
        return pennSFPunctWords;
    }

    @Override
    public String[] evalBIgnoredPunctuationTags() {
        return collinsPunctTags;
    }

    @Override
    public char[] labelAnnotationIntroducingCharacters() {
        return annotationIntroducingChars;
    }

    @Override
    public String[] startSymbols() {
        return pennStartSymbols;
    }

    public TokenizerFactory<CoreLabel> getTokenizerFactory() {
        return PTBTokenizer.coreLabelFactory();
    }

    @Override
    public String treebankFileExtension() {
        return "mrg";
    }

    @Override
    public GrammaticalStructureFactory grammaticalStructureFactory() {
        if (this.generateOriginalDependencies) {
            return new EnglishGrammaticalStructureFactory();
        }
        return new UniversalEnglishGrammaticalStructureFactory();
    }

    @Override
    public GrammaticalStructureFactory grammaticalStructureFactory(Predicate<String> puncFilter) {
        if (this.generateOriginalDependencies) {
            return new EnglishGrammaticalStructureFactory(puncFilter);
        }
        return new UniversalEnglishGrammaticalStructureFactory(puncFilter);
    }

    @Override
    public GrammaticalStructureFactory grammaticalStructureFactory(Predicate<String> puncFilter, HeadFinder hf) {
        if (this.generateOriginalDependencies) {
            return new EnglishGrammaticalStructureFactory(puncFilter, hf);
        }
        return new UniversalEnglishGrammaticalStructureFactory(puncFilter, hf);
    }

    @Override
    public boolean supportsGrammaticalStructures() {
        return true;
    }

    @Override
    public HeadFinder headFinder() {
        return new ModCollinsHeadFinder(this);
    }

    @Override
    public HeadFinder typedDependencyHeadFinder() {
        if (this.generateOriginalDependencies) {
            return new SemanticHeadFinder((TreebankLanguagePack)this, true);
        }
        return new UniversalSemanticHeadFinder((TreebankLanguagePack)this, true);
    }

    public static void main(String[] args) {
        String[] strs;
        PennTreebankLanguagePack tlp = new PennTreebankLanguagePack();
        System.out.println("Start symbol: " + tlp.startSymbol());
        String start = tlp.startSymbol();
        System.out.println("Should be true: " + tlp.isStartSymbol(start));
        for (String str : strs = new String[]{"-", "-LLB-", "NP-2", "NP=3", "NP-LGS", "NP-TMP=3"}) {
            System.out.println("String: " + str + " basic: " + tlp.basicCategory(str) + " basicAndFunc: " + tlp.categoryAndFunction(str));
        }
    }
}

