/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees;

import edu.stanford.nlp.ling.Label;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreebankLanguagePack;
import java.io.Serializable;
import java.util.function.Predicate;
import java.util.regex.Pattern;

public class TreeFilters {
    private TreeFilters() {
    }

    public static class HasMatchingChild
    implements Predicate<Tree>,
    Serializable {
        TreebankLanguagePack tlp;
        Pattern pattern;
        private static final long serialVersionUID = 1L;

        public HasMatchingChild(TreebankLanguagePack tlp, String regex) {
            this.pattern = Pattern.compile(regex);
            this.tlp = tlp;
        }

        @Override
        public boolean test(Tree tree) {
            if (tree == null) {
                return false;
            }
            for (Tree child : tree.children()) {
                String value;
                Label label = child.label();
                String string = value = label == null ? null : label.value();
                if (value == null) continue;
                if (this.pattern.matcher(value).matches()) {
                    return true;
                }
                String basic = this.tlp.basicCategory(value);
                if (!this.pattern.matcher(basic).matches()) continue;
                return true;
            }
            return false;
        }
    }
}

