/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.tregex;

import edu.stanford.nlp.trees.HeadFinder;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.tregex.TregexMatcher;
import edu.stanford.nlp.trees.tregex.TregexPattern;
import edu.stanford.nlp.trees.tregex.VariableStrings;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

class CoordinationPattern
extends TregexPattern {
    private final boolean isConj;
    private final List<TregexPattern> children;
    private static final long serialVersionUID = -7797084959452603087L;

    public CoordinationPattern(List<TregexPattern> children, boolean isConj) {
        if (children.size() < 2) {
            throw new RuntimeException("Coordination node must have at least 2 children.");
        }
        this.children = children;
        this.isConj = isConj;
    }

    @Override
    public List<TregexPattern> getChildren() {
        return this.children;
    }

    @Override
    public String localString() {
        return this.isConj ? "and" : "or";
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.isConj) {
            if (this.isNegated()) {
                sb.append("!(");
            }
            for (TregexPattern node : this.children) {
                sb.append(node.toString());
            }
            if (this.isNegated()) {
                sb.append(")");
            }
        } else {
            if (this.isNegated()) {
                sb.append("!");
            }
            sb.append('[');
            Iterator<TregexPattern> iter = this.children.iterator();
            while (iter.hasNext()) {
                TregexPattern node = iter.next();
                sb.append(node.toString());
                if (!iter.hasNext()) continue;
                sb.append(" |");
            }
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public TregexMatcher matcher(Tree root, Tree tree, IdentityHashMap<Tree, Tree> nodesToParents, Map<String, Tree> namesToNodes, VariableStrings variableStrings, HeadFinder headFinder) {
        return new CoordinationMatcher(this, root, tree, nodesToParents, namesToNodes, variableStrings, headFinder);
    }

    private static class CoordinationMatcher
    extends TregexMatcher {
        private TregexMatcher[] children;
        private final CoordinationPattern myNode;
        private int currChild;
        private final boolean considerAll;

        public CoordinationMatcher(CoordinationPattern n, Tree root, Tree tree, IdentityHashMap<Tree, Tree> nodesToParents, Map<String, Tree> namesToNodes, VariableStrings variableStrings, HeadFinder headFinder) {
            super(root, tree, nodesToParents, namesToNodes, variableStrings, headFinder);
            this.myNode = n;
            this.children = new TregexMatcher[this.myNode.children.size()];
            this.currChild = 0;
            this.considerAll = this.myNode.isConj ^ this.myNode.isNegated();
        }

        @Override
        void resetChildIter() {
            this.currChild = 0;
            for (TregexMatcher child : this.children) {
                if (child == null) continue;
                child.resetChildIter();
            }
        }

        @Override
        void resetChildIter(Tree tree) {
            this.tree = tree;
            this.currChild = 0;
            for (TregexMatcher child : this.children) {
                if (child == null) continue;
                child.resetChildIter(tree);
            }
        }

        @Override
        public boolean matches() {
            if (this.considerAll) {
                if (this.currChild < 0) {
                    return this.myNode.isOptional();
                }
                if (this.currChild == this.children.length) {
                    --this.currChild;
                }
                while (true) {
                    if (this.children[this.currChild] == null) {
                        this.children[this.currChild] = ((TregexPattern)this.myNode.children.get(this.currChild)).matcher(this.root, this.tree, this.nodesToParents, this.namesToNodes, this.variableStrings, this.headFinder);
                        this.children[this.currChild].resetChildIter(this.tree);
                    }
                    if (this.myNode.isNegated() != this.children[this.currChild].matches()) {
                        ++this.currChild;
                        if (this.currChild != this.children.length) continue;
                        if (this.myNode.isNegated()) {
                            this.currChild = -1;
                        }
                        return true;
                    }
                    this.children[this.currChild].resetChildIter();
                    --this.currChild;
                    if (this.currChild < 0) break;
                }
                return this.myNode.isOptional();
            }
            while (this.currChild < this.children.length) {
                if (this.children[this.currChild] == null) {
                    this.children[this.currChild] = ((TregexPattern)this.myNode.children.get(this.currChild)).matcher(this.root, this.tree, this.nodesToParents, this.namesToNodes, this.variableStrings, this.headFinder);
                    this.children[this.currChild].resetChildIter(this.tree);
                }
                if (this.myNode.isNegated() != this.children[this.currChild].matches()) {
                    if (this.myNode.isNegated()) {
                        this.currChild = this.children.length;
                    }
                    return true;
                }
                ++this.currChild;
            }
            if (this.myNode.isNegated()) {
                this.currChild = this.children.length;
            }
            for (int resetChild = 0; resetChild < this.currChild; ++resetChild) {
                if (this.children[resetChild] == null) continue;
                this.children[resetChild].resetChildIter();
            }
            return this.myNode.isOptional();
        }

        @Override
        public Tree getMatch() {
            if (!this.myNode.isConj && !this.myNode.isNegated()) {
                if (this.currChild >= this.children.length || this.currChild < 0 || this.children[this.currChild] == null) {
                    return null;
                }
                return this.children[this.currChild].getMatch();
            }
            throw new UnsupportedOperationException();
        }
    }
}

