/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class AcronymMatcher {
    private static final Pattern discardPattern = Pattern.compile("[-._]");
    private static final Set<String> STOPWORDS = Collections.unmodifiableSet(new HashSet<String>(){
        {
            this.add("'d");
            this.add("'ll");
            this.add("'re");
            this.add("'s");
            this.add("'t");
            this.add("'ve");
            this.add("n't");
            this.add("a");
            this.add("about");
            this.add("above");
            this.add("after");
            this.add("again");
            this.add("against");
            this.add("all");
            this.add("am");
            this.add("an");
            this.add("and");
            this.add("any");
            this.add("are");
            this.add("as");
            this.add("at");
            this.add("be");
            this.add("because");
            this.add("been");
            this.add("before");
            this.add("being");
            this.add("below");
            this.add("between");
            this.add("both");
            this.add("but");
            this.add("by");
            this.add("cannot");
            this.add("could");
            this.add("did");
            this.add("do");
            this.add("does");
            this.add("doing");
            this.add("down");
            this.add("during");
            this.add("each");
            this.add("few");
            this.add("for");
            this.add("from");
            this.add("further");
            this.add("had");
            this.add("has");
            this.add("have");
            this.add("having");
            this.add("he");
            this.add("her");
            this.add("here");
            this.add("hers");
            this.add("herself");
            this.add("him");
            this.add("himself");
            this.add("his");
            this.add("how");
            this.add("i");
            this.add("if");
            this.add("in");
            this.add("into");
            this.add("is");
            this.add("it");
            this.add("its");
            this.add("itself");
            this.add("me");
            this.add("more");
            this.add("most");
            this.add("my");
            this.add("myself");
            this.add("no");
            this.add("nor");
            this.add("not");
            this.add("of");
            this.add("off");
            this.add("on");
            this.add("once");
            this.add("only");
            this.add("or");
            this.add("other");
            this.add("ought");
            this.add("our");
            this.add("ours");
            this.add("ourselves");
            this.add("out");
            this.add("over");
            this.add("own");
            this.add("same");
            this.add("she");
            this.add("should");
            this.add("so");
            this.add("some");
            this.add("such");
            this.add("than");
            this.add("their");
            this.add("theirs");
            this.add("them");
            this.add("themselves");
            this.add("the");
            this.add("then");
            this.add("there");
            this.add("these");
            this.add("they");
            this.add("this");
            this.add("those");
            this.add("through");
            this.add("to");
            this.add("too");
            this.add("under");
            this.add("until");
            this.add("up");
            this.add("very");
            this.add("was");
            this.add("we");
            this.add("were");
            this.add("what");
            this.add("when");
            this.add("where");
            this.add("which");
            this.add("while");
            this.add("who");
            this.add("whom");
            this.add("why");
            this.add("with");
            this.add("would");
            this.add("you");
            this.add("your");
            this.add("yours");
            this.add("yourself");
            this.add("yourselves");
            this.add("de");
            this.add("del");
            this.add("di");
            this.add("y");
            this.add("corporation");
            this.add("corp");
            this.add("corp.");
            this.add("co");
            this.add("llc");
            this.add("inc");
            this.add("inc.");
            this.add("ltd");
            this.add("ltd.");
            this.add("llp");
            this.add("llp.");
            this.add("plc");
            this.add("plc.");
            this.add("&");
            this.add(",");
            this.add("-");
        }
    });

    private static List<String> getTokenStrs(List<CoreLabel> tokens) {
        ArrayList<String> mainTokenStrs = new ArrayList<String>(tokens.size());
        for (CoreLabel token : tokens) {
            String text = (String)token.get(CoreAnnotations.TextAnnotation.class);
            mainTokenStrs.add(text);
        }
        return mainTokenStrs;
    }

    private static List<String> getMainTokenStrs(List<CoreLabel> tokens) {
        ArrayList<String> mainTokenStrs = new ArrayList<String>(tokens.size());
        for (CoreLabel token : tokens) {
            String text = (String)token.get(CoreAnnotations.TextAnnotation.class);
            if (text.isEmpty() || text.length() < 4 && !Character.isUpperCase(text.charAt(0))) continue;
            mainTokenStrs.add(text);
        }
        return mainTokenStrs;
    }

    private static List<String> getMainTokenStrs(String[] tokens) {
        ArrayList<String> mainTokenStrs = new ArrayList<String>(tokens.length);
        for (String text : tokens) {
            if (text.isEmpty() || text.length() < 4 && !Character.isUpperCase(text.charAt(0))) continue;
            mainTokenStrs.add(text);
        }
        return mainTokenStrs;
    }

    public static List<String> getMainStrs(List<String> tokens) {
        ArrayList<String> mainTokenStrs = new ArrayList<String>(tokens.size());
        mainTokenStrs.addAll(tokens.stream().filter(text -> !text.isEmpty() && (text.length() >= 4 || Character.isUpperCase(text.charAt(0)))).collect(Collectors.toList()));
        return mainTokenStrs;
    }

    public static boolean isAcronym(String str, String[] tokens) {
        return AcronymMatcher.isAcronymImpl(str, Arrays.asList(tokens));
    }

    public static boolean isAcronymImpl(String str, List<String> tokens) {
        if ((str = discardPattern.matcher(str).replaceAll("")).length() != tokens.size()) {
            tokens = tokens.stream().filter(x -> !STOPWORDS.contains(x.toLowerCase())).collect(Collectors.toList());
        }
        if (str.length() == tokens.size()) {
            for (int i = 0; i < str.length(); ++i) {
                char ch = Character.toUpperCase(str.charAt(i));
                if (tokens.get(i).isEmpty() || Character.toUpperCase(tokens.get(i).charAt(0)) == ch) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean isAcronym(String str, List<?> tokens) {
        ArrayList<String> strs = new ArrayList<String>(tokens.size());
        for (Object tok : tokens) {
            if (tok instanceof String) {
                strs.add(tok.toString());
                continue;
            }
            if (tok instanceof CoreMap) {
                strs.add((String)((CoreMap)tok).get(CoreAnnotations.TextAnnotation.class));
                continue;
            }
            strs.add(tok.toString());
        }
        return AcronymMatcher.isAcronymImpl(str, strs);
    }

    public static boolean isAcronym(CoreMap chunk1, CoreMap chunk2) {
        boolean isAcro;
        String text1 = (String)chunk1.get(CoreAnnotations.TextAnnotation.class);
        String text2 = (String)chunk2.get(CoreAnnotations.TextAnnotation.class);
        if (text1.length() <= 1 || text2.length() <= 1) {
            return false;
        }
        List<String> tokenStrs1 = AcronymMatcher.getTokenStrs((List)chunk1.get(CoreAnnotations.TokensAnnotation.class));
        List<String> tokenStrs2 = AcronymMatcher.getTokenStrs((List)chunk2.get(CoreAnnotations.TokensAnnotation.class));
        boolean bl = isAcro = AcronymMatcher.isAcronymImpl(text1, tokenStrs2) || AcronymMatcher.isAcronymImpl(text2, tokenStrs1);
        if (!isAcro) {
            tokenStrs1 = AcronymMatcher.getMainTokenStrs((List)chunk1.get(CoreAnnotations.TokensAnnotation.class));
            tokenStrs2 = AcronymMatcher.getMainTokenStrs((List)chunk2.get(CoreAnnotations.TokensAnnotation.class));
            isAcro = AcronymMatcher.isAcronymImpl(text1, tokenStrs2) || AcronymMatcher.isAcronymImpl(text2, tokenStrs1);
        }
        return isAcro;
    }

    public static boolean isAcronym(String[] chunk1, String[] chunk2) {
        boolean isAcro;
        String text1 = StringUtils.join(chunk1);
        String text2 = StringUtils.join(chunk2);
        if (text1.length() <= 1 || text2.length() <= 1) {
            return false;
        }
        List<String> tokenStrs1 = Arrays.asList(chunk1);
        List<String> tokenStrs2 = Arrays.asList(chunk2);
        boolean bl = isAcro = AcronymMatcher.isAcronymImpl(text1, tokenStrs2) || AcronymMatcher.isAcronymImpl(text2, tokenStrs1);
        if (!isAcro) {
            tokenStrs1 = AcronymMatcher.getMainTokenStrs(chunk1);
            tokenStrs2 = AcronymMatcher.getMainTokenStrs(chunk2);
            isAcro = AcronymMatcher.isAcronymImpl(text1, tokenStrs2) || AcronymMatcher.isAcronymImpl(text2, tokenStrs1);
        }
        return isAcro;
    }

    public static boolean isFancyAcronym(String[] chunk1, String[] chunk2) {
        String text1 = StringUtils.join(chunk1);
        String text2 = StringUtils.join(chunk2);
        if (text1.length() <= 1 || text2.length() <= 1) {
            return false;
        }
        List<String> tokenStrs1 = Arrays.asList(chunk1);
        List<String> tokenStrs2 = Arrays.asList(chunk2);
        return AcronymMatcher.isFancyAcronymImpl(text1, tokenStrs2) || AcronymMatcher.isFancyAcronymImpl(text2, tokenStrs1);
    }

    public static boolean isFancyAcronymImpl(String str, List<String> tokens) {
        str = discardPattern.matcher(str).replaceAll("");
        String text = StringUtils.join(tokens);
        int prev_index = 0;
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if (text.indexOf(ch) != -1) {
                if ((prev_index = text.indexOf(ch, prev_index)) != -1) continue;
                return false;
            }
            return false;
        }
        return true;
    }
}

