/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util;

import edu.stanford.nlp.util.Generics;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.Set;

public class Interner<T> {
    protected static Interner<Object> interner = Generics.newInterner();
    protected Map<T, WeakReference<T>> map = Generics.newWeakHashMap();

    public static Interner<Object> getGlobal() {
        return interner;
    }

    public static Interner<Object> setGlobal(Interner<Object> interner) {
        Interner<Object> oldInterner = Interner.interner;
        Interner.interner = interner;
        return oldInterner;
    }

    public static <T> T globalIntern(T o) {
        return (T)Interner.getGlobal().intern(o);
    }

    public void clear() {
        this.map = Generics.newWeakHashMap();
    }

    public synchronized T intern(T o) {
        WeakReference<T> ref = this.map.get(o);
        if (ref == null) {
            ref = Generics.newWeakReference(o);
            this.map.put(o, ref);
        }
        return ref.get();
    }

    public Set<T> internAll(Set<T> s) {
        Set<T> result = Generics.newHashSet();
        for (T o : s) {
            result.add(this.intern(o));
        }
        return result;
    }

    public int size() {
        return this.map.size();
    }

    public static void main(String[] args) {
        for (String str : args) {
            System.out.println(Interner.globalIntern(str) == str);
        }
    }
}

