/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util.logging;

import edu.stanford.nlp.util.logging.OutputHandler;
import edu.stanford.nlp.util.logging.Redwood;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JavaUtilLoggingHandler
extends OutputHandler {
    @Override
    public void print(Object[] channel, String line) {
        Class source = null;
        Object backupSource = null;
        Redwood.Flag flag = Redwood.Flag.STDOUT;
        for (Object c : channel) {
            if (c instanceof Class) {
                source = (Class)c;
                continue;
            }
            if (c instanceof Redwood.Flag) {
                if (c == Redwood.Flag.FORCE) continue;
                flag = (Redwood.Flag)((Object)c);
                continue;
            }
            backupSource = c;
        }
        Logger impl = null;
        impl = source != null ? Logger.getLogger(source.getName()) : (backupSource != null ? Logger.getLogger(backupSource.toString()) : Logger.getLogger("CoreNLP"));
        switch (flag) {
            case ERROR: {
                impl.log(Level.SEVERE, line);
                break;
            }
            case WARN: {
                impl.log(Level.WARNING, line);
                break;
            }
            case DEBUG: {
                impl.log(Level.FINE, line);
                break;
            }
            case STDOUT: 
            case STDERR: {
                impl.info(line);
                break;
            }
            case FORCE: {
                throw new IllegalStateException("Should not reach this switch case");
            }
            default: {
                throw new IllegalStateException("Unknown Redwood flag for slf4j integration: " + (Object)((Object)flag));
            }
        }
    }
}

