local box = {}
local act = require "actions"
local u   = require "utils"

function box.put_request(req)
    local headers = req.headers
    local part = req.headers["Content-Range"]
    if part == nil then
        return
    end
    -- Ignore anything other than the first buffer
    if string.match(part, "^bytes%s+0%-") == nil then
        act.ignore_request()
    end

    return
end

-- Called when request is received but before body is read
function box.request(req)
   local url = req.url
   if req.method == "PUT" then
      return box.put_request(req)
   end
   if req.method ~= "POST" then
      return
   end
   local headers = req.headers
   -- Box sends filename in X-File-Name header
   local file = req.headers["X-File-Name"]
   if file == nil then
      return
   end
   file = u.url_decode(file)
   act.file_upload(file)
   
end


return box
