local gmail = {}
local act = require "actions"


-- Handle sendmail action
function gmail.sendAction(req, draft)
   local body = req.body
   if body == nil then
      return
   end
   local subject, b, html
   if body["subject"] ~= nil and body["subject"][1] ~= nil then
      subject = body["subject"][1]
   end

   if body["body"] ~= nil and body["body"][1] ~= nil then
      b = body["body"][1]
   end
   if body["ishtml"] ~= nil and body["ishtml"][1] ~= nil then
      html = (body["ishtml"][1] == "1")
   end

   -- Report sendmail action to proxy
   act.sendMail(draft, "", body["to"], body["cc"], body["bcc"],
		subject, b, html)
end

-- Handle attach file
function gmail.attachAction(req)
   local query = req.query
   if query.upload_id ~= nil then
      local h = req.headers
      local fileName = h["X-Goog-Upload-File-Name"]
      if fileName ~= nil then
	 fileName = unescape_url(fileName)
	 act.file_upload(fileName)
      end
   end
end

-- Called when request is received but before body is read
function gmail.request(req)
   local action = nil
   if string.find(req.url, "/_/upload") ~= nil then
      gmail.attachAction(req)
      return
   end
   -- Get query parsed as table
   local query = req.query
   if query["act"] == nil or query["act"][1] == nil then
      return
   end
   
   action = req.query["act"][1]

   -- gmail uses action == sd for save draft and action == sm for
   -- sendmail
   if action == "sm" then
      gmail.sendAction(req, false)
   elseif action == "sd" then
      gmail.sendAction(req, true)
   else
	 return
   end

end


return gmail
