local google_inbox = {}
local act = require "actions"
local u = require "utils"

local ctx = nil
local defaultExpiry = 10*1000*1000*1000
-- This is ugly.
-- But there is no other way to reverse engineer inbox. Do we really want to parse inbox?

function google_inbox.sendAction(body)
   if body["2"] ~= nil and body["2"]["1"] ~= nil and body["2"]["1"][1] ~= nil and body["2"]["1"][1]["2"] ~= nil and body["2"]["1"][1]["2"] ~= nil and body["2"]["1"][1]["2"]["2"]["14"] ~= nil then
      local chunk = body["2"]["1"][1]["2"]["2"]["14"]["1"]
      local t = chunk["11"]

      local draft = true
      if u.has_value("^f_cl", t) then
	 draft = false
      end
      local from = google_inbox.format_email(chunk["2"])
      
      local to = google_inbox.collect_emails(chunk["3"])
      local cc = google_inbox.collect_emails(chunk["4"])
      local bcc = google_inbox.collect_emails(chunk["5"])
      act.sendMail(draft, from, to, cc, bcc, chunk["8"], chunk["9"]["2"][1]["2"], true)
   end
end

function google_inbox.collect_emails(addrs)
   if addrs == nil then
      return nil
   end
   local addresses = {}
   for k,v in pairs(addrs) do
      table.insert(addresses, google_inbox.format_email(v))
   end
   return addresses
end

function google_inbox.format_email(data)
   if data == nil then
      return ""
   end

   if data["3"] ~= nil then
      if data["2"] == data["3"] then
	 return data["3"]
      end
      if data["2"] ~= nil then
	 return data["3"] .. " <"..data["2"]..">"
      end
   end
end

function google_inbox.request(req)
   ctx = nil
   local headers = req.headers
   if string.find(req.url, "/_/upload") ~= nil then
      local query = req.query
      if query.upload_id == nil then
	 local fileName = headers["X-Goog-Upload-File-Name"]
	 if fileName ~= nil and fileName ~= "" then
	    ctx = {type="UPLOAD", fileName=fileName}

	 end
	 return
      end
      local dbKey = "google-inbox:upload_id:".. query.upload_id[1]
      
      local fname = db.get_delete(db.Lru, dbKey)
      if fname == nil or fname == "" then
	 return
      end
      act.file_upload(fname)            
   end
   if string.find(req.url, "/sync/") ~= nil then
      local body = req.body
      if body ~= nil then
	 google_inbox.sendAction(body)
      end
   end
end

function google_inbox.response(resp)
   
   if ctx == nil or ctx.type ~= "UPLOAD" then
      return
   end
   
   local header = resp.headers
   local uploadId = header["X-Guploader-Uploadid"]
   local dbKey = "google-inbox:upload_id:".. uploadId
   db.set(db.Lru, dbKey, ctx.fileName, defaultExpiry)
end


return google_inbox
