local google_translate = {}
local act = require "actions"
local u = require "utils"

-- Handle incoming requests
function google_translate.request(req)
    local url = req.url
    local body = req.body
    if body == nil then
        return
    end
    if req.method == "POST" then
        if string.match(url, "batchexecute") ~= nil then
            local query = req.query
            if query["rpcids"] ~=nil then
                if body["f.req"] ~=nil and body["f.req"][1] ~= nil then
                    local rpc = body["f.req"][1]
                    local outer = decode_json(rpc)
                    if outer ~= nil and outer[1] ~= nil and outer[1][1] ~= nil and outer[1][1][2] ~= nil then
                        local inner = decode_json(outer[1][1][2])
                        if inner ~= nil and inner[1] ~= nil and inner[1][1] ~= nil then
                            if query["rpcids"][1] == "MkEWBc" then
                                --Handle text translation
                                act.file_upload("POSTDATA.TXT", inner[1][1])
                            else
                                if query["rpcids"][1] == "LBEnTe" then
                                    --Handle document translation
                                    -- NOTE this only works reliably because google translate
                                    --      limits the document size to 10MB which is less than
                                    --      cfg.MaxDecodeLength of 32MB
                                    local head = decode_base64(inner[1][1])
                                    if head ~= nil then
                                        act.file_upload("POSTDATA.TXT", head)
                                    end
                                end
                            end
                        end
                    end
                end
            end
        end
    end
end

-- Handle response to the browser
function google_translate.response(resp)
end

return google_translate
