local sharepoint = {}
local act = require "actions"
local u = require "utils"



local ctx = nil

function sharepoint.upload_request(req, q)
   local query = req.query  
   if req.method == "POST" then
      if query[q] ~= nil and query[q][1] ~= nil then
	 act.file_upload(query[q][1])
      end
   end
end


-- Handle incoming requests
function sharepoint.request(req)
   ctx = nil
   local url = req.url
   
   if string.match(url, "SPFileSync/sync") ~= nil then
      ctx = {upload="onedrive"}
   elseif string.match(url, "Files/AddUsingPath") ~= nil then
      -- Browser based upload
      return sharepoint.upload_request(req, "@a2")
   elseif string.match(url, "GetFileByServerRelativePath") ~= nil then
      return sharepoint.upload_request(req, "@a1")
   end
end


function sharepoint.request_part(p)
   if ctx ~= nil and ctx["upload"] == "onedrive" then

      if ctx["file"] ~= nil then
	 act.file_upload(ctx["file"])
	 ctx["file"] = nil
	 return
      end
      
      local body = p.body
      local headers = p.headers
      
      
      if body == nil or body["Items"] == nil then
	 return
      end
      local items = body["Items"]
      if items["Document"] ~= nil and items["Document"]["WriteMode"] == "Create" then
	 ctx["file"] = items["Document"]["RelationshipName"]
	 act.ignore_request()
      end
   end
end

return sharepoint
