local utils = {}

-- Deep Print a table
local function deep_print_r (e, space)
   if space == nil then
      space = ""
   end
   space = space .. "\t"
    -- if e is a table, we should iterate over its elements
   if type(e) == "table" then
       for k,v in pairs(e) do -- for every element in the table	  
	  io.write("\n",space, k,":")
	  utils.deep_print(v, space)       -- recursively repeat the same procedure
        end
    else -- if not, we can just print it
       io.write(space, tostring(e))
    end
end

function utils.deep_print (e, space)
   deep_print_r(e, space)
   print()
end
--- Print keys
function utils.print_keys(e)
   for k,v in pairs(e) do -- for every element in the table	  
      print(k)
   end
end

--- Check if a needle exists in a haystack(array)
function utils.has_value(needle, haystack)
   for index, value in ipairs(haystack) do
      if value == needle then
	 return true
      end
   end
   return false
end

-- Split string with sep. If sep is nil <SPACE> is used a sep
function utils.string_split(inputstr, sep)
        if sep == nil then
                sep = "%s"
        end
        local t={}
	local i=1
        for str in string.gmatch(inputstr, "([^"..sep.."]+)") do
                t[i] = str
                i = i + 1
        end
        return t
end

local function hex_to_char(x)
  return string.char(tonumber(x, 16))
end

function utils.url_decode(url)
  return url:gsub("%%(%x%x)", hex_to_char)
end

return utils
