local yahoo_mail = {}
local act = require "actions"
local u = require "utils"

local EMBEDDED="embedded"
local DONE="done"

local ctx = nil

-- Record sendmail action
function yahoo_mail.sendAction(body, draft)
   if body == nil then
      return
   end
   if body["message"] == nil or body["message"]["headers"] == nil then
      return
   end
   
   local headers = body["message"]["headers"]

   local b,html
   if body["simpleBody"]["html"] ~= nil then
      b = body["simpleBody"]["html"]
      html = true
   elseif body["simpleBody"]["text"] ~= nil then
      b = body["simpleBody"]["text"]
      html = false
   end
   local from = yahoo_mail.collectEmails(headers["from"])[1]
   local cc = yahoo_mail.collectEmails(headers["cc"]) 
   local to = yahoo_mail.collectEmails(headers["to"]) 
   local bcc = yahoo_mail.collectEmails(headers["bcc"]) 
   local subject = headers["subject"]
  
   act.sendMail(draft, from, to, cc, bcc, subject, b, html)
end

function yahoo_mail.collectEmails(addr)
   local addresses = {}
   for k,v in ipairs(addr) do
      if v["name"] == nil then
	 table.insert(addresses, "<"..v["email"]..">")
      else
	 table.insert(addresses, v["name"] .. " <"..v["email"]..">")
      end
   end
   return addresses
end

-- Handle incoming requests
function yahoo_mail.request(req)
   local headers = req.headers
   local url = req.url
   
   ctx = nil

   if req.method ~= "POST" then
      return
   end
   if string.match(url,"batch") then
      ctx = {type=EMBEDDED}
      return	 
   end
   
   if req.method ~= "POST" or string.match(url, "mailboxes") == nil or string.match(url, "messages") == nil then
      return
   end
   
   local body = req.body
   yahoo_mail.sendAction(body, true)

end

function yahoo_mail.request_part(p)
   if ctx == nil or ctx["type"] ~= EMBEDDED then
      return
   end

   local body = p.body

   if body.form_name ~= "batchJson" then
      ctx = nil
      return
   end
   body = decode_json(body.form_value)
   if body.requests ~= nil then
      for k,v in pairs(body.requests) do
	 if v ~= nil and v.payloadParts ~= nil and v.payloadParts[1] ~= nil then
	    if v.id == "SendMessage" then
	       yahoo_mail.sendAction(v.payloadParts[1]["payload"], false)
	    elseif v.id == "SaveMessage" then
	       yahoo_mail.sendAction(v.payloadParts[1]["payload"], true)
	    end
	 end
      end
   end
   ctx["type"] = DONE
end

-- Handle outgoing response
function yahoo_mail.response(resp)
end

return yahoo_mail
