local yahoo_classic = {}
local act = require "actions"
local u = require "utils"


local function collectFromEmail(from)
   if from ~= nil then
      return from[1]
   end
   return nil
end

local function collectEmail(email)
   if email[1] == nil then
      return nil
   end
   return u.string_split(email[1], ",")
end

-- Handle incoming requests
function yahoo_classic.request(req)
   local body = req.body
   
   if body == nil then return end

   local from = collectFromEmail(body.defFromAddress)
   local to = collectEmail(body.to)
   local cc = collectEmail(body.cc)   
   local bcc = collectEmail(body.bcc)
   local subject = collectEmail(body.bcc)
   local b, subject, draft
   
   if body.Content ~= nil then
      b = body.Content[1]
   end
   if body.Subj ~= nil then
      subject = body.Subj[1]
   end
   
   if body.action_msg_savedraft ~= nil then
      draft = body.action_msg_savedraft[1] ~= "Send"
   end
   act.sendMail(draft, from, to, cc, bcc,
		subject, b, false)


end


return yahoo_classic
