# Calculating Valid Domains For Bdd-Based Interactive Configuration

Tarik Hadzic, Rune Moller Jensen, Henrik Reif Andersen Computational Logic and Algorithms Group, IT University of Copenhagen, Denmark tarik@itu.dk,rmj@itu.dk,hra@itu.dk Abstract. In these notes we formally describe the functionality of Calculating Valid Domains from the BDD representing the solution space of valid configurations. The formalization is largely based on the CLab [1] configuration framework.

## 1 Introduction

Interactive configuration problems are special applications of Constraint Satisfaction Problems (CSP) where a user is assisted in interactively assigning values to variables by a software tool. This software, called a configurator, assists the user by calculating and displaying the available, valid choices for each unassigned variable in what are called valid domains computations. Application areas include customising physical products (such as PC's and cars) and services (such as airplane tickets and insurances).

Three important features are required of a tool that implements interactive configuration: it should be complete (all valid configurations should be reachable through user interaction), backtrack-free (a user is never forced to change an earlier choice due to incompleteness in the logical deductions), and it should provide real-time performance (feedback should be fast enough to allow real-time interactions). The requirement of obtaining backtrack-freeness while maintaining completeness makes the problem of calculating valid domains NP-hard. The real-time performance requirement enforces further that runtime calculations are bounded in polynomial time. According to userinterface design criteria, for a user to perceive interaction as being real-time, system response needs to be within about 250 milliseconds in practice [2]. Therefore, the current approaches that meet all three conditions use off-line precomputation to generate an efficient runtime data structure representing the solution space [3,4,5,6]. The challenge with this data structure is that the solution space is almost always exponentially large and it is NP-hard to find. Despite the bad worst-case bounds, it has nevertheless turned out in real industrial applications that the data structures can often be kept small [7,5,4].

## 2 Interactive Configuration

The input *model* to an interactive configuration problem is a special kind of Constraint Satisfaction Problem (CSP) [8,9] where constraints are represented as propositional formulas: