The significance of this demand is that it guarantees the user backtrack-free assignment to variables as long as he selects values from valid domains. This reduces cognitive effort during the interaction and increases usability.

At each step of the interaction, the configurator reports the valid domains to the user, based on the current partial assignment ρ resulting from his earlier choices. The user then picks an unassigned variable xj ∈ X \ dom(ρ) and selects a value from the calculated valid domain vj ∈ D
ρ j
. The partial assignment is then extended to ρ ∪
{(xj , vj )} and a new interaction step is initiated.

## 3 Bdd Based Configuration

In [5,10] the interactive configuration was delivered by dividing the computational effort into an *offline* and *online* phase. First, in the offline phase, the authors compiled a BDD representing the solution space of all valid configurations Sol = {ρ | ρ |= F}.

Then, the functionality of *calculating valid domains* (**CV D**) was delivered online, by efficient algorithms executing during the interaction with a user. The benefit of this approach is that the BDD needs to be compiled only once, and can be reused for multiple user sessions. The user interaction process is illustrated in Fig. 2.

InCo(Sol, ρ)
1: while |Solρ| > 1 2: compute D
ρ = CVD(Sol, ρ)
3: report D
ρ **to the user**
4: the user chooses (xi, v) **for some** xi 6∈ dom(ρ), v ∈ D
ρ i 5: ρ ← ρ ∪ {(xi, v)}
6: return ρ Fig. 2. Interactive configuration algorithm working on a BDD representation of the solutions Sol reaches a valid total configuration as an extension of the argument ρ.

Important requirement for online user-interaction is the guaranteed real-time experience of user-configurator interaction. Therefore, the algorithms that are executing in the online phase must be provably efficient in the size of the BDD representation. This is what we call the *real-time guarantee*. As the **CV D** functionality is NP-hard, and the online algorithms are polynomial in the size of generated BDD, there is no hope of providing polynomial size guarantees for the worst-case BDD representation. However, it suffices that the BDD size is small enough for all the configuration instances occurring in practice [10].

## 3.1 Binary Decision Diagrams

A reduced ordered Binary Decision Diagram (BDD) is a rooted directed acyclic graph representing a Boolean function on a set of linearly ordered Boolean variables. It has one or two terminal nodes labeled 1 or 0 and a set of variable nodes. Each variable node