# Bioinformatics Vol. 00 No. 00 2005 Pages 1–7 A Study Of Structural Properties On Profile Hmms Juliana S Bernardes A ∗ , Alberto M. R. Davila ´ B , V´Itor Santos Costa C , Gerson Zaverucha A Acoppe Engenharia De Sistemas E Computac¸Ao, Ufrj, Rio De Janeiro, ˜ B Instituto Oswaldo Cruz, Fiocruz, Rio De Janeiro, Brazil, Ccracs And Dcc-Fcup, Universidade Do Porto, Portugal

## Abstract

Motivation: Profile hidden Markov Models (pHMMs) are a popular and very useful tool in the detection of the remote homologue protein families. Unfortunately, their performance is not always satisfactory when proteins are in the "twilight zone". We present HMMER-STRUCT, a model construction algorithm and tool that tries to improve pHMM performance by using structural information while training pHMMs. As a first step, HMMER-STRUCT constructs a set of pHMMs. Each pHMM is constructed by weighting each residue in an aligned protein according to a specific structural property of the residue. Properties used were primary, secondary and tertiary structures, accessibility and packing. HMMER-STRUCT then prioritizes the results by voting.

Results: We used the SCOP database to perform our experiments.

Throughout, we apply leave-one-family-out cross-validation over protein superfamilies. First, we used the MAMMOTH-mult structural aligner to align the training set proteins. Then, we performed two sets of experiments. In a first experiment, we compared structure weighted models against standard pHMMs and against each other.

In a second experiment, we compared the voting model against individual pHMMs. We compare method performance through ROC curves and through Precision/Recall curves, and assess significance through the paired two tailed t-test. Our results show significant performance improvements of all structurally weighted models over default HMMER, and a significant improvement in sensitivity of the combined models over both the original model and the structurally weighted models.

Availability: The HMMER-STRUCT tool has been implemented as Perl scripts and as C source code. The structure weighting procedure is available as a patch to the HMMER program. All the test sets, train sets, programs and scripts used in this study are available in http://wiki.biowebdb.org/index.php/Hmmer-struct.

Contact: julianab@cos.ufrj.br

## 1 Introduction

One of the major tasks in computational molecular biology is to aid large-scale protein annotation and biological knowledge discovery. Functional characterization of unknown-function proteins is often inferred through sequence similarity search methods, such as BLAST (Altschul *et al*., 1990) and FASTA (Pearson, 1985). However, when the evolutionary relationship among proteins is distant, methods based on profile hidden Markov models (pHMMs)
(Eddy, 1996; Krogh *et al*., 1994) are known to outperform methods 
∗to whom correspondence should be addressed based on sequence similarity search (Gough *et al*., 2001; Park *et al*.,
1998).

Profile Hidden Markov Models are probabilistic models that are often used to represent groups of homolog sequences. These models have been a key tool in protein annotation, and are highly effective for scoring similar sequences. Unfortunately, the performance of pHMMs degrades for sequences in the twilight zone, that is, for homologue sequences with low identity (below 30%). This limitation has motivated a number of different approaches to increase pHMM performance. Proposals include new scoring functions, new null models (Karplus *et al*., 2005) and prior probability
(Brown *et al*., 1993). Researchers have also combined other information with pHMMs: T-HMM (Qian *et al*., 2004) uses phylogenetic information; HMM-STR (Bystroff *et al*., 2000), combines pHMMs and support vector machines (Sch¨olkopf *et al*., 1999).

The observation that homologue proteins tend to preserve structure suggests that structural information should be extremely relevant in detecting homologues. In fact, it has been shown that pHMMs trained with multiple sequence alignments based on proteins structural alignment can have better performance than pHMMs based on state-of-the art aligners that apply primary sequence information only, when remote homology detections are assessed (Bernardes *et al*., 2007). In this vein, researchers have proposed special alphabets to represent structural elements in pHMMs
(Goyon *et al*., 2004), or modifying pHMM structure to add protein three-dimensional information (Alexandrov *et al*., 2004). Although such methods are more powerful than pHMMs, arguably they are computationally more expensive both in training and in classification, and to the best of our knowledge have not become widely used.

We present a novel method to apply structural information in protein classification. In contrast to the previous approaches, our method relies on pHMMs. Our main contribution is a residue weighting-algorithm that incorporates protein structural information into pHMMs. Further, we apply different structural properties to train a library of 5 pHMMs from a homologue protein set. The properties we consider are primary, secondary, and tertiary structure, also used in previous methods. We also apply two properties that, to the best of our knowledge, have not been used in this task before, but that are often important in this domain: solvent accessibility and residue packing. The classification of a unknownfunction protein is then obtained by combining the classification from the library of pHMMs. The main advantage of our method is that structural information is only used to train the pHMMs. Notice that scoring is still performed using sequence data, as opposed to