(Alexandrov *et al*., 2004). Our method was implemented by extending the HMMER package and experimental evaluation using the SCOP database showed significant improvement over HMMER.

## 2 Methods

In our experiments, a protein homologue set is aligned by utilizing the MAMMOTH-mult (Attwood *et al*., 2005) aligner. MAMMOTH produces two outputs: one represents the multiple sequence alignment (based on spatial coordinates similarity) and the other the structural alignment. These outputs are used to build weight matrices M
′

s
, which represent residue structural weights for each protein. These matrices were used on pHMM
training stage. The section 2.2 will give more details on the building of M
′

s
.

Basically, our approach builds five pHMMs. The simplest pHMM is built from MAMMOTH's multiple sequence alignment, by keeping the default sequence-weighting algorithm of HMMER. This model is called *pHMM1D*.

In order to aid to build the remaining pHMMs our approach generates M
′

s
.

The matrices used in building pHMM2D, *pHMMAcc* and *pHMMOi*, incorporate secondary structure, residue solvent accessibility, and residue packing information, respectively. In order to build these matrices were used both MAMMOTH sequence alignment plus structural properties obtained using the joy package (Mizuguchi *et al*., 1998) to collect these information from PDB coordinates (Helen *et al*., 2000). Last, we used MAMMOTH's multiple sequence alignment plus structural alignment to build a matrix based on homologue core structures (Matsuo *et al*., 1999). That matrix was used to build *pHMM3D*. Figure 1 shows the proposed method. Fig. 1. First, a homologue protein set is aligned by using MAMMOTH-mult

![0_image_0.png](0_image_0.png)

aligner. The aligner produces a multiple sequence alignment and a structural alignment. The multiple sequence alignment is used to build a conventional pHMM using HMMER package, *pHMM1D*. Aligned sequences are fed to the joy tool. The joy output is used to construct weight matrices, which are then used to build secondary *pHMM2D*, accessibility *pHMMAcc*, and packing *pHMMOi* models. Finally, the structural alignment is used to find the homologue core structure, which is then used to construct *pHMM3D*.

## 2.1 Profile Hmms

Profile HMMs represent conserved regions in sequences as sequences of match (M) states. Inserted material is represented as *insert* states (I), and deleted regions as *delete* states (D). The parameters of pHMMs are probabilities of two events: a *transition probability* from a state to another state, and a probability that a specific state will emit a specific residue (say, a specific amino-acid when comparing proteins), called *emission probability*. Obviously, only match and insert states generate characters and have an emission probability distribution; delete states are quiet. In the case of proteins, emission distributions have 20 entries, one per amino-acid.

Possible transitions define the structure of the pHMM. Systems such as SAM (Hughey *et al*., 1996) allow transitions between all types of states, totaling 3 transitions per state, hence 9 per node. On the other hand, the HMMER system relies on the Plan7 model (Eddy, 1998), which disallows I → D and D → I transitions.

Emission probabilities are calculated by the equation 1, where cj (σ) is the observed frequency of residue σ in j column of the alignment, and α(σ) represents the pseudo counts of residue σ, which are obtained from Dirichlet mixtures, as seen in (Brown *et al*., 1993).

$$e_{j}(\sigma)={\frac{c_{j}(\sigma)+\alpha(\sigma)}{\sum_{k}c_{j}(\sigma_{k})+\alpha(\sigma_{k})}}$$
$$(1)$$

In the same way, the transition probability can be found through the equation 2, where ckl is the observed frequency of transitions between state k and state l, where k, l ∈ {**M, I, D**}, and αkl represents the pseudo counts of transition between k and l.

$$t_{k l}={\frac{c_{k l}+\alpha_{k l}}{\sum_{l}c_{k l}+\alpha_{k l}}}$$
$$(2)$$

ckl + αkl(2)

## 2.2 Sequence Weighting

One problem in representing families of sequences is that often sets of very similar sequences may be over-represented in the training sequences, introducing bias. Therefore, *sequence-weighting* methods were introduced to compensate for over-representation among multiply aligned sequences.

In general, very similar sequence receives lower weights and divergent sequence higher weight. Sequence weighting was applied to the construction of position-specifics score matrix (PSSM) (Gribskov *et al*., 1987), and is fundamental to the performance of profile HMMs. In the latter case, the default sequence weighting method used by HMMER package is a high quality algorithm based on phylogenetic trees (Gerstein *et al*., 1994).

Let A be an generic alignment used to train a pHMM. Suppose, A with N sequences and length L. Then, we can represent A alignment weights as a matrix W, such that wij represents the weight of an amino-acid of protein I in the j th alignment position, as shown in the equation 3. Basically, a sequence-weighting method for pHMMs attributes equal weights to all residues in the protein, that is, wij = wik for ∀**j, k** ≤ L.

$${\bf W}=\left(\begin{array}{cccc}w_{11}&\ldots&w_{1L}\\ \vdots&\vdots&\vdots\\ w_{N1}&\ldots&w_{NL}\end{array}\right)\tag{3}$$

In the spirit of PSSMs, we propose to reinforce residues that correspond to preserved regions in the protein. Our motivation is that when homologue proteins are structurally aligned, spatial overlapping of an atom set occurs.

This set is called the invariant core or *core structure*, and can be used to characterize homologue proteins. We argue that the residues in the core structure should carry more weight rather than the residues outside the core. Thus, we propose sequence-weighting method that gives different weight to each residue in the same protein, based on structural relevance. We will represent such "structural" weights by a matrix Ms, where each residue of the same protein has a different weight.

$${\bf M_{s}}=\left(\begin{array}{cccc}m_{11}&\ldots&m_{1L}\\ \vdots&\vdots&\vdots\\ m_{N1}&\ldots&w_{NL}\end{array}\right)\tag{4}$$
