

![0_image_0.png](0_image_0.png)

![0_image_1.png](0_image_1.png)

As mentioned before, the default sequence-weighting method used by HMMER package is a high quality algorithm. Therefore, we combine both the default HMMER's M matrix in (3) and the of Ms structural matrix in
(4), as shown in (5).

$$\mathbf{M_{s}^{'}=M M_{s}^{T}=\left(\begin{array}{c c c}{{w_{11}m_{11}}}&{{\ldots}}&{{w_{1L}m_{1L}}}\\ {{}}&{{}}&{{}}\\ {{\vdots}}&{{\vdots}}&{{\vdots}}\\ {{w_{N1}m_{N1}}}&{{\ldots}}&{{w_{N L}m_{N L}}}\end{array}\right)}\qquad(5)$$

However, introducing weights affect the computation of the observed frequencies. More precisely, the observed frequency cj (σ) shown in 1 is now found through the equation 6, where sij = wijmij is structural weight of residue σ, according to M
′

s matrix.

$$c_{j}(\sigma)=\sum_{i}^{N}f(\sigma)\ \therefore f(\sigma)=\left\{\begin{array}{cc}s_{ij},&\mbox{if$\sigma$is the amino-acid in position ij}\\ \\ 0,&\mbox{otherwise}\end{array}\right.\tag{6}$$

In the same way, we apply the equations 7 to determine ckl shown in 2.

If the k and l states are either M or I states, ckl can be calculated through the arithmetic mean of mik and mil . If at least one state is a D state, ckl is either mik, if l ∈ {D}, or mil , if k ∈ {D}. Last, if both are D states, ckl is 1.

$$c_{kl}=\sum_{i}^{N}f_{kl}\cdot\cdot f_{kl}=\left\{\begin{array}{cc}\frac{s_{ik}+s_{il}}{2},&\mbox{se k,l}\in\{M,I\}\\ \\ s_{ik},&\mbox{se l}\in\{D\}\;e\;\mbox{k}\notin\{D\}\\ \\ s_{il},&\mbox{se k}\in\{D\}\;e\;\mbox{l}\notin\{D\}\\ \\ 1,&\mbox{se k,l}\in\{D\}\end{array}\right.\tag{7}$$

## 2.3 The Ms Structural Weight Matrices

As explained above, our algorithm considers a number of different sources of structural information. Next, we approach how this information was obtained and used to built Ms matrix.

2.3.1 Secondary structural elements Secondary structure is often conserved among homologue proteins. Indeed, *motifs* (Branden *et al*., 1991),
consensus sequences in homologue proteins, usually include a combination of well conserved secondary structure elements (Chakrabarti *et al*., 2004).

In order to build a Ms matrix based on secondary structure elements we need to identify secondary structure elements in the original sequences. This is possible because we assume we have full structural data for the *training* sequences. In this work, we chose to utilize the SSTRUCT program, part of the widely used joy package (Mizuguchi *et al*., 1998), to extract secondary elements from the PDB files. SSTRUCT output is a character sequence, such that the characters {L=loop, H=helix, C=sheet} match a secondary structure element against a residue, as shown in figure 2. Following Deane's work on the relative frequency of conserved regions (Deane *et al*., 2003), we mapped each SSTRUCT element as follows: L → 1, H → 2, and C → 4.

Our mapping thus favours conservation in sheets, and gives default weight to loops. Although the active site of proteins can be found in loops, these regions often contain *indel* segments. Figure 2 shows an example of structural weight attributions for proteins in a partial alignment.

2.3.2 Solvent Inaccessibility The hydrophobic interactions of nonpolar side chains in amino-acids are believed to contribute significantly to the stability of the tertiary structures in proteins. Hydrophobic amino-acids will tend to cluster together, not as a result of attraction, but as a result of their repulsion by the hydrogen bond water network in which the protein is dissolved. Therefore, these amino-acids will preferentially be located away from the surface of the molecule. Since they form the core of protein, they tend to be more conserved and are, thus, more useful for identifying remote evolutionary relationships.

We have utilized the PSA (Lee *et al*., 1971) program to provide solvent inaccessibility information. PSA is part of the JOY package. The Ms matrix was built giving weight 3 for inaccessible residues and weight one to the others. The weights are based on (Chakrabarti *et al*., 2004), which demonstrated empirically that inaccessible amino-acids are three times more conserved than accessible amino-acids. The Ms matrix represents structural weights that were used to build the model *pHMMAcc*, as shown in figure 1.

2.3.3 Packing density The tertiary structure of proteins stems from a very large number of atomic interactions. In regions where the interactions are stronger residues tend to be packed together. It is well known that densely packed regions tend to be preserved, and hence that amino-acids belonging to those regions are usually more conserved than other amino-acids. TJ Ooi created a measure, called the Ooi Number (Nishikawa *et al*., 1986), that estimates the amino-acid packing density. Essentially, the Ooi number counts for a residue counts the number of neighboring C-α atoms within a radius of 14A of the given residues own C- ˚ α. Although crude, this measure does give a good impression of which parts of the structure are buried and which are exposed on the surface.

We again use the JOY package to obtain the Ooi number and estimate packing density. Figure 3 shows a stretch of JOY output, in which the numbers represent the Ooi measure for the Dehaloperoxidase protein in the Globins family (16wc PDB code). We used these numbers to build the structural weight matrix Ms. The structural weights were than used to build the model *pHMMOoi*, as shown in figure 1.

![0_image_2.png](0_image_2.png)

Fig. 3. Ooi measure for the Dehaloperoxidase protein of Globins family
(16wc PDB code), each number represents the amount of neighbor aminoacids inside a radius of 14A. ˚
3