# Comparing Robustness Of Pairwise And Multiclass Neural-Network Systems For Face Recognition

J. Uglov, V. Schetinin, C. Maple Computing and Information System Department, University of Bedfordshire, Luton, UK
Abstract. Noise, corruptions and variations in face images can seriously hurt the performance of face recognition systems. To make such systems robust, multiclass neuralnetwork classifiers capable of learning from noisy data have been suggested. However on large face data sets such systems cannot provide the robustness at a high level. In this paper we explore a pairwise neural-network system as an alternative approach to improving the robustness of face recognition. In our experiments this approach is shown to outperform the multiclass neural-network system in terms of the predictive accuracy on the face images corrupted by noise.

## 1. Introduction

Performance of face recognition systems is achieved at a high level when such systems are robust to noise, corruptions and variations in face images [1]. To make face recognition systems robust, multiclass artificial neural networks(ANNs) capable of learning from noisy data have been suggested [1]. However on large face data sets such neural-network systems cannot provide the robustness at a high level [1] - [3]. To overcome this problem pairwise classification systems have been proposed, see e.g. [3], [4].

In this paper we explore a pairwise neural-network system as an alternative approach to improving the robustness. In our experiments this approach is shown to outperform the multiclass neural-network system in terms of the predictive accuracy on the face image data described in [5].

In section 2 we briefly describe face image representation and noise problems, and then in section 3 we describe a pairwise neural-network system proposed for face recognition. Section 4 describes our experiments and finally section 5 concludes the paper.

## 2. Face Image Representation And Noise Problems

Following to [1] - [3], we use the principal component analysis (PCA) to represent face images as m-dimensional vectors of components. The PCA is the common technique for data representation in face recognition systems.

The first two principal components which make the most important contribution in face recognition can be used to visualise the scatter of patterns of different classes (faces). Therefore the use of such a visualisation allows us to observe how the noise can corrupt the boundaries of classes. For example, Fig. 1 shows two graphs depicting the examples of four classes whose centres of gravity are visually distinct. The left side plot depicts the examples taken from the original data while the right side plot depicts these examples containing