1. Let t = 1, and H1 be the set H **with duplicate individuals removed**

2. While Ht **is not empty:**
(a) Let h
∗

t **= argmax**h∈Ht
(Lt−1 ∪ {h}**) after the margin-based order relation of Equation 5**
(b) Let Ht+1 = Ht\{h
∗

t } **(remove** h
∗

t**from** Ht)
(c) Let Lt = Lt−1 ∪ {h
∗

t } **(and add it to** Lt)
(d) t = t + 1

3. Return L
∗
, the classifier ensemble in {L0 . . . Lt−1} that achieves the lowest error rate on E**, selecting the smallest**
ensemble in case of ties.
Formally, let L **denote the current ensemble, initialized to**
the classifier h
∗ with minimum error rate in H**. For each**
example (xi, yi), let its margin mi **be defined as follows.**
Let y
′

i be the class most frequently associated to xi **by the**
classifiers in L**, such that** y
′

i**is different from the true class**
yi. Let ci **(respectively** c
′

i**) denote the number of classifiers**
in L associating class yi **(resp.** y
′

i) to xi**. Then margin** mi
is defined as ci − c
′

i**. A positive margin thus denotes the**
fact that the example is correctly classified by the majority
vote; the higher the margin, the more confident the ensemble
prediction. Conversely, a negative margin denotes an error;
the ensemble misclassifies the example as belonging to class y
′

i**; the more negative the margin, the more classifiers need**
to be added to the ensemble in order to correctly classify xi.
Let K **denote the number of classes of the problem and**
|A| the size of a set A**. The above definitions then read:**
$$y^{\prime}_{i}=\operatorname*{argmax}_{\begin{subarray}{c}k=1\ldots K\\ k\neq y_{i}\end{subarray}}|\{h_{j}(\mathbf{x}_{i})=k,\ h_{j}\in\mathcal{L}\}|\,,\tag{3}$$ $$m_{i}=|\{h_{j}(\mathbf{x}_{i})=y_{i},\ h_{j}\in\mathcal{L}\}|-$$ $$|\{h_{j}(\mathbf{x}_{i})=y^{\prime}_{i},\ h_{j}\in\mathcal{L}\}|.\tag{4}$$
Initially, the quality of ensemble L **was measured after its**
minimum margin when (xi, yi**) ranges over the training set,**
and the selection process aimed at maximizing the minimum margin likewise Boosting [22]. However, it turned out experimentally that the minimum margin alone is too coarse a criterion, leading to many ties. Thus, a finer grained criterion, based on the margin histogram, has finally been defined.

Let c(L, m**) denote the number of training examples with**
margin m after L**. An order relation on classifier ensembles**
L and L
′
can then be defined by comparing c(L, m**) and**
c(L
′
, m) for increasing values of m**; the best ensemble is**
the one with lesser number of examples with the smallest margin.

$${\cal L}<{\cal L}^{\prime}\ {\rm iff}\ \exists\ m_{0}\ {\rm s.t.}\ \left\{\begin{array}{l}\forall m<m_{0},\ c({\cal L},m)=c({\cal L}^{\prime},m)\\ c({\cal L},m_{0})>c({\cal L}^{\prime},m_{0})\end{array}\right.\tag{5}$$

The pseudo-code of the ensemble selection algorithm is displayed in Figure 1. It starts with a classifier pool H**, a set**
of training examples E and an initial set of classifiers L0**. It**
then iteratively moves all classifiers from H into L**, based on**
the above order on ensembles. Ultimately, the ensemble with lowest error rate on E in the ensemble sequence L0 **. . .** Lt−1 is selected.

## 3.3 Offline Evolutionary Ensemble Learning

Off**-EEL is a two-step process. It firstly runs a standard**
evolutionary learning algorithm. The approach does not make any requirement on the genetic search space, that is the classifier space; the designer can run Off**-EEL on the top**
of her favorite evolutionary learning algorithm, searching for linear classifiers, neural nets, rule systems, or genetic programs. The only required modification concerns the fitness function, which is set to the diversity-enhancing fitness described in Section 3.1, taking the whole current population as set of reference classifiers. In contrast with Boosting, the process does not maintain any memory about the examples; their weights are recomputed from scratch at each generation. While Boosting might result in exponentially increasing the weight of hard or possibly noisy examples, Off**-EEL**
thus keeps the weight of each training example bounded, and thereby avoids the instability due to the data noise.

The second step achieves the ensemble selection based on the margin-based criterion (Section 3.2 and Figure 1). It uses the final population as pool of classifiers H**, and initializes the classifier ensemble to the classifier** h
∗
**that has**
the smallest error rate on the training set in the population
(L0 = {h
∗

}).

## 3.4 Online Evolutionary Ensemble Learning

In contrast with Off-EEL, On**-EEL interleaves evolutionary learning and ensemble selection; at each generation the**
classifier ensemble is updated using the current population.

At generation 1, the classifier ensemble is initialized to the classifier that minimizes the error rate on the training set.

In further generations, the current population is evolved using the diversity-enhancing fitness function with the current ensemble as reference set (Section 3.1), and the ensemble selection algorithm (Figure 1) is launched, using the current population as classifier pool H, and the current classifier ensemble as L0. The pseudo-code of On**-EEL is given in Figure**
2.

Notably, Off-EEL and On-EEL achieve different Exploration vs Exploitation trade-offs. In Off**-EEL, the set of reference classifiers is the current population; the fitness function thus favors both accurate and diverse classifiers in each**
generation. The ensemble selection algorithm is launched only once, on a high quality and diversified pool of classifiers.

In On-EEL, the set of reference classifiers is the current