
| Table 1: UCI datasets used for the experimentations.   |      |          |         |                                                                                                                                         |
|--------------------------------------------------------|------|----------|---------|-----------------------------------------------------------------------------------------------------------------------------------------|
| #                                                      | #    |          |         |                                                                                                                                         |
| Dataset                                                | Size | features | classes | Application domain                                                                                                                      |
| bcw                                                    | 683  | 9        | 2       | Wisconsin's breast cancer, 65 % benign and 35 % malignant.                                                                              |
| bld                                                    | 345  | 6        | 2       | BUPA liver disorders, 58 % with disorders and 42 % without disorder.                                                                    |
| bos                                                    | 508  | 13       | 3       | Boston housing, 34 % with median value v < 18.77 K$, 33 % with v ∈]18.77, 23.74], and 33 % with v > 23.74.                              |
| cmc                                                    | 1473 | 9        | 3       | Contraceptive method choice, 43 % not using contraception, 35 % using short-term contraception, and 23 % using long-term contraception. |
| pid                                                    | 768  | 8        | 2       | Pima indians diabetes, 65 % tested negative and 35 % tested positive for diabetes.                                                      |
| spa                                                    | 4601 | 57       | 2       | Junk e-mail classification, 61 % tested non-junk and 39 % tested junk.                                                                  |

![0_image_0.png](0_image_0.png)

| 1. Initialize w = 0 and b = 0 2. For t = 1 . . . T : (a) Shuffle the dataset E = {(xi, yi), i = 1 . . . n} (b) For i = 1 . . . n: ai = < w, xi > − b ∆i = 2η(t)(ai − yi) w = w + ∆ixi b = b − ∆i q 1 (c) Errt = P i=1...n (ai − yi) 2 (RMS error) n (d) If |Errt − Errt−1| < ǫ, stop   |
|----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|

classify data according to a threshold value on one of the features of the data set. If the feature value of a given data is less (or greater) than the threshold, the data is assigned to a given class, otherwise it is assigned to another class. Decision stumps are trained deterministically, by looping over all features and all features threshold for a given training dataset, selecting the feature, threshold, and comparison operation on the threshold (> or <**) that maximize the classification accuracy on the training data set. Decision stumps**
are the simplest possible linear classifiers, but generate good results in combination with AdaBoost.

The elementary evolutionary algorithm is a real-valued generational GA using SBX crossover, Gaussian mutations, and tournament selection. The search space is IRd+1 for binary classification problems, and IR2d+2 for ternary classification problem, where d **is the number of attributes in the**
problem domain. The evolutionary parameters are detailed in Table 2. All experiments with the real-valued GA rely on the C++ framework Open BEAGLE [9, 10].

## 5. Results

This section reports on the experimental results obtained by Off-EEL and On**-EEL, compared to the three baseline** methods respectively noted LMS (optimal linear classifier),
GA (genetically evolved linear classifier) and Boosting (ensemble of decision stumps), on the six UCI data sets described in Table 1. For each method and problem, the average test error (over 100 independent runs as described in Section 4) and the associated standard deviation are displayed in Table 3. The average computational effort of Off**-EEL for**
a run ranges from 30 seconds (on problem bld**) to 20 minutes (on problem** spa**), on AMD Athlon 1800+ computers** with 1G of memory. For On**-EEL, the average computational effort for a run ranges from 2 hours (on problem** pid)
to 24 hours (on problem spa**), on the same computers.**
With respect to the baseline algorithms, a first remark is that the LMS-based classifier is significantly outperformed by all other methods, on all problems but one (pid**). This is**
explained as the criterion given by Equation 6 uselessly overconstrains the learning problem, replacing a set of linear inequalities with the minimization of the sum of quadratic terms. Similarly, the single-hypothesis evolutionary learning is dominated by all other methods on all problems but one
(bcw**). Boosting shows its acknowledged efficiency as it is** the best algorithm on two out of six problems (Off**-EEL and** Boosting are both best performers for the cmc **problem).**
Off**-EEL is the best method for three out of six problems**
tested. Compared to AdaBoost, it generates ensemble with lower test error rate on four problems, with a tie for the cmc problem, and AdaBoost being the best on spa **problem. In**
all cases, the number of classifiers is lower, with an average between 235 and 335 classifiers for Off**-EEL compared**
with more than 750 on all problems but bcw **for Boosting.**
This is understandable given that the ensembles are built with Off**-EEL starting from a population of 500 individuals. This raises the question on whether the evolutionary**
learning accuracy could be improved by considering larger population sizes. But it should not be forgotten that the decision stumps classifier making the AdaBoost ensembles are significantly simpler than the evolved linear discriminants of Off**-EEL. No clear conclusion can thus be made on the**
relative complexity of the ensembles generated by Off-EEL

| Table 2: Parameters for the real-valued GA.   |                            |
|-----------------------------------------------|----------------------------|
| Parameter                                     | Value                      |
| Population size                               | 500                        |
| Termination criteria                          | 100000 fitness evaluations |
| Tournament size                               | 2                          |
| Initialization range                          | [-1,1]                     |
| SBX crossover prob.                           | 0.3                        |
| SBX crossover n-value                         | n = 2                      |
| Gaussian mutation prob.                       | 0.1                        |
| Gaussian mutation std. dev.                   | σ = 0.05                   |
