For one cylinder the first type of fault is a zero-fault scenario. This type of fault is given the identity [0 0 0], indicating that there are no faults in any of the three substructures. The second type of fault is a one-fault-scenario, where a hole may be located in any of the three substructures. Three possible one-fault-scenarios are [1 0 0], [0 1 0], and [0 0 1] indicating one hole in substructures 1, 2 or 3, respectively. The third type of fault is a two-fault scenario, where holes are located in two of the three substructures. Three possible two-fault-scenarios are [1 1 0], [1 0 1], and [0 1 1]. The final type of fault is a three-fault-scenario, where a hole is located in all three substructures, and the identity of this fault is [1 1 1]. There are 8 different types of fault-cases considered (including [0 0 0]). Each cylinder is measured three times under different boundary conditions by changing the orientation of a rectangular sponge inserted inside the cylinder. The number of sets of measurements taken for undamaged population is 60 (20 cylinders × **3 for different** 
boundary conditions). In the 8 possible fault types, two fault types [0 0 0] and [1 1 1] has 60 number of occurrences while the rest has 24. It should be noted that the numbers of one- and two-fault cases are each 72. This is because as mentioned above, increasing the sizes of holes in the substructures and taking vibration measurements generated additional one- and two-fault cases. Fault cases used to train and test the networks are shown in Table 1. 

| Fault        | [000]   | [100]   | [010]   | [001]   | [110]   | [101]   | [011]   | [111]   |
|--------------|---------|---------|---------|---------|---------|---------|---------|---------|
| Training set | 21      | 21      | 21      | 21      | 21      | 21      | 21      | 21      |
| Test set     | 39      | 3       | 3       | 3       | 3       | 3       | 3       | 39      |

The impulse and response data are processed using the Fast Fourier Transform (FFT) to convert the time domain impulse history and response data into the frequency domain. The data in the frequency domain are used to calculate the frequency response functions (FRFs). From the FRFs, the modal properties are extracted using modal analysis [21]. 

The number of modal properties identified is 340 (17 modes×**19 measured mode-shapeco-ordinates+17 natural frequencies). The PCA are used to reduce the dimension of the** 
input data from 340×264 modal properties to 10×**264. Here 264 correspond to the** 
number of fault cases measured. 

## 8. Results And Discussion

The measured data was used for the MLP training and the MLP architecture contained 10 input units, 8 hidden units and 3 output units. The scaled conjugate gradient method was used for training the MLP network [12]. The average time it took to train the MLP networks was 12 CPU seconds on the Pentium II computer. The results obtained are shown in Table 2. In this table the actual fault cases are listed against the predicted fault cases. These results show that the MLP classify fault cases to the accuracy of 88%. In Table 1 it was shown that some fault cases are more numerous than others. In this case the measure of accuracy as a ratio of the sum of fault cases classified correctly divided 