scheme would in fact allow for repeated cards, and hence 403 options would be available). The first thing to notice is that only a single deck of cards is being used, hence no card can ever be repeated in a hand. Acting on this principle, consistent ordering of the hand means that the base dimensionality of the hand is greatly reduced, since it is now combinations of cards that are represented, instead of permutations. The number of combinations now represented is 40C3. This seemingly small change from nPr to nCr reduces the dimensionality of the representation by a factor of r!, which in this case is a factor of 6. Furthermore, the representation of cards as belonging to discrete suits is not optimal either, since the game places no particular value on any suit by its own virtue, but rather by virtue of which suit is the trump suit. For this reason, an alternate encoding scheme has been determined, rating the 
'suits' based upon the makeup of the agent's hand, rather than four arbitrary suits. The suits are encoded as belonging to one of the following groups, or new "suits": 
- Trump suit 
- Suit agent has multiple cards in (not trumps) - Suit in agent's highest singleton 
- Suit in agent's second-highest singleton 
- Suit in agent's third-highest singleton This allows for a much more efficient description of the agent's hand, greatly improving the dimensionality of the inputs, and hence the learning rate of the agents. These five options are encoded in a binary format, for stability purpose, and hence three binary inputs are required to represent the suits. To represent the card's number, ten discrete values must be represented, hence requiring four binary inputs to represent the card's value. Thus a card in an agent's hand is represented by seven binary inputs, as depicted in Fig. 4. 

![0_image_0.png](0_image_0.png)

Next must be considered the information required in order to make decisions two and three. For both of these decisions, the cards that have already been played, if any, are necessary to know in order to make an intelligent decision as to the correct next card to play. For the second decision, it is also plausible that knowledge of who has won a trick would be important. The most cards that can ever be played before a decision must be made is seven, and since the table after a card is played is used to evaluate and update the network, eight played cards are necessary to be represented. Once again, however, simply utilising the obvious encoding method is not necessarily the most efficient method. The actual values of the cards played are not necessarily important, only their values relative to the cards in the agent's hand. As such, the values can be represented as one of the 

following, with respect to the cards in the same suit in the agent's hand: 
- Higher than the card/cards in the agent's hand - Higher than the agent's second-highest card - Higher than the agent's third-highest card - Lower than any of the agent's cards 
- Member of a void suit (number is immaterial) 
Also, another suit is now relevant for representation of the played cards, namely a void suit - a suit in which the agent has no cards. Lastly, a number is necessary to handle the special case of the Ace of trumps, since its unique rules mean that strategies are possible to develop based on whether it has or has not been played. The now six suits available still only require three binary inputs to represent, and the six number groupings now reduce the value representations from four binary inputs to three binary inputs, once again reducing the dimensionality of the input system. 

With all of these inputs specified, the agent now has available all of the information required to draw its own conclusions and create its own strategies, without human-imposed assumptions affecting its "thought" patterns. 

2) *Network Architecture Design:* With the inputs now specified, the hidden and output layers need to be designed. 

For the output neurons, these need to represent the prediction P that the network is making [2]. A single hand has one of five possible outcomes, all of which need to be catered for. These possible outcomes are: 
- The agent wins all three tricks, winning 3 chips. 

- The agent wins two tricks, winning 2 chips. 

- The agent wins one trick, winning 1 chip. 

- The agent wins zero tricks, losing 3 chips. 

- The agent elects to fold, winning no tricks, but losing no chips. 

This can be seen as a set of options, namely [-3 0 1 2 3]. 

While it may seem tempting to output this as one continuous output, there are two compelling reasons for breaking these up into binary outputs. The first of these is in order to optimise stability, as elaborated upon in Section five. The second reason is that these are discrete events, and a continuous representation would cover the range of [-3 0], which does not in fact exist. The binary inputs then specified are: 

$$\begin{array}{r l}{\bullet}&{{}\mathrm{P(O=3)}}\\ {\bullet}&{{}\mathrm{P(O=2)}}\\ {\bullet}&{{}\mathrm{P(O=1)}}\\ {\bullet}&{{}\mathrm{P(O=-3)}}\end{array}$$

With a low probability of all four catering to folding, winning and losing no chips. Consequently, the agent's predicted return is: 
P = 3A + 2B + C − 3D (1) 

$$A=P(O=3)$$
$$\left(2\right)$$
where 
A = P(O = 3) (2) 