# Soft Constraint Abstraction Based On Semiring Homomorphism ∗

Sanjiang Li and Mingsheng Ying †
Department of Computer Science and Technology Tsinghua University, Beijing 100084, China

## Abstract

The semiring-based constraint satisfaction problems (semiring CSPs),
proposed by Bistarelli, Montanari and Rossi [3], is a very general framework of soft constraints. In this paper we propose an abstraction scheme for soft constraints that uses semiring homomorphism. To find optimal solutions of the concrete problem, the idea is, first working in the abstract problem and finding its optimal solutions, then using them to solve the concrete problem.

In particular, we show that a mapping preserves optimal solutions if and only if it is an order-reflecting semiring homomorphism. Moreover, for a semiring homomorphism α and a problem P over S, if t is optimal in α(P), then there is an optimal solution t¯ of P such that t¯ has the same value as t in α(P).

Keywords: Abstraction; Constraint solving; Soft constraint satisfaction; Semiring homomorphism; Order-reflecting.

## 1 Introduction

In the recent years there has been a growing interest in soft constraint satisfaction. Various extensions of the classical constraint satisfaction problems (CSPs) [10, 9] have been introduced in the literature, e.g., Fuzzy CSP [11, 5, 12], Probabilistic CSP [6], Weighted CSP [15, 7], Possibilistic CSP [13], and Valued CSP
[14]. Roughly speaking, these extensions are just like classical CSPs **except**
that each assignment of values to variables in the constraints is associated to an element taken from a semiring. Furthermore, nearly all of these **extensions,** as well as classical CSPs, can be cast by the semiring-based constraint solving framework, called SCSP (for *Semiring CSP***), proposed by Bistarelli, Montanari** and Rossi [3].

∗**Work partially supported by National Nature Science Foundation of China**
(60673105,60621062, 60496321).

†**lisanjiang@tsinghua.edu.cn (S. Li), yingmsh@tsinghua.edu.cn (M. Ying)**
arXiv:0705.0734v1 [cs.AI] 5 May 2007