Compared with classical CSPs, SCSPs are usually more difficult to process and to solve. This is mainly resulted by the complexity of the underlying **semiring structure. Thus working on a simplified version of the given problem would**
be worthwhile. Given a concrete SCSP, the idea is to get an abstract **one by** changing the semiring values of the constraints without changing the structure of the problem. Once the abstracted version of a given problem is available, one can first process the abstracted version and then bring back **the information obtained to the original problem. The main objective is to find an optimal**
solution, or a reasonable estimation of it, for the original problem.

The translation from a concrete problem to its abstracted version **is established via a mapping between the two semirings. More concretely, suppose** P is an SCSP over S, and Se is another semiring (possibly simpler than S**). Given a**
mapping α : S → Se, we can translate the concrete problem P to another problem, α(P), over Se **in a natural way. We then ask when is an optimal solution of**
the concrete problem P also optimal in the abstract problem α(P**)? and, given** an optimal solution of α(P**), when and how can we find a reasonable estimation**
for an optimal solution of P?

The answers to these questions will be helpful in deriving useful information on the abstract problem and then taking some useful information back to the concrete problem. This paper is devoted to the investigation of **the above** questions.

These questions were first studied in Bistarelli, Codognet and Rossi **[1],**
where they established a Galois insertion-based abstraction framework for soft constraint problems. In particular, they showed that [1, Theorem 27] if α is an *order-preserving* **Galois insertion, then optimal solutions of the concrete** problem are also optimal in the abstract problem. This sufficient condition, however, turns out to be equivalent to say α **is a semiring isomorphism (see** Proposition 6.1), hence too restrictive. Theorem 29 of [1] concerns computing bounds that approximate an optimal solution of the concrete problem. The statement of this theorem as given there is incorrect since a counter-example
(see Soft Problem 4 in this paper) shows that the result holds conditionally.

This paper shows that semiring homomorphism plays an important role in soft constraint abstraction. More precisely, we show that (Theorem 4.1) a mapping preserves optimal solutions if and only if it is an order-reflecting **semiring**
homomorphism, where a mapping α : S → Se is *order-reflecting* **if for any two**
a, b ∈ S, we have a <S b from α(a) <Se α(b). Moreover, for a semiring homomorphism α and a problem P over S, if t is optimal in α(P**), then there**
is an optimal solution t¯ of P such that t¯ has the same value as t in α(P**) (see**
Theorem 5.1).

This paper is organized as follows. First, in Section 2 we give a summary of the theory of soft constraints. The notion of α-*translation* **of semiring CSPs is** introduced in Section 3, where we show that α **preserves problem ordering if and** only if α **is a semiring homomorphism. Section 4 discusses when a translation**
α **preserves optimal solutions, i.e. when all optimal solutions of the concrete** problem are also optimal in the abstract problem. In Section 5, we discuss, given