# Artificial Neural Networks And Support Vector Machines For Water Demand Time Series Forecasting

Ishmael S. Msiza, Fulufhelo V. Nelwamondo and Tshilidzi Marwala Abstract - Water plays a pivotal role in many physical processes, and most importantly in sustaining human life, animal life and plant life. Water supply entities therefore have the responsibility to supply clean and safe water at the rate required by the consumer. It is therefore necessary to implement mechanisms and systems that can be employed to predict both short-term and long-term water demands. The increasingly growing field of computational intelligence techniques has been proposed as an efficient tool in the modelling of dynamic phenomena. The primary objective of this paper is to compare the efficiency of two computational intelligence techniques in water demand forecasting. The techniques under comparison are the Artificial Neural Networks (ANNs) and the Support Vector Machines (SVMs). In this study it was observed that the ANNs perform better than the SVMs. This performance is measured against the generalisation ability of the two. 

Keywords: **Water Demand Forecasting, Artificial Neural** 
Networks, Support Vector Machines, Artificial Neural Genius, Support Vector Genius, Overall Genius

## I. I**Ntroduction**

he modeling of water resource variables is a very broad field that includes modeling of water quality, water demand, water reticulation networks, to mention but a few. This paper is focused on the modeling of only one water resource variable which is water demand and the study is restricted to South Africa's Gauteng Province. The Republic of South Africa has now of late been experiencing a situation whereby the demand of water is much higher than the rate at which the water is being supplied [1]. This is attributable to a number of factors such as the average annual rainfall of 497mm which is way below the world's average of 860mm [2]. However, most of the factors that contribute towards the water demand exceeding the water supply are due to human interventions. These include population growth and the economic expansion of the South African citizens, especially in the Gauteng Province. The more affluent people become; the more water they will use [3], and the more the population grows, there will be an increased demand for water. The province of Gauteng is of particular interest because of its status as the industrial powerhouse of South Africa and it houses and provides employment to almost a quarter of the South African population, some 9 million people [4]. 

The Gauteng Province consumes about 86% of the total water supply provided by a bulk supplier called Rand Water. With the current population growth rate of 3.13% 
per annum [4], the water demand in this province is definitely set to increase. Another factor that has a major influence on the demand of water is the issue of HIV/AIDS. An increase in the HIV/AIDS related deaths can have a negative effect on the population growth rate. This therefore implies that the population growth rate will not always be positive, but can at times be negative. An approach that can be employed to offset the effects of this population dynamics is to develop two models, one with T
the effects of HIV/AIDS neglected and another one with these effects taken into account. This will result in a reliable model because the actual water demand will be inside the envelope formed by these two extremes. 

## Ii. Literature I**Nspection**

The modelling of water resource variables is a very active field of study and definitely there still is a lot of work to be done. In the initial stages, modelling of water resource variables was done using the traditional statistical models. In recent years, modern techniques have been proposed as efficient modelling tools. There is a large pool of these techniques, and hence there is always a need to investigate which technique is the most efficient for a particular application. 

Gamal El-Din *et al* **[5] used artificial neural networks to** 
model wastewater treatment processes. This was a comparative study between conventional deterministic models and artificial neural networks. They observed that, in addition to the information contained in the conventional models, neural networks contained a great deal of additional information with regard to the system being modelled. Jain *et al* **[6] used artificial neural** 
networks to model the short-term water demand at the Indian Institute of Technology (IIT) in Kanpur, India. Six neural network models, five regression models and two time series models were developed and compared. All the neural network models generally displayed better performance when measured against the other models. Maier *et al* **[7] conducted a study reviewing 43 research** 
papers that employed neural networks in the prediction and forecasting of water resources variables. They observed that neural network models always work well and their use in the study of water is on the increase due to their ability to handle large amounts of non-linear, nonparametric data. 

Khan and Coulibaly [8] conducted a comparative study between support vector machines, artificial neural networks and the traditional seasonal autoregressive model (SAR) in the forecasting of lake water levels. They observed that the support vector machine is generally compatible with the other two models, but when it comes to long-term forecasting, the support vector machine displays better performance. Mukherjee *et al* **[9]** 
conducted a study to predict chaotic time series using support vector machines. The performance of support vector machines stood out when compared to other approximation methods such as polynomial and rational approximation, local polynomial techniques and artificial neural networks. Other forecasting applications that employed support vector machines include the work of Mohandes *et al* **in the prediction of wind speed [10]. They** 
observed that the performance of the support vector machines is comparable to that of artificial neural networks. 

All of these studies confirm that there is a need to compare the performance of various approximation 