compared to a technique that combines neural networks with Genetic Algorithm (GA) to approximate the missing data. 

## 2. **Missing Data Theory**

According to Little and Rubin [1], missing data are categorized into three basic types namely: 'Missing at Random', (MAR), 'Missing Completely at Random', 
(MCAR) and 'Missing Not at Random', (MNAR). MAR is also known as the ignorable case [3]. The probability of datum d from a sensor S **to be missing at random is** 
dependent on other measured variables from other sensors. A simple example of MAR is when sensor T is only read if sensor S **reading is above a certain threshold.** 
In this case, if the value read from sensor S **is below the** threshold, there will be no need to read sensor T **and** 
hence, readings from T **will be declared missing at** 
random. MCAR on the other hand refers to a condition where the probability of S **values missing is independent** of any observed data. In this regard, the missing value is neither dependent on the previous state of the sensor nor any reading from any other sensor. Lastly, MNAR occurs when data is neither MAR nor MCAR and is also referred to as the non-ignorable case [1, 3] as the missing observation is dependent on the outcome of interest. A detailed description of missing data theory can be found in [3]. In this paper, we shall assume that data is MAR. 

## 3. **Background** 3.1 Neural Network: Multi-Layer Perceptrons

Neural networks may be viewed as systems that learn the complex input-output relationship from any given data. 

The training process of neural networks involves presenting the network with inputs and corresponding outputs and this process is termed *supervised learning*. There are various types of neural networks but we shall only discuss the MLP since they are used in this study. MLPs are feed-forward neural networks with an architecture comprising of the input layer, hidden layer and the output layer. Each layer is formed from smaller units known as neurons. Neurons receive the input signals x **and propagate them forward to the network and maps** 
the complex relationship between inputs and the output. The first step in approximating the weight parameters of the model is finding the approximate architecture of the MLP, where the architecture is characterized by the number of hidden units, the type of activation function, as well as the number of input and output variables. The second step estimates the weight parameters using the training set [7]. Training estimates the weight vector W
r that ensures that the output is as close to the target vector as possible. This paper implements the autoencoder neural network as discussed below. 

Autoencoder neural networks**: Autoencoders, also known as** auto-associative neural networks, are neural networks trained to recall the input space. Thompson *et al* **[8]** 
distinguish two primary features of an autoencoder network, namely the auto-associative nature of the network and the presence of a bottleneck that occurs in the hidden layers of the network, resulting into a butterfly-like structure. In cases where it is necessary to recall the input, autoencoders are preferred due to their remarkable ability to learn certain linear and non-linear interrelationships such as correlation and covariance inherent in the input space. Autoencoders project the input onto some smaller set by *intensively squashing* it into smaller details. The optimal number of the hidden nodes of the autoencoder, though dependent on the type of application, must be smaller than that of the input layer [8]. Autoencoders have been used in various applications including the treatment of missing data problem by a number of researchers including [4] and [9]. 

In this paper, auto-encoders are constructed using the 

![0_image_0.png](0_image_0.png) MLP networks and trained using back-propagation. The structure of an autoencoder constructed using an MLP network is shown in Figure 1. The first step in approximating the weight parameters of the model is finding the approximate architecture of the MLP, where the architecture is characterized by the number of hidden units, the type of activation function, as well as the number of input and output variables. The second step estimates the weight parameters using the training set [7]. 

Training estimates the weight vector W
r to ensure that the output is as close to the target vector as possible. The problem of identifying the weights in the hidden layers is solved by maximizing the probability of the weight parameter using Bayes' rule [8] as follows: 

$$P({\vec{W}}\,|D)\;\;\;\mathrm{is}\;\;\;\mathrm{th}$$
r r
$$p(\vec{W}\,|\,D)=\frac{P(D\,|\,\vec{W})P(\vec{W})}{P(D)}\qquad\qquad\qquad(1)$$

Where: 
D is the training data, P(W
r |D) **is the posterior** 
probability, *P(D|*W
r
) **is called the likelihood term that** 
balances between fitting the data well and helps in