
## 6.1 Application To Classification

Data set: **The experiment was performed using the** 
Dissolved Gas Analysis (DGA) data obtained from a transformer bushing operating on-site. The data consist of 10 features, which are the gases that dissolved in the oil. The hypothesis in this experiment is to determine if the bushing condition (faulty or healthy) can be determined while some of the data are missing. The data was divided into the training set and the validation, each containing 2000 instances. 

Experimental setup: **The classification test was** implemented using an ensemble of Fuzzy-ARTMAP 
networks. Two inputs were considered more likely to be missing and as a result, 8 were considered most likely to be available. The online process was simulated where data is sampled one instance at a time for testing. The network parameters were empirical determined and the vigilance parameter of 0.75 was used for the FuzzyARTMAP. The results obtained were compared to those obtained using the the NN-GA approach, where for the GA, the crossover rate of 0.1 was used over 25 generations, each with a population size of 20. All these parameters were empirically determined. Results: **Using equation (6), a total of 45 networks was** 

![0_image_0.png](0_image_0.png)

found to be the maximum possible. The performance was calculated only after 4000 cases have been evaluated and is shown in Figure 5. The classification increases with an increase in the number of classifiers used. Although all these classifiers were not trained with all the inputs, their combination seems to work better than one network. The classification accuracy obtained under missing data goes as high as 98.2% which compares very closely to a 100 % 
which is obtainable when no data is missing. 

Using the NN-GA approach, a classification of 96% was obtained. Results are tabulated in Table 1 below. 

Table 1: Comparison between the proposed method and the NN-GA approach 

|                   | Proposed   | NN-GA   |      |      |
|-------------------|------------|---------|------|------|
| Algorithm         |            |         |      |      |
| Number of missing | 1          | 2       | 1    | 2    |
| Accuracy (%)      | 98.2       | 97.2    | 99   | 89.1 |
| Run time (s)      | 0.86       | 0.77    | 0.67 | 1.33 |

The results presented in Table 1 clearly show that the proposed algorithms can be used as a means of solving the missing data problem. The proposed algorithm compares very well to the well know NN-GA approach.

The run time for testing the performance of the method varies considerably. It can be noted from the table that for the NN-GA method, run time increase with increasing number of missing variables per instance. Contrary to the NN-GA, our proposed method offers run times that decrease with increasing number of inputs. The reason for this is that the number of Fuzzy-ARTMAP networks available reduces with an increasing number of inputs as mentioned earlier. However, this improvement in speed comes at a cost of the diversity. We tend to have less diversity as the number of training inputs increase. Furthermore, this method will completely come to a failure in a case where more than navl **inputs will be** 
missing at the same time. 

## 6.1 Application To Regression

In this section, we extend the algorithm implemented in the above section to a regression problem. Instead of using an ensemble of Fuzzy ARTMAP networks as in classification, MLP networks are used. The reasons for this practice are two fold; firstly because MPL's are excellent regressors and secondly, to show that the proposed algorithm can be used with any architecture of neural networks. 

Database: **The data from a model of a Steam Generator** 
at Abbott Power Plant [17] was used for this task. This data has four inputs, which are the *fuel, air, reference* level and the *disturbance* **which is defined by the load** 
level. There are two outputs which we shall try to predict using the proposed approach in the presence of missing data. These outputs are *drum pressure* and the *steam flow*. 

Experimental setup: **Although Fuzzy-ARTMAP could** not be used for regression, we extended the same approach proposed above using MLP neural networks for regression problem. As before, this work regresses in order to obtain two outputs which are the *drum pressure* and the *steam flow*. We assume navl **= 2 is the case and as** 
a result, only two inputs can be used. We create an ensemble of MLP networks, each with five hidden nodes and trained only using two of the inputs to obtain the output. Due to limited features in the data set, this work 