shall only consider a maximum of one sensor failure per instance. Each network was trained with 1200 training cycles using the scaled conjugate gradient algorithm and a hyperbolic tangent activation function. All these training parameters were again empirically determined. 

Results: **Since testing is done online where one input** arrives at a time, evaluation of performance at each instance would not give a general view of how the algorithm works. The work therefore evaluates the general performance using the following formula only after N **instances have been predicted.** 

$$E r r o r=\frac{n_{\tau}}{N}\times100\%$$
Error τ **(9)**
where nτ is the number of predictions within a certain tolerance. In this paper, a tolerance of 20% is used and was arbitrarily chosen. Results are summarized in Table 2 Table 2: Regression accuracy obtained without estimating the missing values. 

|                   | Proposed   | NN-GA   |          |      |
|-------------------|------------|---------|----------|------|
| Algorithm         |            |         |          |      |
| Number of missing | 1          | 2       | 1        | 2    |
|                   | Perf (%)   | Time    | Perf (%) | Time |
| Drum Pressure     | 98.2       | 97.2    | 68       | 126  |
| Steam Flow        | 86         | 0.77    | 84       | 98   |

'Perf' indicates the accuracy in percentage whereas time indicates the running time in seconds. Results show that the proposed method is well suited for the problem under investigation. The proposed method performs better than the combination of GA and autoencoder neural networks in the regression problem under investigation. The reason is that the errors that are made when inputting the missing data in the NN-GA approach are further propagated to the output-prediction stage. The ensemble based approach proposed here does not suffer from this problem as there is no attempt to approximate the missing variables. It can also be observed that the ensemble based approach takes less time that the NN-GA method. The reason for this is that GA may take longer times to converge to reliable estimates of the missing values depending on the objective function to be optimised. Although, the prediction times are negligibly small, an ensemble based technique takes more time to train since training involves a lot of networks. 

## 7. **Conclusion**

In this paper a new techniques for dealing with missing data for online condition monitoring problem was presented and studied. Firstly the problem of classifying in the presence of missing data was addressed, where no attempts are made to recover the missing values. The problem domain was then extended to regression. The proposed technique performs better than the NN-GA approach, both in accuracy and time efficiency during testing. The advantage of the proposed technique is that it eliminates the need for finding the best estimate of the data, and hence, saves time. Future work will explore the incremental learning ability of the Fuzzy ARTMAP in the proposed algorithm. 

## Acknowledgements

The financial assistance of the National Research Foundation (NRF) of South Africa and the Carl and Emily Fuchs Foundation is hereby acknowledged. 

## 8. **References**

$\eqref{eq:walpha}$. 
[1] R. J. A. Little and D. B. Rubin, **Statistical analysis with missing** 
data**. New York: John Wiley, 1987.** 
[2] J. Kim and J. Curry, "The treatment of missing data in multivariate analysis," *Sociological Methods and Research***, vol. 6,** 
pp. 215–241, 1977. 

[3] J. Schafer and J. Graham, "Missing data: Our view of the state of the art," *Psychological Methods***, vol. 7, pp. 147– 177, 2002.** 
[4] M. Abdella and T. Marwala, "The use of genetic algorithms and neural networks to approximate missing data in database," Computing and Informatics**, pp. 1001–1013, 2006.** 
[5] S. M. Dhlamini, F. V. Nelwamondo, and T. Marwala, "Condition monitoring of hv bushings in the presence of missing data using evolutionary computing," **WSEAS Transactions on Power** 
Systems**, vol. 1, pp. 296–302, 2006.** 
[6] B. Gabrys, "Neuro-fuzzy approach to processing inputs with missing values in pattern recognition problems," **International** 
Journal of Approximate Reasoning**, vol. 30, pp. 149–179, 2002.** 
[7] N. Japkowicz, "Supervised learning with unsupervised output separation," **In International Conference on Artificial Intelligence** 
and Soft Computing**, pp. 321–325, 2002.** 
[8] B. B. Thompson, R. Marks, and M. A. El-Sharkawi, "On the contractive nature of autoencoders: Application to sensor restoration," **Proceedings of the IEEE International Joint** Conference on Neural Networks**, pp. 3011– 3016, 2003.** 
[9] A. Frolov, A. Kartashov, A. Goltsev, and R. Folk, "Quality and efficiency of retrieval for willshaw-like autoassociative networks," 
Computation in Neural Systems**, vol. 6, 1995.** 
[10] C. M. Bishop, *Neural Networks for Pattern Recognition***. New** 
York: Oxford University Press, 2003. 

[11] D. Goldberg, *Genetic Algorithms in Search, Optimization and* Machine Learning**. Reading, MA: Addison-Wesley, 1989.** 
[12] G. Carpenter, S. Grossberg, N. Markuzon, J. Reynolds, and D. 

Rosen, "Fuzzy ARTMAP: A neural network architecture for incremental supervised learning of multidimensional maps," **IEEE** 
Transactions on Neural Networks**, vol. 3, pp. 698–713, 1992.** 
[13] R. Javadpour and G. Knapp, "A fuzzy neural network approach to condition monitoring," *Sociological Methods and Research***, vol.** 
45, pp. 323–330, 2003. 

[14] Y. Freund and R. Schapire, "A decision theoretic generalization of online learning and an application to boosting," in *Proceedings of* the Second European Conference on Computational Learning Theory**, pp. 23–37, 1995.** 
[15] L. I. Kuncheva, **Combining Pattern Classifies, Methods and** 
Algorithms**. New York: Willey Interscience, 2005.** 
[16] E. McGookin and D. Murray-Smith, "Using correspondence analysis to combine classifiers," *Machine Learning***, vol. 14, pp.** 
1–26, 1997. 

[17] B. De Moor, "Database for the identification of systems, department of electrical engineering, esat/sista." Internet Listing, Last Acessed: 2 April 2006 1998. URL: 
http://http://www.esat.kuleuven.ac.be/sista/daisy. 