
## 6.5 Generalization

Several other experiments were performed in order to test the generalization abilities of the resulting controllers. The 10 × **4 best controllers obtained in the** experiments above were tested in new experimental environments.

First, some obstacles were added in the environment (the arena was free of obstacle in the experiments described above). But no controller was able to go to the recharge area whenever an obstacle was in the way. However, when the evolution was performed with the obstacles, the overall results are about the same (with slightly worse overall performance, as predicted).

More interesting are the results obtained when the robots are put **in an arena**
that is three times larger than the one used during evolution. The best generalization results are obtained by the Classical Controller architecture, with only a slight decrease of fitness(a few percents). Moreover, 100 additional generations of evolution in the new environment gives back the same level of fitness.

The Symbolic Controllers come next (in terms of generalization capability!):
they initially lose around 10% of their fitness, then reach the same level again in 150 generations, and even overpass that level (see the discussion in section 6.3).

Surprisingly, both supervisor architectures fail to reach the same level of performance in the new environment even after a new cycle of evolution. The Symbolic Supervisor lose about 12.5% of their fitness, and only recover half of it, while the Classical Supervisors lose more than 20% and never recover.

These results can be at least partly explained by the behaviors that are obtained by the first experiments: whereas all direct controller architectures mainly stay around the recharge area, and thus are not heavily disturbed by the change of size of the arena, the Supervisor architectures use their exploration behavior and fail to turn back on time. The only surprising result is that they also fail to reach the same level of fitness even after some more generations 6.

This difference in the resulting behaviors also explains the results obtained in the last generalization experiment that will be presented here: the recharge of energy was made 2 times slower (or the energy consumption was made twice faster - both experiments give exactly the same results). Here, the results of the Symbolic Supervisors are clearly much better than those of the other architectures: in all cases, the robot simply stays in the recharge area **until the energy**
level is back to maximum**, using the** stop **behavior.**
Surprisingly, most Classical Supervisors, though they also can use **their** STOP
behavior, fail to actually reach the recharge area. On the other hand, both direct controller architecture never stop on the recharge area. However, while the Symbolic Controllers manage to survive more than one epoch for half of the trials, all Classical Controllers fail to do so.

This last generalization experiment shows a clear advantage to the Symbolic Controller architecture: if is the only one that actually learned to recharge the accumulator to its maximum before leaving the recharge area. But the ultimate 6 **However, when restarting the evolution from scratch in the large arena, the SSs**
easily reach the 6400 fitness level, outperforming again all other architectures