test for controllers evolved using a simulator is of course to be applied on the real robot. This is on-going work, and the first experiments, applied to the obstacle avoidance behaviors, have confirmed the good performance of **the symbolic**
controllers in any environment.

## 7 Discussion And Perspectives

The main contribution of this work is to propose some compromise between the pure black box approach where evolution is supposed to evolve everything from scratch, and the "transparent box" approach, where the **programmer must** decompose the task manually.

The proposed approach is based on a toolbox, or library, of behaviors ranging from elementary hand-coded behaviors to evolved behaviors of low **to medium** complexity. The combination and proper use of those tools is left to evolution. The new space of controllers that is explored is more powerful that **the one** that is classically explored in Evolutionary Robotics. For instance, it was able to easily find some loophole in the (very simple) obstacle behavior fitness; moreover, it actually discovered the right way to recharge its accumulator in the more complex homing experiment.

Adding new basic behaviors to that library allows one to gradually increase the complexity of the available controllers without having to cleverly insert those new possibilities in the available controllers: evolution will take care of that, and the sensitivity analysis demonstrated that useless behaviors will be **filtered out** at almost no cost (section 6.4). For instance, there might be some cases where a random behavior can be beneficial - and it didn't harm the energy experiment. More generally, this idea of a library allows one to store experience from past experiments: any controller (evolved or hand-coded) can be added to the toolbox, and eventually used later on - knowing that useless tools will simply not **be used.**
Finally, using such a library increases the intelligibility of the resulting controllers, and should impact the way we evolutionary design controllers, i.e. fitness functions. One can add some constraints on the distribution over the use of the different available controllers, (e.g. use the light following action ε**% of the time);**
by contrast, traditional evolutionary approach had to set up sophisticated ad hoc experimental protocol to reach the same result (as in [16]). Further work will have to investigate in that direction.

But first, more experiments are needed to validate the proposed approach
(e.g. experiments requiring some sort of memory, as in [18, 16]). The **impact of** redundancy will also be investigated: in many Machine Learning tasks, adding redundancy improves the quality and/or the robustness of the result. Several controllers that have been evolved for the same task, but exhibit different behaviors, can be put in the toolbox. It can also be useful to allow the overall controller to use all levels of behaviors simultaneously instead of the **layered** architecture proposed so far. This should allow to discover on the fly specific behaviors whenever the designer fails to include them in the library.