mechanism **should be used all along the complexity path, leading from primitive**
tasks to simple tasks, and from simple tasks to more complex behaviors.

One reason for the lack of intelligibility is that the language of the controllers consists in low-level orders to the robot actuators (e.g. speeds of the right and left motors). Using instead hand-coded basic behaviors (e.g. forward, turn left or turn right) as proposed in section 3 should allow one to better understand the relationship between the controller outputs and the resulting behavior. Moreover, the same approach will allow to recursively build higher level behaviors **from**
those evolved simple behaviors, thus solving more and more complex problems.

Reported experiments tackle both aspects of the above approach. After describing the experimental setup in section 4, simple behaviors are evolved based on basic primitives (section 5). Then a more complex task is solved using the results of the first step (section 6). Those results are validated by comparison to the pure black-box evolution, and important issues like the sensitivity w.r.t. the available behaviors, and the robustness w.r.t generalization are discussed. The paper ends by revisiting the discussion in the light of those results.

## 2 State Of The Art

The trends in autonomous robotics can be discussed in the light of the "innate vs acquired" cognitive aspects - though at the time scale of evolution. From that point of view, Brooks'subsumption architecture is extreme on the "innate" side: The robots are given all necessary skills by their designer, from basic behaviors to the way to combine them. Complex behaviors so build on some "instinctive" predefined simple behaviors. Possible choices lie in a very constrained **space,** guaranteeing good performances for very specific tasks, but that does not scale up very well: Brooks'initial goal was to reach the intelligence of insects [3].

Along similar lines are several computational models of action-selection (e.g.

Spreading Activation Networks [10], reinforcement learning [8, 7], . . **. ). Such approaches have two main weaknesses. The first one is that such architecture is**
biologically questionable - but do we really care here? The second weakness is concerned with the autonomy issue. Indeed, replacing low level reflexes by decisions about high level behaviors (use this or that behavior now) **might be**
beneficial. However, how to program the interactions **of such reflexes in an open** world amounts to solve the exploration vs exploitation **dilemma - and both Game**
Theory and Evolutionary Computation have underlined the difficulty of answering this question.

At the other extreme of the innate/acquired spectrum is the evolutionary robotics credo: any a priori bias from the designer can be harmful. **Such position is also defended by Bentley [1] in the domain of optimal design, where**
it has been reinforced by some very unexpected excellent solutions **that arose** from evolutionary design processes. In the Evolutionary Robotics **area, this idea** has been sustained by the recent revisit by Tuci, Harvey and Quinn [16] of an experiment initially proposed by Yamauchi and Beer [18]: depending on **some** random variable, the robot should behave differently (i.e. go toward the light,