continuous parameter (e.g. speed of forward displacement, or turning angle for left and right actions).

The proposed symbolic controller has eight outputs with values in [0, **1]: the**
first four outputs are used to specify which action will be executed, namely action i, with i = Argmax(output(j), j = 1..4). Output i **+ 4 then gives the associated**
parameter. From the given action and the associated parameter, **the values of the**
commands for the actuators are computed by some simple hard-coded program.

## 3.2 Discussion

Using some high level representation language for the controller impacts on both the size of the search space, and the possible modularity of the controller.

At first sight, it seems that the size of the search space is increased, as a symbolic controller has more outputs than a classical controller. However, at the end of the day, the high level actions are folded into the two motor commands. On the other hand, using a symbolic controller can be viewed as adding some constraints on the search space, hence reducing the **size of the part** of the search space actually explored. The argument here is similar to the one used in statistical learning [17], where rewriting the learning problem into a very high dimensional space actually makes it simpler. Moreover, the fitness landscape of the space that is searched by a symbolic controller has many neutral plateaus, as only the highest value of the first outputs is used - and neutrality **can be**
beneficial to escape local optima [6].

On the other hand, the high level primitives of symbolic controllers make room for modularity. And according to Dawkins [4], the probability to build a working complex system by a randomized process increases with the **degree of** modularity.It should be noted that this principle is already used in Evolutionary Robotics, for instance to control the robot gripper : the outputs of the controllers used in [13] are high-level actions (e.g. GRAB, RAISE GRIPPER, . . .**), and not**
the commands of the gripper motors.

Finally, there are some similarities between the symbolic controller approach and reinforcement learning. Standard reinforcement learning [15, **8] aims at finding an optimal policy. This requires an intensive exploration of the search space.**
In contrast, evolutionary approaches sacrifices optimality toward satisfactory timely satisfying solutions. More recent developments [11], closer to **our approach, handle continuous state/action spaces, but rely on the specification of**
some relevant initial policy involving manually designed "reflexes".

## 4 Experimental Setup

Initial experiments have been performed using the Khepera simulator EOBot, that was developed by the first author from the EvoRobot **software provided by** S. Nolfi and D. Floreano [13]. EvoRobot **was ported on Linux platform using** OpenGL graphical library, and interfaced with the EO **library [9]. It is hence now** possible to use all features of EO in the context of Evolutionary Robotics, e.g.