# Robust Multi-Cellular Developmental Design

to appear in D. Thierens et al., Eds., Proceedings of GECCO'07, ACM Press, July 2007

Alexandre Devert

![0_image_0.png](0_image_0.png)

Nicolas Bredeche

![0_image_1.png](0_image_1.png)

Marc Schoenauer

![0_image_2.png](0_image_2.png)

## Abstract

This paper introduces a continuous model for Multi-cellular Developmental Design. The cells are fixed on a 2D grid and exchange "chemicals" with their neighbors during the growth process. The quantity of chemicals that a cell produces, as well as the differentiation value of the cell in the phenotype, are controlled by a Neural Network (the genotype) that takes as inputs the chemicals produced by the neighboring cells at the previous time step. In the proposed model, the number of iterations of the growth process is not pre-determined, but emerges during evolution: only organisms for which the growth process stabilizes give a phenotype (the stable state), others are declared nonviable. The optimization of the controller is done using the NEAT algorithm, that optimizes both the topology and the weights of the Neural Networks. Though each cell only receives local information from its neighbors, the experimental results of the proposed approach on the 'flags' problems (the phenotype must match a given 2D pattern) are almost as good as those of a direct regression approach using the same model with global information. Moreover, the resulting multi-cellular organisms exhibit almost perfect self-healing characteristics.

## 1. Introduction

Evolutionary Design uses Evolutionary Algorithms to design various structures (e.g. solid objects, mechanical structures, robots, . . . ). It has been known for long [11] that the choice of a representation, i.e. of the space to search in, is crucial for the success of any Evolutionary Algorithm. But this issue is even more critical in Evolutionary Design. On the one hand, the success of a design procedure is not only measured by the optimality, for some physical criteria, of the proposed solutions, but also by the creative side of the process: a rich (i.e. large) search space is hence mandatory. But on the other hand, because scalability, and thus re-usability and modularity, are important characteristics of good design methodologies, the search space should have some structure allowing those properties to emerge.

Permission to make digital or hard copies of all or part of this work for personal or classroom use is granted without fee provided that copies are not made or distributed for profit or commercial advantage and that copies bear this notice and the full citation on the first page. To copy otherwise, to republish, to post on servers or to redistribute to lists, requires prior specific permission and/or a fee. GECCO 2007 London, England Copyright 200X ACM X-XXXXX-XX-X/XX/XX ...$5.00.

The importance of the type of embryogeny (the mapping from genotype to phenotype) of the chosen representation in Evolutionary Design has been highlighted for instance in
[3], and more systematically surveyed in [18]. Direct representations, with no embryogeny (the relation between the phenotype and the genotype is a one-to-one mapping), have been very rapidly replaced in the history of Evolutionary Design by indirect representations, where the embryogeny is an explicit program, generally based on a grammar - and evolution acts on this program. The phenotype is then the result of the execution of the genotype. Many works have used this type of representation in Evolutionary Design, from the seminal works of Gruau [8] and Sims [16] and their many successfull followers (cited e.g. in [18]). However, even though those representations did to some extent address the issues of modularity, re-usability and scalability, there was still room for improvement. First, the scalability is still an issue, possibly because the bigger the structure, the more difficult it is to fine-tune it through the variation operators, due to the uncontrolled causality **(the effect of small mutations is not always small). Second, the embryogeny itself,**
and hence the resulting structures, are not robust to perturbations [2], an important characteristic when it comes to design autonomous systems such as robots.

In order to address those issues, several recent works have chosen to use multicellular developmental models: the embryogeny is implicit, based on exchanges of some 'chemicals' between 'cells', and more or less faithfully connected to Turing's early 'reaction-diffusion' model [19] (see again [18], and the more recent works cited in Section 4). But several instances of this model have been proposed, and a number of issues remain open, if not unsolved: Is the number of cells fixed, and the structure is then the result of their differentiation, or is the whole organism growing from a single cell? Do the chemicals diffuse on a given 'substrate' or only through the interactions and exchanges among neighboring cells –
and is the topology of cell interactions fixed, evolved, or has it emerged during the development process? What is the granularity of the possible values of chemical concentrations or quantities? When and how does development stop (the
'halting problem' of developmental approaches)? Finally, maybe the most important issue when it comes to evolve such embryogenies: what kind of 'reaction' takes place in each cell - or, from an operational point of view, what type of controller is used within each cell, and subject to evolution?

All those questions are of course interwined (e.g. you don't use the same type of controller depending on the type