of values you intend to evolve). However, and whatever the choices when answering the above questions, most works evolving multi-cellular developmental models report convincing results as far as scalability is concerned [7, 5], as well as unexpected robustness properties [14, 2, 6]. Indeed, even though the self-repairing capacities of the biological systems that inspired those models were one motivation for choosing the developmental approach, self-healing properties were not explicitly included on the fitnesses, and initially appeared as a side-effect rather than a target feature (see Section 4 for a more detailed discussion).

This paper proposes yet another model for Multicellular Developmental Evolutionary Design. A fixed number of cells placed on a two-dimensional grid is controlled by a Neural Network. Cells only communicate with their 4 neighbors, and exchange (real-valued) quantities of chemicals. In contrast with previous works (but this will be discussed in more detail in Section 4), the phenotypic function of a cell (its type) is one of the outputs of the controller, i.e. is evolved together with the 'chemical reactions'. Moreover, the halting problem is implicitly left open and solved by evolution itself: development continues until the dynamical system
(the set of cells) comes to a fixed point (or after a –large–
fixed number of iterations). We believe that this is the reason for the excellent self-healing properties of the organisms that have been evolved using the proposed model: they all recover almost perfectly from very strong perturbations - a feature that is worth the additional computational cost in the early generations of evolution.

The paper is organized as follows: Section 2 introduces the details of the proposed model and of its optimization using the NEAT general-purpose Neural Network evolution algorithm [17], that optimizes both the topology and the weights of the network. The approach is then tested in Section 3 on the well-known 'flag' benchmark problems, where the target "structure" is a 2D image. A meaningful validation is obtained by comparing the results of the developmental approach to those of the data-fitting approach: the same neural optimization method is used but the inputs are the coordinates (x,y) of the cell: indeed, it should not be expected to obtain better results with the developmental approach than with this direct data-fitting approach. Furthermore, the excellent self-healing properties of the resulting structures are demonstrated. Those results are discussed in Section 4 and the proposed approach is compared to other existing approaches for Multicellular Developmental Design. Finally, further directions of research are sketched in concluding Section 5.

## 2. Developmental Model

The context of the proposed approach is what is now called Multi-Cellular Development Artificial Embryogeny [15]:
An organism is composed of identical cells; Each cell encapsulates a controller **(loosely inspired from a biological**
cell's regulatory network); All cells, and thus the organism, are placed in a substrata **with a given topology; Cells may**
eventually divide (i.e. create new cells), differentiate (i.e.

assume a predefined function in the phenotype), migrate and/or communicate with one another in the range of their neighborhood.

In the literature there is a clear distinction between approaches that do not rely on cell division, and thus require that the environment is filled with cells at startup [2], and approaches where cells divide and migrate [4, 12]. In both case however, communication may be performed from one cell to another [2, 4] (direct cell-cell **mechanism) or diffused**
through the environment [12] (substrata diffusion mechanism of **chemicals**). A cell or group of cells "grows", or "develops", by interacting with the environment, usually at discrete time steps. This process stops at some point and the organism is evaluated w.r.t. the target objective. In all the works that are cited above, the growth stop is forced (development is stopped after a predefined number of steps). Defining an efficient endogenous stopping criterion can be related to addressing the halting problem **for Developmental Embryogeny.**
In this context, the model proposed in this paper has the following characteristics: a fixed number of cells are positioned on a two-dimensional non-toroidal array (no cell division or migration). The state of each cell is a vector or real values, and the controller is a Neural Network. Cells produce a predefined number of 'chemicals' that diffuse by a pure cell-cell communication mechanism. Time is discretized, and at each time step, the controller of each cell receives as inputs the quantities of chemicals produced by its neighboring cells (4-neighbors Von Neuman neighborhood is used - boundary cells receive nothing from outside the grid). The neural controller takes as external input the chemicals of the neighboring cells and computes a new state for the cell, as well as the concentrations of the chemicals to be sent to neighboring cells at next time step. No global information is available or transmitted from one cell to another –
the challenge is to reach a global target behavior from those local interactions.

As noted in the introduction, this model can be thought of as a simplified instance of Turing's reaction-diffusion model
[19], with discretized time and space. But it can also be considered as a very simple model of a Genetic Regulatory Network [1]. The topology of the network is fixed, all 'genes' produce the same 'proteins', but the activation/inhibition of protein production is given by the (non-linear) neural network function. Finally, looking beyond biological analogies, the proposed model can also be seen as a Continuous Cellular Automata [20], i.e. cellular automata with continuous states and discrete time, more precisely as a Cellular Neural Network [10], cellular automata where the update rule for each cell is given by a neural network, typically used in VLSI design.

## 2.1 The Neural Network Controller

In this work, the state of a cell, that is responsible for for both its differentiation (i.e. its phenotypic expression)
and the communication with other cells though the diffusion of chemicals, is a vector of real values: a single real value (gray level) in the 'flag' applications described in Section 3 - though more complex environments could require more complex differentiation states. Hence the widely used and studied model of Discrete Time, continuous state, Recurrent Neural Network (DTRNN) with sigmoidal transfer functions was chosen for the cell controllers. This choice of a Neural Network as a controller of the cells was inspired by the long-known property that Neural Networks are Universal Approximators [9]. The inputs of the Neural Network are the values of the chemical quantities coming from the 4 neighbors of the cell. Its outputs are the state of the cell