ber of iterations that are necessary to reach a given state depends on that state, but also on the organism. Moreover, it also most probably should depend on the conditions of the experiment: the dimension of the grid, the number of chemicals, . . .

Because there seems to be no general way to a priori determine the number of iterations that should be allocated to the organisms to reach a target phenotype, a good solution is probably to leave this parameter free, and to let evolution tune it.

One straightforward way to do so would be to compute the fitness of the organism at all stages of the iterative process, i.e. on all intermediate states of the cells. However, because such computation might be very heavy (for instance when designing mechanical structures, one often has to compute their fitness using some FEM analysis) this solution has been rejected. On the other hand, if we suppose that cell updates are cheap to compute compared to the actual fitness of a phenotype, it is possible to let the system iterate until it stabilizes. Of course, as is known from the Cellular Automata point of view [20], some systems will never stabilize, having either a chaotic behavior, or approaching some nonstationary attractor. However, one can hope that the set of systems that actually do reach a fixed point is rich enough to contain good solutions to the problem at hand.

The next challenge is to detect when the system stabilizes.

It is proposes here to compute some energy **of the system at**
each iteration, and to stop when this energy remains constant during a certain number of iterations.

More precisely, the energy of the system is computed as the sum of the activations of all neurons of all cells:

$$E(t)=\sum_{a l l n e u r o n s}a(t)^{2},$$

and the organism is considered stable when E(t) = E(t +
1) during a given number of time steps. Of course, a maximum number of iterations is given, and a genotype that hasn't converged after that time receives a very bad fitness:
such genotype has no phenotype, so the fitness cannot even be computed anyway. After such a final stable state for the organism has been reached, it is considered as the phenotype and undergo evaluation.

## 3. Experiments

Even though the long term goal of Developmental Design is to design mechanical structures (bridges, buildings, robots, . . . ), the computational cost of mechanical simulations makes such applications out of reach at the moment.

Moreover, the classical benchmarks that have been used to evaluate developmental approaches in recent works is the flag problem**, as originally proposed by Miller [13] and later**
used by other researchers in the field [4, 7].

The cells are the square tiles of a rectangular grid, like the pixels of a digitalized picture. At the end of the developmental phase, the cells must differentiate into a (generally discrete) color state so that the whole organism matches a given target picture. The rule of the game is that cells should of course have no access to information about the target picture, or to global informations like their absolute position in the grid. The only feedback from the target is the fitness of the phenotype, provided by a similarity measure. Pictures with simple patterns remains the most widely used, like the French or Norwegian flags.

![0_image_0.png](0_image_0.png)

Figure 2: The four target pictures

## 3.1 On Fitness And Flags

The problem is to define a similarity measure between the final state of the cells on the grid after differentiation
(i.e. each cell has a color) and the target flag. While most previous works use discrete states as color values, with 3 or 4 different states, the continuous values taken by the cell states in the Neural Network model allow a more precise sampling of the possible colors. Hence all experiments reported in the following use grayscale pictures with 256 gray levels: the output of the controller, that is in [0,1], is discretized, and the fitness is computed on the discrete values as follows.

The fitness measure is the similarity between the picture generated by the developmental process and the target picture. A smooth similarity s(A, B**) between two pictures** A
and B with both w × h **pixels is defined by:**

$$s(A,B)={\frac{1}{w h}}\sum_{i=0}^{h-1}\sum_{j=0}^{w-1}(A(i,j)-B(i,j))^{2}$$

The value s(A, B) lies in [0, **1], and reaches 1 if** A = B.

Four 32× **32 target pictures are used, that can be seen on**
Figure 2. The first picture is a simple 2-bands symmetrical picture with 2 colors. The 3-bands image contains 3 horizontal layers of different colors, and should be slightly more difficult to retrieve. However, because of the x-y bias of the chosen representation (information is transmitted horizontally or vertically), the last 2 images should be (and will be)
more difficult to grasp, as they contain circular patterns.

Note that because scalability is not the primary issue under study in this work, only pictures of this medium size
(compared to previous work on the flag problem) are used.

## 3.2 The Different Models

In order to explore different models within the general context described in Section 2, 4 instances of the proposed model are experimented with: a feedforward neural network, and 1 chemical, termed 1-ffwd**, a recurrent neural network**
with 1 chemical, termed 1-recurr**, a recurrent neural network**
with 2 chemicals, termed 2-recurr, a feedforward neural network, and 2 chemicals, termed**2-ffwd**.

However, there are (at least) two possible causes of error in the proposed approach: on the one hand, there might not exist any fixed point of the multi-cellular developmental systems under study that can approximate the target image; but on the other hand, even if a good solution does exist, the chosen computation method (evolutionary optimization of a neural network using NEAT) might not be able to approximate it. Note that this situation is common to all computational approaches of complex systems: the former error is termed 'modeling error' and the latter 'method error'. A third type of error is also reported in numerical experiments, the 'numerical error', due to propagating round-offs, and will be neglected here.