
## 4. Related Works And Discussion

This section discusses the proposed approach in the light of other works on multi-cellular embryogenies from the litterature.

The pioneering work by Julian Miller [12] belongs to the
'duplicating cells' category: Cells are allowed to duplicate, and growth starts with a single cell. Cells achieve communication by placing chemicals at their location and reading chemicals from their 8 neighbors. Moreover, a hand-written mechanism ensures their diffusion on the grid. Each cell can also differentiate into one of four cell types (one of the three colors, or the 'dead cell' tag) and each cell communicates its type to neighboring cells. The cell controller is designed as a boolean logic circuit optimized with Cartesian Genetic Programming [14] and the task is to find an organism that fits a 12x9 French flag. Experiments are conducted with a varying number of chemicals (from 0 to 4) and results showed that after 10 iterations, the french flag could be reproduced with nearly 95% similarity. Even more interesting results concerning self-repairing showed that with varying perturbations, the system could still recover and converge toward patterns that are somewhat similar (though not identical)
to the ones it would have achieved without perturbations.

In [4], Diego Federici extends Miller's work: again, only one single cell exists at iteration 0, and duplication is allowed. Each cell gets as input the 4 neighboring cell types and one single chemical concentration, resulting here also from a hand-written diffusion rule. The controller is a multilayer perceptron with fixed topology (only the weights are optimized) and the task is to fit a set of 9x6 flags (including the Norwegian flag). One interesting feature is that the optimization process is twisted to favor diversity, and implements a clever problem decomposition scheme named "multiple embryogenic stages" with convincing results.

The work by Gordon and Bentley [2] differs from previous approaches by considering only communication and differentiation in the substrata. The grid starts with a cell at all available grid points, and cells communicate by diffusing chemicals to neighboring cells only. Each cell then receives as input one chemical concentration, computed as the average of the concentrations of all neighboring cells: hence, no orientation information is available. In the Cellular Automata context, such system is called a totalistic automaton. One drawback of this approach is that it requires that some cells have different chemicals concentration at startup. Furthermore, it makes the whole model biased toward symmetrical patterns ("four-fold dihedral symmetry"). The controller is a set of 20 rules that produce one of the four chemicals and sends it towards neighboring cells. The set of rules is represented by a bit vector and is evolved using a classical bitstring GA. The paper ends with some comparisons with previous works, namely [4, 12], demonstrating comparable and sometimes better results. But a possible explanation for that success could be the above-mentionned bias of the method toward symmetrical patterns.

The approach proposed here shares some similarities with the approaches described above. The controller is defined as a neural networks, as in [4]; but in contrast to [4], both the topology and the weights are optimized, thanks to NEAT.

Further work should determine whether this difference is essential or not by running the same algorithm (i.e. with the stabilization incentive in the fitness) and multi-layer perceptron controllers.

However, there are even greater similarities between the present work and that in [2]. In both works, the grid is filled with cells at iteration 0 of the growth process (i.e. no replication is allowed) and chemicals are propagated only in a cellcell fashion without the diffusion mechanisms used in [4, 12].

Indeed, a pure cell-cell communication is theoretically sufficient for modelling any kind of temporal diffusion function, since diffusion in the substrata is the result of successive transformation with non-linear functions (such as the ones implemented by sigmoidal neural networks with hidden neurons). However, this means that the optimization algorithm must tune both the diffusion reaction and the differentiation of the cells. On the other hand, whereas [2] only consider the average of the chemical concentrations of the neighboring cells (i.e. is totalistic **in the Cellular Automata terminology), our approach does take into account the topology**
of the organism at the controller level, de facto benefitting from orientation information. This results in a more general approach, though probably less efficient to reach symmetrical targets. Here again, further experiments must be run to give a solid answer.

But two main issues contribute to the originality of the approach proposed here: (1) the output for cell differentiation is a continuous value, and (2) the halting problem is indirectly addressed through the fitness function, that favors convergence towards a stable state (i.e. a fixed point).

Indeed, all other works consider that a cell may differentiate into one of a given set of discrete states (e.g. blue, red, and white) while output is considered here as a continuous value (discretized into a 256-gray level value). At first sight, this can be thought as making the problem harder by increasing the size of the search space. However, it turns out that a continuous output results in a rather smooth fitness landscape, something that is known to be critical for Evolutionary Algorithms. Additional experiments (not reported here) did demonstrate that it was much harder to solve the same flag problems when discretizing the controller outputs before computing the fitness (Section 3.1). Indeed, discretized outputs lead to a piecewise constant fitness landscape and the algorithm has no clue about where to go on such flat plateaus. However, here again, more experiments are needed before drawing strong conclusions.

Secondly, from a dynamical system viewpoint, the objective function can be seen as selecting only the organisms that do reach a fixed point, starting from given initial conditions defined as uniformly initialized cells. First, all previous works needed to a priori decide the number of iterations that growth would use, and it is clear that such parameter is highly problem dependent, and hence should made adaptive if possible. But more than that, the good news is the strength of the fixed point reached by the organism, its attracting power when starting from other initial conditions -
that is, an extreme case of self-healing capabilities against perturbations for the organism. Of course, previous works [12] already noted the growth process is remarkably stable under perturbations, and is able to reach a pattern quite similar (though not identical) to the original target pattern.

However, it should be noted that the organisms evolved in
[12] keep on growing if growth is continued after the fixed number of iterations, and eventually turn out to completely diverge from the target pattern. Similarly, [4] observes that