a perturbation in the earlier stages of development leads to an increase in the disruption of the final pattern that is linear with respect to the number of development steps. Robustness towards perturbation was later confirmed and more thoroughly studied in [6].

But, as demonstrated by the experiments shown in Section 3.4.2, our model achieves astounding results regarding the self-healing property. Starting from completely random conditions (i.e. inputs and outputs set to random values),
the system is able to perform a 100% recovery and to converge to the exact pattern that was reached during evolution
(i.e. when starting with value 0 for all neuron activations).

Some runs were performed without the stabilization criterion, the final individuals never shown such properties. This seems to be a clear consequence of the way stabilization is favored in the fitness function - though the precise reason for the extraordinary absorbing property of all fixed points reached in the experiments so far remains to be understood.

## 5. Conclusion

This paper has introduced a continuous Neural Network model for Multi-Cellular Developmental Design. The Neural Network is evolved using the state-of-the-art NEAT algorithm that optimizes both the topology and the weights of the network, and can evolve both feedforward and recurrent neural networks. The model was validated on four instances of the 'flag' problem, and on 3 out of 4 instances it performed as good as NEAT applied to the equivalent regression problem: this is a hint that the modeling error of the developmental approach is not much bigger than that of the Neural Network approach for regression (which is proved to be small, thanks to the Universal Approximator property),
and is in any case small compared to the computational error
(i.e. the error done by NEAT when searching the globally optimal network).

But the most salient feature of this model lies in the stopping criterion for the growth process: whereas most previous work required to a priori decide on a number of iterations, the proposed algorithm selects organisms that reach a fixed point, making the stopping criterion implicitly adaptive. The major (and somewhat unexpected) consequence of this adaptivity is the tremendous robustness toward perturbations during the growth process: in almost all experiments, the fixed point that is reached from the initial state used during evolution (all neural activations set to 0) seems to be a global attractor, in the sense that the organism will end up there from any starting point.

## 6. References

[1] W. Banzhaf. On the dynamics of an artificial regulatory network. In ECAL'03**, pages 217–227, 2003.**
[2] P. Bentley. Investigations into graceful degradation of evolutionary developmental software. **Natural** Computing**, 4(4):417–437, 2005.**
[3] P. Bentley and S. Kumar. Three ways to grow designs:
A comparison of embryogenies for an evolutionary design problem. In W. B. et al., editor, **GECCO'99**, pages 35–43. Morgan Kaufmann, 1999.

[4] D. Federici. Increasing evolvability for developmental programs. In J. Miller, editor, **Workshop on**
Regeneration and Learning in Developmental Systems, WORLDS 2004**, 2004.**
[5] D. Federici and K. Downing. Evolution and development of a multicellular organism: scalability, resilience, and neutral complexification. **Artificial Life**, 12(3):381–409, 2006.

[6] D. Federici and T. Ziemke. Why are evolved developing organisms also fault-tolerant? In **SAB'06**,
pages 449–460, 2006.

[7] T. G. W. Gordon and P. J. Bentley. Bias and scalability in evolutionary development. In **GECCO**
'05**, pages 83–90. ACM Press, 2005.**
[8] F. Gruau. Genetic micro programming of neural networks. In K. E. Kinnear Jr., editor, **Advances in**
GP**, pages 495–518. MIT Press, 1994.**
[9] K. Hornik, M. Stinchcombe, and H. White. Multilayer feedforward networks are universal approximators.

Neural Networks**, pages 359–366, 1989.**
[10] L. Y. L. O. Chua. Cellular neural networks:
Applications. **IEEE Trans. on Circuits and Systems**,
35(10):1273–1290, 1988.

[11] Z. Michalewicz. **Genetic Algorithms + Data Structures**
= Evolution Programs**. Springer Verlag, New-York,**
1992-1996. 1st-3rd edition.

[12] J. F. Miller. Evolving a self-repairing, self-regulating, french flag organism. In GECCO**, pages 129–139, 2004.**
[13] J. F. Miller and W. Banzhaf. Evolving the program for a cell: from french flags to boolean circuits. In S. Kumar and P. J. Bentley, editors, **On Growth,** Form and Computers**. Academic Press, 2003.**
[14] J. F. Miller and P. Thomson. Cartesian genetic programming. In P. et al, editor, EuroGP'00**, pages** 121–132. LNCS 1802, Springer-Verlag, 2000.

[15] D. Roggen and D. Federici. Multi-cellular development: Is there scalability and robustness to gain? In X. Y. et al., editor, PPSN'04**, pages 391–400.** LNCS 3242, Springer Verlag, 2004.

[16] K. Sims. Evolving virtual creatures. In SIGGRAPH'94**, pages 15–22. ACM Press, July 1994.**
[17] K. O. Stanley and R. Miikkulainen. Evolving neural networks through augmenting topologies. **Evolutionary** Computation**, 10(2):99–127, 2002.**
[18] K. O. Stanley and R. Miikkulainen. A taxonomy for artificial embryogeny. Artificial Life**, 9(2):93–130,** 2003.

[19] A. M. Turing. The chemical basis of morphogenesis.

Philosophical Transactions of the Royal Society of London, Series B, Biological sciences, B
237(641):37–72, Aug. 1952.

[20] S. Wolfram. A new kind of science**. Wolfram Media,**
2002.