# Fault Classification Using Pseudomodal Energies And Neuro-Fuzzy Modelling

TSHILIDZI MARWALA, THANDO TETTEY AND SNEHASHISH CHAKRAVERTY

## __________________________________________________________________________________________________________ Abstract:

This paper presents a fault classification method which makes use of a Takagi-Sugeno neuro-fuzzy model and Pseudomodal energies calculated from the vibration signals of cylindrical shells. The calculation of Pseudomodal Energies, for the purposes of condition monitoring, has previously been found to be an accurate method of extracting features from vibration signals. This calculation is therefore used to extract features from vibration signals obtained from a diverse population of cylindrical shells. Some of the cylinders in the population have faults in different substructures. The pseudomodal energies calculated from the vibration signals are then used as inputs to a neuro-fuzzy model. A leave-one-out cross-validation process is used to test the performance of the model. It is found that the neuro-fuzzy model is able to classify faults with an accuracy of 91.62%, which is higher than the previously used multilayer perceptron. 

## Introduction

The process of monitoring and identifying faults in structures is of great importance in aerospace, civil and mechanical engineering. Aircraft operators must be sure that aircraft are free from cracks. Bridges and buildings nearing the end of their useful life must be assessed for load-bearing capacities. Cracks in turbine blades lead to catastrophic failure of aero-engines and must be detected early. Many techniques have been employed in the past to locate and identify faults. Some of these are visual (e.g. dye penetrant methods) and others use sensors to detect local faults (e.g. acoustics, magnetic field, eddy current, radiographs and thermal fields). These methods are time consuming and cannot indicate that a structure is fault-free without testing the entire structure in minute detail. Furthermore, if a fault is buried deep within the structure it may not be visible or detectable by these localised techniques. The need to detect faults in complicated structures has led to the development of global methods which are able to utilise changes in the vibration characteristics of the structure as a basis of fault detection [1]. 

There are four main methods by which vibration data may be represented: time, modal, frequency and time-frequency domains. Raw data is obtained from measurement made in the time domain. From the time domain, Fourier transform techniques may then be used to transform data into the frequency domain. ____________ University of the Witwatersrand, {t.tettey, t.marwala}@ee.wits.ac.za. Central Building Research Institute, sne_chak@yahoo.com 