From the frequency domain data, and sometimes directly from the time domain, the modal properties may be extracted. All of these domains theoretically contain similar information but in reality this is not necessarily the **case. Because the time domain data** are relatively difficult to interpret, they have not been used extensively for fault identification, and for this reason, the modal properties have been widely considered. In this paper we use the pseudomodal, defined from the Frequency Response Function (FRF), together with a Takagi-Sugeno (TS) Neuro-fuzzy model to classify faults in a population of cylindrical shells. 

## Background Pseudomodal Energies

In this work, Pseudomodal Energies are used for the classification of faults in cylinders. Pseudomodal energies have been found to allow for better classification of faults when compared to modal properties. Pseudomodal energy is defined as the integral of the frequency response function (FRF) over various frequency bandwidths [2]. The FRF is defined as the ratio of the Fourier transformed response to the Fourier transformed force. The pseudomodal energies are therefore the intergral of the real and imaginary parts of the FRFs over various frequency ranges that bracket the natural frequencies. 

On one hand, receptance expression of the FRF is defined as the ratio of the frequency response of displacement to the frequency response of force. On the other hand, inertance expression of the FRF is defined as the ratio of the frequency response of acceleration to the frequency response of force. Similarly, the pseudomodal energies can be expressed in terms of the receptance and inertance. The commonly used techniques of collecting vibration data involve measuring the acceleration response and therefore it is more useful to calculate the inertance pseudomodal energies. The inertance pseudomodal energy is derived by integrating the inertance FRF written in terms of the modal properties by using the modal summation equation as follows 

$${\rm IME}_{\rm kl}^{\rm q}=\int_{\rm a_{q}}^{\rm b_{q}}\sum_{\rm i=1}^{\rm N}\frac{-\omega^{2}\varphi_{\rm k}^{\rm i}\varphi_{\rm i}^{\rm i}}{-\omega^{2}+2\zeta_{\rm i}\omega_{\rm i}\omega{\rm j}+\omega}{\rm d}\omega\.$$
$$\mathrm{(1)}$$

where q a **and** q b **represent, respectively, the lower and the upper frequency bounds** 
for the qth pseudomodal energy calculated from the FRF due to excitation at k **and** 
measurement at l. N **is the number of mode and** ζ i is the damping ratio of mode i**. For a** 
detailed derivation of this equation consult [3]. Assuming the damping is low, Eq (1) becomes [2]: 

$$IME_{kl}^{\rm o}\approx\sum_{i=1}^{N}\left\{\phi_{i}^{\rm i}\phi_{l}^{\rm i}(b_{q}-a_{q})-\omega_{i}\phi_{i}^{\rm i}\phi_{i}^{\rm i}\right\}\left[\arctan\left(\frac{-\zeta_{i}\omega_{i}-jb_{q}}{\omega_{i}}\right)-\arctan\left(\frac{-\zeta_{i}\omega_{i}-ja_{q}}{\omega_{i}}\right)\right]\right\}\tag{2}$$  The advantage in using IMEs over the use of the modal properties is that all the modes

in the structure are taken into account as opposed to using the modal properties, which are 