limited by the number of modes identified; and integrating the FRFs to obtain the pseudomodal energies smoothes out the zero-mean noise present in the FRFs. 

## Neuro-Fuzzy Modelling

A fuzzy inference system is a model that takes a fuzzy set as an input and performs a composition to arrive at the output based on the concepts of fuzzy set theory, fuzzy *if-then* rules and fuzzy reasoning [4]. Simply put, the Fuzzy inference procedure involves: the fuzzification of the input variables, evaluation of rules, aggregation of the rule outputs and finally the defuzzification of the result. There are two popular types of fuzzy models: the Mamdani model and the Takagi-Sugeno model. The Takagi-Sugeno model is popular when it comes to data-driven identification and is used in this study. In this model the antecedent part of the rule is a fuzzy proposition and the consequent is an affine linear function of the input variables as shown in (3) [5]. 

$$\mathbf{R}_{i}:\mathrm{If\xis\A}_{i}(\mathbf{x})\,\mathrm{then\}y_{i}=\mathbf{a}_{i}^{T}\mathbf{x}+b_{i},[w_{i}]$$
$$({\mathfrak{I}})$$
$$\cdot1,2....,K$$

Where i a is the consequence parameter vector, i b is a scalar offset and i = 2,1 **...,**K . 

The symbol K is the number of fuzzy rules in the model and ]1,0[ wi ∈ **is the weight of** 
the rule. The antecedent propositions in the model describe the fuzzy regions in the input space in which the consequent functions are valid and can be stated in the following conjunctive form: 

If: is ( ) and ... and is ( ) then i 1 i 1, 1 n i,n n R x A x x A x a x [ , . ]
$${\bf n}\stackrel{\wedge}{\bf y}={\bf a}_{i}^{T}{\bf x}+b_{i},[w_{i}]\,.$$
 (4) 
The degree of fulfilment of the i**th rule is calculated as the product of the individual** 
membership degrees and the rule's weight: 

$$\beta_{i}(x)=w_{i}\mathbf{A}_{i}(\mathbf{x})=w_{i}\prod_{j=1}^{n}A_{i,j}(x_{j})$$

 The output y **is then computed by taking a weighted average of the individual rules'** 
contributions as shown below: 

$$y=\frac{\sum_{i=1}^{K}\beta_{i}(\mathbf{x})y_{i}}{\sum_{i=1}^{K}\beta_{i}(\mathbf{x})}=\frac{\sum_{i=1}^{K}\beta_{i}(\mathbf{x})(\mathbf{a}_{i}^{T}\mathbf{x}+b_{i})}{\sum_{i=1}^{K}\beta_{i}(\mathbf{x})}\tag{6}$$
$$\left({\mathcal{A}}\right)$$
$$(5)$$

Where )x( β i is the degree of fulfilment of the i **th rule. The parameters** i a are then approximate models of the considered nonlinear system. 

Fuzzy rule-based systems with learning ability, also known as neuro-fuzzy networks 
[6], will be considered in this work. This system will be referred to as a neuro-fuzzy system (model) from here onwards. There are two approaches to training neuro-fuzzy models [7]: 